/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.structureView;

import com.google.common.collect.Lists;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.jetbrains.mako.MakoElementTypes;
import com.jetbrains.mako.MakoTokenTypes;
import com.jetbrains.mako.psi.MakoTagBlock;
import com.jetbrains.mako.psi.impl.MakoCall;
import com.jetbrains.mako.psi.impl.MakoCodeBlock;
import com.jetbrains.mako.psi.impl.MakoFunction;
import com.jetbrains.mako.psi.impl.MakoNamespace;
import com.jetbrains.mako.psi.impl.MakoTag;
import com.jetbrains.mako.psi.impl.MakoTagAttribute;
import com.jetbrains.mako.psi.impl.MakoTagBlockImpl;
import com.jetbrains.mako.structureView.MakoStructureViewUtil;
import com.jetbrains.mako.structureView.MakoXmlTagTreeElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MakoStructureViewElement
implements StructureViewTreeElement {
    private final NavigatablePsiElement myElement;
    private final TemplateLanguageFileViewProvider myViewProvider;

    public MakoStructureViewElement(NavigatablePsiElement element, TemplateLanguageFileViewProvider viewProvider) {
        this.myElement = element;
        this.myViewProvider = viewProvider;
    }

    public NavigatablePsiElement getValue() {
        return this.myElement;
    }

    public void navigate(boolean requestFocus) {
        this.myElement.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myElement.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myElement.canNavigateToSource();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            public String getPresentableText() {
                String name = MakoStructureViewElement.this.myElement.getName();
                if (StringUtil.isEmptyOrSpaces((String)name)) {
                    name = MakoStructureViewElement.this.myElement.getText();
                }
                String unnamed = "<unnamed>";
                if (MakoStructureViewElement.this.myElement instanceof MakoCodeBlock) {
                    return "python code block ";
                }
                if (MakoStructureViewElement.this.myElement instanceof MakoFunction) {
                    return "def";
                }
                if (MakoStructureViewElement.this.myElement instanceof MakoNamespace) {
                    return "namespace";
                }
                if (MakoStructureViewElement.this.myElement instanceof MakoCall) {
                    return StringUtil.notNullize((String)((MakoCall)MakoStructureViewElement.this.myElement).getQualifiedName(), (String)"<unnamed>");
                }
                if (MakoStructureViewElement.this.myElement instanceof MakoTagBlockImpl) {
                    return StringUtil.notNullize((String)MakoStructureViewElement.this.myElement.getName(), (String)"<unnamed>");
                }
                return name;
            }

            @Nullable
            public String getLocationString() {
                if (MakoStructureViewElement.this.myElement instanceof MakoTagBlock) {
                    StringBuilder result = new StringBuilder();
                    NavigatablePsiElement openTag = (NavigatablePsiElement)PsiTreeUtil.getChildOfType((PsiElement)MakoStructureViewElement.this.myElement, MakoTag.class);
                    if (openTag == null) {
                        openTag = MakoStructureViewElement.this.myElement;
                    }
                    List attributes = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)openTag, MakoTagAttribute.class);
                    for (MakoTagAttribute attr : attributes) {
                        result.append(attr.getText()).append(" ");
                    }
                    return result.toString();
                }
                return null;
            }

            public Icon getIcon(boolean open2) {
                return PlatformIcons.XML_TAG_ICON;
            }
        };
    }

    public TreeElement @NotNull [] getChildren() {
        if (!this.myElement.isValid()) {
            if (EMPTY_ARRAY == null) {
                MakoStructureViewElement.$$$reportNull$$$0(0);
            }
            return EMPTY_ARRAY;
        }
        TreeMap<Integer, StructureViewTreeElement> children2 = new TreeMap<Integer, StructureViewTreeElement>();
        ArrayList xmlElements = Lists.newArrayList();
        this.collectChildren(children2, (PsiElement)this.myElement, xmlElements);
        TreeElement[] treeElementArray = children2.values().toArray(TreeElement.EMPTY_ARRAY);
        if (treeElementArray == null) {
            MakoStructureViewElement.$$$reportNull$$$0(1);
        }
        return treeElementArray;
    }

    private void collectChildren(Map<Integer, StructureViewTreeElement> result, PsiElement element, List<PsiElement> xmlElements) {
        PsiElement[] children2 = (PsiElement[])ArrayUtil.reverseArray((Object[])element.getChildren());
        for (PsiElement child : children2) {
            ASTNode node = child.getNode();
            if (node.getElementType() == MakoElementTypes.MAKO_STATEMENT_LIST) {
                xmlElements.addAll(MakoStructureViewUtil.findAllElementsInsideOfLanguage(child, this.myViewProvider, this.myViewProvider.getTemplateDataLanguage()));
                continue;
            }
            if (node.getElementType() != MakoTokenTypes.TEMPLATE_CHARACTERS) continue;
            xmlElements.addAll(MakoStructureViewUtil.findAllElementsInsideTemplateChars(child, this.myViewProvider, this.myViewProvider.getTemplateDataLanguage()));
        }
        for (PsiElement child : children2) {
            if (MakoStructureViewUtil.inXmlTag(child, xmlElements)) continue;
            if (child instanceof MakoFunction || child instanceof MakoCodeBlock || child instanceof MakoTagBlockImpl || child instanceof MakoCall) {
                NavigatablePsiElement namedElement = (NavigatablePsiElement)child;
                String name = namedElement.getName();
                if (StringUtil.isEmptyOrSpaces((String)name)) {
                    name = namedElement.getText();
                }
                if (StringUtil.isEmptyOrSpaces((String)name)) continue;
                result.put(namedElement.getTextOffset(), new MakoStructureViewElement(namedElement, this.myViewProvider));
                continue;
            }
            this.collectChildren(result, child, xmlElements);
        }
        for (PsiElement tag : xmlElements) {
            if (!(tag instanceof XmlTag)) continue;
            result.put(tag.getTextOffset(), (StructureViewTreeElement)new MakoXmlTagTreeElement((XmlTag)tag, this.myViewProvider));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/mako/structureView/MakoStructureViewElement", "getChildren"));
    }
}

