/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mako.structureView;

import com.google.common.collect.Lists;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import com.jetbrains.mako.psi.MakoTagBlock;
import com.jetbrains.mako.psi.impl.MakoCodeBlock;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MakoStructureViewUtil {
    public static boolean inXmlTag(PsiElement makoElement, List<? extends PsiElement> xmlElements) {
        for (PsiElement psiElement : xmlElements) {
            if (!(psiElement instanceof XmlTag) || !psiElement.getTextRange().contains(makoElement.getTextRange())) continue;
            return true;
        }
        return false;
    }

    public static boolean inMakoTag(PsiElement xmlElement, List<? extends PsiElement> makoTags) {
        for (PsiElement psiElement : makoTags) {
            if (!(psiElement instanceof MakoCodeBlock) && !(psiElement instanceof MakoTagBlock) || !psiElement.getTextRange().contains(xmlElement.getTextRange())) continue;
            return true;
        }
        return false;
    }

    public static List<PsiElement> findAllElementsInsideOfLanguage(PsiElement element, TemplateLanguageFileViewProvider viewProvider, Language language) {
        PsiElement innerElement = viewProvider.findElementAt(element.getTextRange().getStartOffset(), language);
        ArrayList list = Lists.newArrayList();
        if (innerElement != null) {
            for (PsiElement biggestInner = MakoStructureViewUtil.biggestElementInside(element, innerElement); biggestInner != null && biggestInner.getTextRange().getEndOffset() <= element.getTextRange().getEndOffset(); biggestInner = biggestInner.getNextSibling()) {
                list.add(biggestInner);
            }
        }
        return list;
    }

    @NotNull
    private static PsiElement biggestElementInside(@NotNull PsiElement element, @NotNull PsiElement innerElement) {
        if (element == null) {
            MakoStructureViewUtil.$$$reportNull$$$0(0);
        }
        if (innerElement == null) {
            MakoStructureViewUtil.$$$reportNull$$$0(1);
        }
        while (innerElement.getParent() != null && !(innerElement.getParent() instanceof XmlDocument) && innerElement.getParent().getTextRange() != null && !MakoStructureViewUtil.containsButNotEqual(innerElement.getParent().getTextRange(), element.getTextRange())) {
            innerElement = innerElement.getParent();
        }
        PsiElement psiElement = innerElement;
        if (psiElement == null) {
            MakoStructureViewUtil.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    private static boolean containsButNotEqual(@NotNull TextRange biggerRange, @NotNull TextRange smallerRange) {
        if (biggerRange == null) {
            MakoStructureViewUtil.$$$reportNull$$$0(3);
        }
        if (smallerRange == null) {
            MakoStructureViewUtil.$$$reportNull$$$0(4);
        }
        return biggerRange.contains(smallerRange) && !biggerRange.equals((Object)smallerRange);
    }

    public static List<PsiElement> findAllElementsInsideTemplateChars(PsiElement element, TemplateLanguageFileViewProvider viewProvider, Language language) {
        PsiElement innerElement = viewProvider.findElementAt(element.getTextRange().getStartOffset(), language);
        ArrayList list = Lists.newArrayList();
        for (PsiElement biggestInner = MakoStructureViewUtil.biggestElementInsideTemplateChars(innerElement); biggestInner != null && biggestInner.getTextRange().getEndOffset() <= element.getTextRange().getEndOffset(); biggestInner = biggestInner.getNextSibling()) {
            list.add(biggestInner);
        }
        return list;
    }

    @NotNull
    private static PsiElement biggestElementInsideTemplateChars(@NotNull PsiElement innerElement) {
        if (innerElement == null) {
            MakoStructureViewUtil.$$$reportNull$$$0(5);
        }
        while (innerElement.getParent() != null && !(innerElement.getParent() instanceof XmlDocument) && innerElement.getParent().getTextRange() != null) {
            innerElement = innerElement.getParent();
        }
        PsiElement psiElement = innerElement;
        if (psiElement == null) {
            MakoStructureViewUtil.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerElement";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/mako/structureView/MakoStructureViewUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "biggerRange";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smallerRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/mako/structureView/MakoStructureViewUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "biggestElementInside";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "biggestElementInsideTemplateChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "biggestElementInside";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "containsButNotEqual";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "biggestElementInsideTemplateChars";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

