/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.pyramid.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.pyramid.run.PyramidRunConfiguration;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PythonCommandLineState;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PyramidRunCommandLineState
extends PythonCommandLineState {
    private final PyramidRunConfiguration myConfig;

    public PyramidRunCommandLineState(PyramidRunConfiguration config, ExecutionEnvironment environment) {
        super(config, environment);
        this.myConfig = config;
    }

    @Override
    protected void buildCommandLineParameters(GeneralCommandLine commandLine) {
        String additionalOptions;
        ParametersList parametersList = commandLine.getParametersList();
        ParamsGroup exeOptions = parametersList.getParamsGroup("Exe Options");
        assert (exeOptions != null);
        exeOptions.addParametersString(this.myConfig.getInterpreterOptions());
        ParamsGroup scriptParameters = parametersList.getParamsGroup("Script");
        assert (scriptParameters != null);
        PythonHelper.LOAD_ENTRY_POINT.addToGroup(scriptParameters, commandLine);
        String myConfigTarget = this.myConfig.getConfigFile();
        if (myConfigTarget != null) {
            scriptParameters.addParametersString("\"" + myConfigTarget + "\"");
        }
        if (!StringUtil.isEmptyOrSpaces((String)(additionalOptions = this.myConfig.getAdditionalOptions()))) {
            scriptParameters.addParameters(additionalOptions.split(" "));
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myConfig.getWorkingDirectory())) {
            commandLine.setWorkDirectory(this.myConfig.getWorkingDirectory());
        }
    }

    @Override
    public void customizeEnvironmentVars(Map<String, String> environment, boolean passParentEnvs) {
        super.customizeEnvironmentVars(environment, passParentEnvs);
        environment.put("PYCHARM_EP_DIST", "pyramid");
        environment.put("PYCHARM_EP_NAME", "pserve");
    }

    @Override
    @NotNull
    protected ProcessHandler startProcess(PythonCommandLineState.PythonProcessStarter processStarter, CommandLinePatcher ... patchers2) throws ExecutionException {
        ProcessHandler processHandler2 = super.startProcess(processStarter, patchers2);
        PyramidRunCommandLineState.addRunBrowserListener(processHandler2, this.myConfig.getBrowserUrl(), "Starting server in");
        ProcessHandler processHandler3 = processHandler2;
        if (processHandler3 == null) {
            PyramidRunCommandLineState.$$$reportNull$$$0(0);
        }
        return processHandler3;
    }

    public static void addRunBrowserListener(ProcessHandler processHandler2, final String url, final String signature) {
        if (!StringUtil.isEmpty((String)url)) {
            final Ref browserStarted = new Ref((Object)false);
            processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event2, @NotNull Key outputType) {
                    if (event2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (((Boolean)browserStarted.get()).booleanValue()) {
                        return;
                    }
                    if (event2.getText().contains(signature)) {
                        browserStarted.set((Object)true);
                        BrowserUtil.browse((String)url);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/pyramid/run/PyramidRunCommandLineState$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/pyramid/run/PyramidRunCommandLineState", "startProcess"));
    }
}

