/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.concurrency.model;

import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.debugger.PyConcurrencyEvent;
import com.jetbrains.python.debugger.PyLockEvent;
import com.jetbrains.python.debugger.concurrency.model.ConcurrencyGraphBlock;
import com.jetbrains.python.debugger.concurrency.model.ConcurrencyGraphModel;
import com.jetbrains.python.debugger.concurrency.model.ConcurrencyGraphVisualSettings;
import com.jetbrains.python.debugger.concurrency.model.ConcurrencyRelation;
import com.jetbrains.python.debugger.concurrency.tool.panels.ConcurrencyToolWindowPanel;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConcurrencyGraphPresentationModel {
    @NotNull
    private final ConcurrencyGraphModel graphModel;
    @NotNull
    private final ConcurrencyGraphVisualSettings visualSettings;
    @NotNull
    private final ConcurrencyToolWindowPanel myToolWindowPanel;
    @NotNull
    private final List<PresentationListener> myListeners;
    @NotNull
    private final Object myListenersObject;
    @NotNull
    private ArrayList<ConcurrencyGraphBlock> myVisibleGraph;
    @NotNull
    private final Object myVisibleGraphObject;
    @NotNull
    private ArrayList<ConcurrencyRelation> myRelations;
    private boolean myScrollToTheEnd;
    private boolean isGraphChanged;
    private ConcurrencyGraphBlock @Nullable [] myGraphForDrawing;

    public ConcurrencyGraphPresentationModel(final @NotNull ConcurrencyGraphModel graphModel, @NotNull ConcurrencyToolWindowPanel panel2) {
        if (graphModel == null) {
            ConcurrencyGraphPresentationModel.$$$reportNull$$$0(0);
        }
        if (panel2 == null) {
            ConcurrencyGraphPresentationModel.$$$reportNull$$$0(1);
        }
        this.myListeners = new ArrayList<PresentationListener>();
        this.myListenersObject = new Object();
        this.myVisibleGraphObject = new Object();
        this.myScrollToTheEnd = true;
        this.isGraphChanged = false;
        this.graphModel = graphModel;
        this.visualSettings = new ConcurrencyGraphVisualSettings(this);
        this.myToolWindowPanel = panel2;
        this.myVisibleGraph = new ArrayList();
        this.myRelations = new ArrayList();
        this.graphModel.registerListener(new ConcurrencyGraphModel.GraphListener(){

            @Override
            public void graphChanged() {
                if (ConcurrencyGraphPresentationModel.this.myScrollToTheEnd && !graphModel.isLastSessionStopped()) {
                    ConcurrencyGraphPresentationModel.this.visualSettings.scrollToTheEnd();
                }
                UIUtil.invokeLaterIfNeeded(() -> {
                    JTable table = ConcurrencyGraphPresentationModel.this.myToolWindowPanel.getStatTable();
                    if (table != null) {
                        ((AbstractTableModel)table.getModel()).fireTableDataChanged();
                    }
                    if ((table = ConcurrencyGraphPresentationModel.this.myToolWindowPanel.getNamesTable()) != null) {
                        ((AbstractTableModel)table.getModel()).fireTableDataChanged();
                    }
                });
                ConcurrencyGraphPresentationModel.this.updateGraphModel();
                ConcurrencyGraphPresentationModel.this.notifyListeners();
            }
        });
        this.updateTimerPeriod();
    }

    public boolean isScrollToTheEnd() {
        return this.myScrollToTheEnd;
    }

    public void setScrollToTheEnd(boolean scrollToTheEnd) {
        this.myScrollToTheEnd = scrollToTheEnd;
    }

    public void updateTimerPeriod() {
        int rulerUnitWidth = 1 * this.visualSettings.getCellsPerRulerUnit();
        this.graphModel.setTimerPeriod(Math.max(1, this.visualSettings.getCellsPerRulerUnit() * this.visualSettings.getMcsPerCell() / (rulerUnitWidth * 1000)));
    }

    @NotNull
    public ConcurrencyToolWindowPanel getToolWindowPanel() {
        ConcurrencyToolWindowPanel concurrencyToolWindowPanel = this.myToolWindowPanel;
        if (concurrencyToolWindowPanel == null) {
            ConcurrencyGraphPresentationModel.$$$reportNull$$$0(2);
        }
        return concurrencyToolWindowPanel;
    }

    public void updateGraphModel() {
        this.updateVisibleGraph();
        this.notifyListeners();
    }

    public int getCellsNumber() {
        return (int)this.graphModel.getDuration() / this.visualSettings.getMcsPerCell();
    }

    private long roundForCell(long time) {
        long millisPerCell = this.visualSettings.getMcsPerCell();
        return time - time % millisPerCell;
    }

    @NotNull
    public ArrayList<ConcurrencyRelation> getRelations() {
        return new ArrayList<ConcurrencyRelation>(this.myRelations);
    }

    @NotNull
    public ConcurrencyGraphModel getGraphModel() {
        ConcurrencyGraphModel concurrencyGraphModel = this.graphModel;
        if (concurrencyGraphModel == null) {
            ConcurrencyGraphPresentationModel.$$$reportNull$$$0(3);
        }
        return concurrencyGraphModel;
    }

    @NotNull
    public ConcurrencyGraphVisualSettings getVisualSettings() {
        ConcurrencyGraphVisualSettings concurrencyGraphVisualSettings = this.visualSettings;
        if (concurrencyGraphVisualSettings == null) {
            ConcurrencyGraphPresentationModel.$$$reportNull$$$0(4);
        }
        return concurrencyGraphVisualSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVisibleGraph() {
        Object object = this.myVisibleGraphObject;
        synchronized (object) {
            if (this.visualSettings.getHorizontalMax() == 0 || this.graphModel.getSize() == 0) {
                this.myVisibleGraph = new ArrayList();
                return;
            }
            long startTime = this.roundForCell((long)this.visualSettings.getHorizontalValue() * this.graphModel.getDuration() / (long)this.visualSettings.getHorizontalMax());
            this.myVisibleGraph = new ArrayList();
            this.myRelations = new ArrayList();
            long nextTime = startTime;
            int i = 0;
            int numberOfCells = this.visualSettings.getHorizontalExtent() / 1 + 2;
            for (int curEventId = this.graphModel.getLastEventIndexBeforeMoment(startTime); i < numberOfCells && curEventId < this.graphModel.getSize() - 1; ++curEventId) {
                PyConcurrencyEvent event2;
                long period;
                int cellsInPeriod;
                long curTime = nextTime;
                Point relation = this.graphModel.getRelationForRow(curEventId);
                if (relation != null) {
                    this.myRelations.add(new ConcurrencyRelation(i, relation.x, relation.y, this.graphModel.getThreadStateForEvent(curEventId, relation.x)));
                }
                if ((cellsInPeriod = (int)((period = (nextTime = (event2 = this.graphModel.getEventAt(curEventId + 1)) == null ? curTime : this.roundForCell(event2.getTime())) - curTime) / (long)this.visualSettings.getMcsPerCell())) == 0) continue;
                this.myVisibleGraph.add(new ConcurrencyGraphBlock(this.graphModel.getDrawElementsForRow(curEventId), cellsInPeriod));
                i += cellsInPeriod;
            }
            this.isGraphChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrencyGraphBlock[] getVisibleGraph() {
        Object object = this.myVisibleGraphObject;
        synchronized (object) {
            if (this.isGraphChanged) {
                this.myGraphForDrawing = new ConcurrencyGraphBlock[this.myVisibleGraph.size()];
                this.myGraphForDrawing = this.myVisibleGraph.toArray(this.myGraphForDrawing);
                this.isGraphChanged = false;
            }
        }
        return this.myGraphForDrawing;
    }

    public void applySelectionFilter(int eventId) {
        @Nullable PyConcurrencyEvent event2 = this.graphModel.getEventAt(eventId);
        if (event2 == null) {
            return;
        }
        if (event2 instanceof PyLockEvent && event2.getType() != PyConcurrencyEvent.EventType.RELEASE) {
            PyLockEvent lockEvent = (PyLockEvent)event2;
            String lockId = lockEvent.getLockId();
            this.graphModel.setFilterLockId(lockId);
        } else if (event2.getType() == PyConcurrencyEvent.EventType.STOP) {
            this.graphModel.setFilterLockId(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(@NotNull PresentationListener logListener) {
        if (logListener == null) {
            ConcurrencyGraphPresentationModel.$$$reportNull$$$0(5);
        }
        Object object = this.myListenersObject;
        synchronized (object) {
            this.myListeners.add(logListener);
        }
    }

    public int getPadding() {
        return this.visualSettings.getHorizontalValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        Object object = this.myListenersObject;
        synchronized (object) {
            for (PresentationListener logListener : this.myListeners) {
                logListener.graphChanged(this.getPadding());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/concurrency/model/ConcurrencyGraphPresentationModel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/concurrency/model/ConcurrencyGraphPresentationModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface PresentationListener {
        public void graphChanged(int var1);
    }
}

