/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.remote.ui;

import com.google.common.collect.Lists;
import com.intellij.DynamicBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.TreeVisitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.WeightBasedComparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.debugger.remote.ui.SelfValidateInputDialog;
import com.jetbrains.python.debugger.remote.ui.ValidateInputDialog;
import com.jetbrains.python.debugger.remote.vfs.PyPathMapper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class PyMappingSimpleResolveDialog
extends SelfValidateInputDialog {
    private JPanel myMainPanel;
    private SimpleTree myTree;
    private JTextField myFilePathOnServerTextField;
    private final AbstractTreeBuilder myTreeBuilder;
    private final String myRemoteFilePath;
    private MyFileNode myLastSelectedNode;

    public PyMappingSimpleResolveDialog(@NotNull Project project, @NotNull String remoteFilePath, @NotNull Collection<VirtualFile> candidates2) {
        if (project == null) {
            PyMappingSimpleResolveDialog.$$$reportNull$$$0(0);
        }
        if (remoteFilePath == null) {
            PyMappingSimpleResolveDialog.$$$reportNull$$$0(1);
        }
        if (candidates2 == null) {
            PyMappingSimpleResolveDialog.$$$reportNull$$$0(2);
        }
        super(project);
        this.$$$setupUI$$$();
        this.myTreeBuilder = new SimpleTreeBuilder((JTree)this.myTree, this.myTree.getBuilderModel(), (AbstractTreeStructure)new MySimpleTreeStructure(candidates2), (Comparator)new WeightBasedComparator(true)){};
        this.myRemoteFilePath = remoteFilePath;
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myTreeBuilder);
        this.init();
    }

    protected void init() {
        super.init();
        this.setTitle(PythonProBundle.message("python.select.local.file.for.remote"));
        this.myFilePathOnServerTextField.setText(this.myRemoteFilePath);
        this.myTree.setMinSizeInRows(10);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTreeBuilder.initRootNode();
        final Ref nodeRef = new Ref();
        final Ref maxWeight = new Ref((Object)Integer.MIN_VALUE);
        this.myTreeBuilder.accept(MyFileNode.class, (TreeVisitor)new TreeVisitor<MyFileNode>(){

            public boolean visit(@NotNull MyFileNode node) {
                int weight;
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((weight = node.getWeight()) > (Integer)maxWeight.get()) {
                    nodeRef.set((Object)node);
                    maxWeight.set((Object)weight);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/debugger/remote/ui/PyMappingSimpleResolveDialog$2", "visit"));
            }
        });
        if (!nodeRef.isNull()) {
            this.myTreeBuilder.select(nodeRef.get());
        }
    }

    protected String getDimensionServiceKey() {
        return "PyMappingSimpleResolveDialog";
    }

    @Override
    @NotNull
    protected ValidateInputDialog.ValidationResult isValid() {
        if (this.myLastSelectedNode == null) {
            return new ValidateInputDialog.ValidationResult(false, "Selection is empty");
        }
        ValidateInputDialog.ValidationResult validationResult = VALID;
        if (validationResult == null) {
            PyMappingSimpleResolveDialog.$$$reportNull$$$0(3);
        }
        return validationResult;
    }

    @Override
    protected boolean isOKActionEnabledOnInit() {
        return true;
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    @NotNull
    public VirtualFile getSelectedFile() {
        assert (this.myLastSelectedNode != null);
        VirtualFile virtualFile2 = this.myLastSelectedNode.getFile();
        if (virtualFile2 == null) {
            PyMappingSimpleResolveDialog.$$$reportNull$$$0(4);
        }
        return virtualFile2;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        SimpleTree simpleTree;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myTree = simpleTree = new SimpleTree();
        simpleTree.setRootVisible(false);
        simpleTree.setShowsRootHandles(false);
        jBScrollPane.setViewportView((Component)simpleTree);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PythonProBundle", PyMappingSimpleResolveDialog.class).getString("python.remote.file.path"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFilePathOnServerTextField = jTextField = new JTextField();
        jTextField.setEditable(false);
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/remote/ui/PyMappingSimpleResolveDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/remote/ui/PyMappingSimpleResolveDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "isValid";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class MyFileNode
    extends SimpleNode {
        private final VirtualFile myFile;

        private MyFileNode(MyRootNode parent, VirtualFile file2) {
            super((SimpleNode)parent);
            this.myFile = file2;
        }

        public SimpleNode @NotNull [] getChildren() {
            if (NO_CHILDREN == null) {
                MyFileNode.$$$reportNull$$$0(0);
            }
            return NO_CHILDREN;
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                MyFileNode.$$$reportNull$$$0(1);
            }
            super.update(presentation);
            presentation.setIcon(PythonFileType.INSTANCE.getIcon());
            presentation.setPresentableText(FileUtil.toSystemDependentName((String)this.myFile.getPath()));
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public int getWeight() {
            return super.getWeight() + PyPathMapper.intersectFromEnd(PyMappingSimpleResolveDialog.this.myRemoteFilePath, this.myFile.getPath(), false).length;
        }

        public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
            PyMappingSimpleResolveDialog.this.doOKAction();
        }

        public void handleSelection(SimpleTree tree) {
            PyMappingSimpleResolveDialog.this.myLastSelectedNode = this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/remote/ui/PyMappingSimpleResolveDialog$MyFileNode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/remote/ui/PyMappingSimpleResolveDialog$MyFileNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class MyRootNode
    extends SimpleNode {
        private final MyFileNode[] myChildren;

        private MyRootNode(Collection<VirtualFile> candidates2) {
            if (candidates2 == null) {
                MyRootNode.$$$reportNull$$$0(0);
            }
            ArrayList children2 = Lists.newArrayList();
            for (VirtualFile candidate : candidates2) {
                children2.add(new MyFileNode(this, candidate));
            }
            this.myChildren = children2.toArray(new MyFileNode[0]);
        }

        public SimpleNode @NotNull [] getChildren() {
            if (this.myChildren == null) {
                MyRootNode.$$$reportNull$$$0(1);
            }
            return this.myChildren;
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                MyRootNode.$$$reportNull$$$0(2);
            }
            super.update(presentation);
            presentation.setPresentableText("");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidates";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/remote/ui/PyMappingSimpleResolveDialog$MyRootNode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/remote/ui/PyMappingSimpleResolveDialog$MyRootNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class MySimpleTreeStructure
    extends SimpleTreeStructure {
        private final MyRootNode myRootNode;

        public MySimpleTreeStructure(Collection<VirtualFile> candidates2) {
            if (candidates2 == null) {
                MySimpleTreeStructure.$$$reportNull$$$0(0);
            }
            this.myRootNode = new MyRootNode(candidates2);
        }

        @NotNull
        public Object getRootElement() {
            MyRootNode myRootNode = this.myRootNode;
            if (myRootNode == null) {
                MySimpleTreeStructure.$$$reportNull$$$0(1);
            }
            return myRootNode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidates";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/remote/ui/PyMappingSimpleResolveDialog$MySimpleTreeStructure";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/remote/ui/PyMappingSimpleResolveDialog$MySimpleTreeStructure";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

