/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.docker.watcher;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.compose.configuration.util.DockerComposeConfigurationUtil;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.util.ConcurrencyUtil;
import com.jetbrains.python.docker.watcher.PyDockerComposeInterpreterInfo;
import com.jetbrains.python.docker.watcher.PyDockerInterpreterInfo;
import com.jetbrains.python.docker.watcher.PyDockerInterpretersUpdater;
import com.jetbrains.python.docker.watcher.PyInterpreterInfo;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00122\u00020\u0001:\u0004\u0011\u0012\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0019\u0010\t\u001a\u00020\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u0015\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/python/docker/watcher/PyDockerInterpretersUpdater;", "Lcom/intellij/openapi/Disposable;", "()V", "tasks", "", "", "Lcom/jetbrains/python/docker/watcher/PyDockerInterpretersUpdater$DockerAccountRecurrentCheckTask;", "dispose", "", "registerInterpreter", "interpreterInfo", "Lcom/jetbrains/python/docker/watcher/PyInterpreterInfo;", "registerInterpreter$intellij_python_docker", "unregisterForModule", "module", "Lcom/intellij/openapi/module/Module;", "unregisterForModule$intellij_python_docker", "CachedDockerRuntime", "Companion", "DockerAccountRecurrentCheckTask", "ImageSearchResult", "intellij.python.docker"})
public final class PyDockerInterpretersUpdater
implements Disposable {
    private final Map<String, DockerAccountRecurrentCheckTask> tasks;
    private static final String THREAD_NAME = "Docker Account Recurrent Check Thread";
    private static final long DELAY_IN_SECONDS = 5L;
    private static final String DEFAULT_DOCKER_COMPOSE_PROJECT_NAME = "default";
    private static final String DOCKER_COMPOSE_PROJECT_LABEL = "com.docker.compose.project";
    private static final String DOCKER_COMPOSE_SERVICE_LABEL = "com.docker.compose.service";
    private static final String DOCKER_COMPOSE_ONE_OFF_LABEL = "com.docker.compose.oneoff";
    private static final String FALSE_VALUE = "False";
    private static final Logger LOG;
    public static final Companion Companion;

    public final void registerInterpreter$intellij_python_docker(@NotNull PyInterpreterInfo<?> interpreterInfo) {
        Intrinsics.checkParameterIsNotNull(interpreterInfo, (String)"interpreterInfo");
        String dockerAccountName = interpreterInfo.getDockerAccountName();
        this.tasks.computeIfAbsent(dockerAccountName, new Function<String, DockerAccountRecurrentCheckTask>(dockerAccountName){
            final /* synthetic */ String $dockerAccountName;

            @NotNull
            public final DockerAccountRecurrentCheckTask apply(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return new DockerAccountRecurrentCheckTask(this.$dockerAccountName);
            }
            {
                this.$dockerAccountName = string;
            }
        }).register(interpreterInfo);
    }

    public final void unregisterForModule$intellij_python_docker(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Iterable $this$forEach$iv = this.tasks.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry $dstr$_u24__u24$task = (Map.Entry)element$iv;
            boolean bl = false;
            Map.Entry entry = $dstr$_u24__u24$task;
            boolean bl2 = false;
            DockerAccountRecurrentCheckTask task2 = (DockerAccountRecurrentCheckTask)entry.getValue();
            task2.unregister(module);
        }
    }

    public void dispose() {
        Map<String, DockerAccountRecurrentCheckTask> $this$forEach$iv = this.tasks;
        boolean $i$f$forEach = false;
        Map<String, DockerAccountRecurrentCheckTask> map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, DockerAccountRecurrentCheckTask>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DockerAccountRecurrentCheckTask> element$iv;
            Map.Entry<String, DockerAccountRecurrentCheckTask> $dstr$_u24__u24$task = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<String, DockerAccountRecurrentCheckTask> entry = $dstr$_u24__u24$task;
            boolean bl3 = false;
            DockerAccountRecurrentCheckTask task2 = entry.getValue();
            task2.shutdown();
        }
    }

    public PyDockerInterpretersUpdater() {
        Map map2;
        PyDockerInterpretersUpdater pyDockerInterpretersUpdater = this;
        boolean bl = false;
        pyDockerInterpretersUpdater.tasks = map2 = (Map)new LinkedHashMap();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PyDockerInterpretersUpdater.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @JvmStatic
    @NotNull
    public static final PyDockerInterpretersUpdater getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\tJ\b\u0010\u0016\u001a\u00020\u0014H\u0016J\u0006\u0010\u0017\u001a\u00020\u0014J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aJ$\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/python/docker/watcher/PyDockerInterpretersUpdater$DockerAccountRecurrentCheckTask;", "Ljava/lang/Runnable;", "dockerAccountName", "", "(Ljava/lang/String;)V", "getDockerAccountName", "()Ljava/lang/String;", "infos", "", "Lcom/jetbrains/python/docker/watcher/PyInterpreterInfo;", "interpreterToLastImageSearchResult", "", "", "Lcom/jetbrains/python/docker/watcher/PyDockerInterpretersUpdater$ImageSearchResult;", "isScheduled", "", "lock", "service", "Ljava/util/concurrent/ScheduledExecutorService;", "register", "", "interpreterInfo", "run", "shutdown", "unregister", "module", "Lcom/intellij/openapi/module/Module;", "updatePythonSdk", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "info", "intellij.python.docker"})
    private static final class DockerAccountRecurrentCheckTask
    implements Runnable {
        private final Object lock;
        private boolean isScheduled;
        private final ScheduledExecutorService service;
        private final List<PyInterpreterInfo<?>> infos;
        private final Map<Object, ImageSearchResult> interpreterToLastImageSearchResult;
        @NotNull
        private final String dockerAccountName;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void register(@NotNull PyInterpreterInfo<?> interpreterInfo) {
            Intrinsics.checkParameterIsNotNull(interpreterInfo, (String)"interpreterInfo");
            Object object = this.lock;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                this.infos.removeIf(new Predicate<PyInterpreterInfo<?>>(this, interpreterInfo){
                    final /* synthetic */ DockerAccountRecurrentCheckTask this$0;
                    final /* synthetic */ PyInterpreterInfo $interpreterInfo$inlined;
                    {
                        this.this$0 = dockerAccountRecurrentCheckTask;
                        this.$interpreterInfo$inlined = pyInterpreterInfo;
                    }

                    public final boolean test(@NotNull PyInterpreterInfo<?> info) {
                        Intrinsics.checkParameterIsNotNull(info, (String)"info");
                        return Intrinsics.areEqual((Object)info.getModule(), (Object)this.$interpreterInfo$inlined.getModule());
                    }
                });
                this.infos.add(interpreterInfo);
                if (!this.isScheduled) {
                    Companion.logDebug((Function0<String>)((Function0)new Function0<String>(this, interpreterInfo){
                        final /* synthetic */ DockerAccountRecurrentCheckTask this$0;
                        final /* synthetic */ PyInterpreterInfo $interpreterInfo$inlined;
                        {
                            this.this$0 = dockerAccountRecurrentCheckTask;
                            this.$interpreterInfo$inlined = pyInterpreterInfo;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Start watching images for updates within Docker account '" + this.this$0.getDockerAccountName() + '\'';
                        }
                    }));
                    this.service.schedule(this, 5L, TimeUnit.SECONDS);
                    this.isScheduled = true;
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        public final void unregister(@NotNull Module module) {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            this.infos.removeIf(new Predicate<PyInterpreterInfo<?>>(module){
                final /* synthetic */ Module $module;

                public final boolean test(@NotNull PyInterpreterInfo<?> info) {
                    Intrinsics.checkParameterIsNotNull(info, (String)"info");
                    return Intrinsics.areEqual((Object)info.getModule(), (Object)this.$module);
                }
                {
                    this.$module = module;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            List list;
            Object object = this.lock;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                if (this.infos.isEmpty()) {
                    if (this.isScheduled) {
                        Companion.logDebug((Function0<String>)((Function0)new Function0<String>(this){
                            final /* synthetic */ DockerAccountRecurrentCheckTask this$0;
                            {
                                this.this$0 = dockerAccountRecurrentCheckTask;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                return "No Docker interpreters to watch for updates within Docker account '" + this.this$0.getDockerAccountName() + '\'';
                            }
                        }));
                    }
                    this.isScheduled = false;
                    return;
                }
                list = CollectionsKt.toList((Iterable)this.infos);
            }
            List infosCopy = list;
            try {
                void $this$filterTo$iv$iv;
                RemoteDockerRuntime dockerRuntime;
                Companion.logDebug((Function0<String>)((Function0)new Function0<String>(this, infosCopy){
                    final /* synthetic */ DockerAccountRecurrentCheckTask this$0;
                    final /* synthetic */ List $infosCopy;

                    @NotNull
                    public final String invoke() {
                        return "Checking " + CollectionsKt.joinToString$default((Iterable)this.$infosCopy, null, null, null, (int)0, null, (Function1)run.1.INSTANCE, (int)31, null) + " for updates (Docker account '" + this.this$0.getDockerAccountName() + "')";
                    }
                    {
                        this.this$0 = dockerAccountRecurrentCheckTask;
                        this.$infosCopy = list;
                        super(0);
                    }
                }));
                RemoteServer dockerServer = Companion.findDockerServer(this.dockerAccountName);
                if (dockerServer == null) {
                    Companion.logDebug((Function0<String>)((Function0)new Function0<String>(this){
                        final /* synthetic */ DockerAccountRecurrentCheckTask this$0;

                        @NotNull
                        public final String invoke() {
                            return "Docker account '" + this.this$0.getDockerAccountName() + "' cannot be found";
                        }
                        {
                            this.this$0 = dockerAccountRecurrentCheckTask;
                            super(0);
                        }
                    }));
                    return;
                }
                RemoteDockerRuntime remoteDockerRuntime = dockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)((DockerCloudConfiguration)dockerServer.getConfiguration()), null);
                Intrinsics.checkExpressionValueIsNotNull((Object)remoteDockerRuntime, (String)"dockerRuntime");
                CachedDockerRuntime cachedRuntime = new CachedDockerRuntime(remoteDockerRuntime);
                Iterable $this$filter$iv = infosCopy;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl4;
                    PyInterpreterInfo info = (PyInterpreterInfo)element$iv$iv;
                    boolean bl5 = false;
                    String currentImageId = Companion.findImageIdForInterpreter(cachedRuntime, info);
                    ImageSearchResult lastImageSearchResult = this.interpreterToLastImageSearchResult.get(info.getCredentials());
                    if (currentImageId == null) {
                        if (lastImageSearchResult == null) {
                            this.interpreterToLastImageSearchResult.put(info.getCredentials(), ImageSearchResult.ImageNotFound.INSTANCE);
                        }
                        bl4 = false;
                    } else {
                        ImageSearchResult.ImageFound currentImageSearchResult = new ImageSearchResult.ImageFound(currentImageId);
                        this.interpreterToLastImageSearchResult.put(info.getCredentials(), currentImageSearchResult);
                        bl4 = lastImageSearchResult != null && Intrinsics.areEqual((Object)lastImageSearchResult, (Object)currentImageSearchResult) ^ true;
                    }
                    if (!bl4) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List infosToUpdate = (List)destination$iv$iv;
                Iterable $this$forEach$iv = infosToUpdate;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PyInterpreterInfo info = (PyInterpreterInfo)element$iv;
                    boolean bl6 = false;
                    this.updatePythonSdk(info.getModule(), info.getSdk(), info);
                }
            }
            catch (Exception e) {
                Companion.logException("Checking interpreters for updates (Docker account '" + this.dockerAccountName + "') failed", e);
            }
            finally {
                this.service.schedule(this, 5L, TimeUnit.SECONDS);
            }
        }

        private final void updatePythonSdk(Module module, Sdk sdk, PyInterpreterInfo<?> info) {
            Companion.logDebug((Function0<String>)((Function0)new Function0<String>(sdk, module, info){
                final /* synthetic */ Sdk $sdk;
                final /* synthetic */ Module $module;
                final /* synthetic */ PyInterpreterInfo $info;

                @NotNull
                public final String invoke() {
                    return "Triggering update of Python SDK '" + this.$sdk.getName() + "' in module '" + this.$module.getName() + "' for " + this.$info.getCredentialsDetails();
                }
                {
                    this.$sdk = sdk;
                    this.$module = module;
                    this.$info = pyInterpreterInfo;
                    super(0);
                }
            }));
            PythonSdkUpdater.update(sdk, null, module.getProject(), null);
        }

        public final void shutdown() {
            this.service.shutdownNow();
        }

        @NotNull
        public final String getDockerAccountName() {
            return this.dockerAccountName;
        }

        public DockerAccountRecurrentCheckTask(@NotNull String dockerAccountName) {
            Intrinsics.checkParameterIsNotNull((Object)dockerAccountName, (String)"dockerAccountName");
            this.dockerAccountName = dockerAccountName;
            this.lock = new Object();
            ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, ConcurrencyUtil.newNamedThreadFactory((String)PyDockerInterpretersUpdater.THREAD_NAME));
            Intrinsics.checkExpressionValueIsNotNull((Object)scheduledExecutorService, (String)"Executors.newScheduledTh\u2026readFactory(THREAD_NAME))");
            this.service = scheduledExecutorService;
            DockerAccountRecurrentCheckTask dockerAccountRecurrentCheckTask = this;
            boolean bl = false;
            Object object = new ArrayList();
            dockerAccountRecurrentCheckTask.infos = object;
            dockerAccountRecurrentCheckTask = this;
            bl = false;
            dockerAccountRecurrentCheckTask.interpreterToLastImageSearchResult = object = (Map)new LinkedHashMap();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/docker/watcher/PyDockerInterpretersUpdater$ImageSearchResult;", "", "()V", "ImageFound", "ImageNotFound", "Lcom/jetbrains/python/docker/watcher/PyDockerInterpretersUpdater$ImageSearchResult$ImageNotFound;", "Lcom/jetbrains/python/docker/watcher/PyDockerInterpretersUpdater$ImageSearchResult$ImageFound;", "intellij.python.docker"})
    public static abstract class ImageSearchResult {
        private ImageSearchResult() {
        }

        public /* synthetic */ ImageSearchResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jetbrains/python/docker/watcher/PyDockerInterpretersUpdater$ImageSearchResult$ImageNotFound;", "Lcom/jetbrains/python/docker/watcher/PyDockerInterpretersUpdater$ImageSearchResult;", "()V", "intellij.python.docker"})
        public static final class ImageNotFound
        extends ImageSearchResult {
            public static final ImageNotFound INSTANCE;

            private ImageNotFound() {
                super(null);
            }

            static {
                ImageNotFound imageNotFound;
                INSTANCE = imageNotFound = new ImageNotFound();
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/python/docker/watcher/PyDockerInterpretersUpdater$ImageSearchResult$ImageFound;", "Lcom/jetbrains/python/docker/watcher/PyDockerInterpretersUpdater$ImageSearchResult;", "imageId", "", "(Ljava/lang/String;)V", "getImageId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.python.docker"})
        public static final class ImageFound
        extends ImageSearchResult {
            @NotNull
            private final String imageId;

            @NotNull
            public final String getImageId() {
                return this.imageId;
            }

            public ImageFound(@NotNull String imageId) {
                Intrinsics.checkParameterIsNotNull((Object)imageId, (String)"imageId");
                super(null);
                this.imageId = imageId;
            }

            @NotNull
            public final String component1() {
                return this.imageId;
            }

            @NotNull
            public final ImageFound copy(@NotNull String imageId) {
                Intrinsics.checkParameterIsNotNull((Object)imageId, (String)"imageId");
                return new ImageFound(imageId);
            }

            public static /* synthetic */ ImageFound copy$default(ImageFound imageFound, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = imageFound.imageId;
                }
                return imageFound.copy(string);
            }

            @NotNull
            public String toString() {
                return "ImageFound(imageId=" + this.imageId + ")";
            }

            public int hashCode() {
                String string = this.imageId;
                return string != null ? string.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof ImageFound)) break block3;
                        ImageFound imageFound = (ImageFound)object;
                        if (!Intrinsics.areEqual((Object)this.imageId, (Object)imageFound.imageId)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fJ \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000fR\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/python/docker/watcher/PyDockerInterpretersUpdater$CachedDockerRuntime;", "", "dockerRuntime", "Lcom/intellij/docker/remote/run/runtime/RemoteDockerRuntime;", "(Lcom/intellij/docker/remote/run/runtime/RemoteDockerRuntime;)V", "cachedContainers", "", "Lcom/intellij/docker/agent/DockerAgentApplication;", "cachedImages", "lock", "findImageByName", "imageName", "", "getContainers", "labels", "", "intellij.python.docker"})
    private static final class CachedDockerRuntime {
        private final Object lock;
        private List<? extends DockerAgentApplication> cachedImages;
        private List<? extends DockerAgentApplication> cachedContainers;
        private final RemoteDockerRuntime dockerRuntime;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final DockerAgentApplication findImageByName(@NotNull String imageName) {
            Object v3;
            block5: {
                Object object;
                Object object2;
                Intrinsics.checkParameterIsNotNull((Object)imageName, (String)"imageName");
                Object object3 = this.lock;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (object3) {
                    boolean bl3 = false;
                    List<? extends DockerAgentApplication> list = this.cachedImages;
                    if (list == null) {
                        Object[] objectArray = this.dockerRuntime.getImages();
                        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"dockerRuntime.images");
                        object2 = ArraysKt.toList((Object[])objectArray);
                        boolean bl4 = false;
                        boolean bl5 = false;
                        List it = object2;
                        boolean bl6 = false;
                        this.cachedImages = it;
                        list = object2;
                    }
                    object = list;
                }
                List<? extends DockerAgentApplication> images = object;
                object3 = images;
                bl = false;
                object = object3;
                boolean bl7 = false;
                object2 = object.iterator();
                while (object2.hasNext()) {
                    Object e = object2.next();
                    DockerAgentApplication it = (DockerAgentApplication)e;
                    boolean bl8 = false;
                    Object[] objectArray = it.getImageRepoTags();
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"it.imageRepoTags");
                    if (!ArraysKt.contains((Object[])objectArray, (Object)imageName)) continue;
                    v3 = e;
                    break block5;
                }
                v3 = null;
            }
            return v3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final List<DockerAgentApplication> getContainers(@NotNull Map<String, String> labels) {
            void $this$filterTo$iv$iv;
            Iterable iterable;
            Intrinsics.checkParameterIsNotNull(labels, (String)"labels");
            Object object = this.lock;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                List list = this.cachedContainers;
                if (list == null) {
                    Object[] objectArray = this.dockerRuntime.getContainers();
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"dockerRuntime.containers");
                    List list2 = ArraysKt.toList((Object[])objectArray);
                    boolean bl4 = false;
                    boolean bl5 = false;
                    List it = list2;
                    boolean bl6 = false;
                    this.cachedContainers = it;
                    list = list2;
                }
                iterable = list;
            }
            List containers = iterable;
            Iterable $this$filter$iv = containers;
            boolean $i$f$filter = false;
            iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl7;
                block8: {
                    DockerAgentApplication container = (DockerAgentApplication)element$iv$iv;
                    boolean bl8 = false;
                    Iterable $this$all$iv = labels.entrySet();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl7 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            void key;
                            Map.Entry $dstr$key$value = (Map.Entry)element$iv;
                            boolean bl9 = false;
                            Map.Entry entry = $dstr$key$value;
                            boolean bl10 = false;
                            String string = (String)entry.getKey();
                            entry = $dstr$key$value;
                            bl10 = false;
                            String value2 = (String)entry.getValue();
                            Map map2 = container.getContainerLabels();
                            if (Intrinsics.areEqual((Object)(map2 != null ? (String)map2.get(key) : null), (Object)value2)) continue;
                            bl7 = false;
                            break block8;
                        }
                        bl7 = true;
                    }
                }
                if (!bl7) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public CachedDockerRuntime(@NotNull RemoteDockerRuntime dockerRuntime) {
            Intrinsics.checkParameterIsNotNull((Object)dockerRuntime, (String)"dockerRuntime");
            this.dockerRuntime = dockerRuntime;
            this.lock = new Object();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0019H\u0002J\u001e\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0007J\u0016\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040!H\u0002J\u001c\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u00042\n\u0010$\u001a\u00060%j\u0002`&H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/jetbrains/python/docker/watcher/PyDockerInterpretersUpdater$Companion;", "", "()V", "DEFAULT_DOCKER_COMPOSE_PROJECT_NAME", "", "DELAY_IN_SECONDS", "", "DOCKER_COMPOSE_ONE_OFF_LABEL", "DOCKER_COMPOSE_PROJECT_LABEL", "DOCKER_COMPOSE_SERVICE_LABEL", "FALSE_VALUE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "THREAD_NAME", "findDockerServer", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "accountName", "findImageIdForComposeInterpreter", "info", "Lcom/jetbrains/python/docker/watcher/PyDockerComposeInterpreterInfo;", "cachedDockerRuntime", "Lcom/jetbrains/python/docker/watcher/PyDockerInterpretersUpdater$CachedDockerRuntime;", "findImageIdForDockerInterpreter", "Lcom/jetbrains/python/docker/watcher/PyDockerInterpreterInfo;", "findImageIdForInterpreter", "Lcom/jetbrains/python/docker/watcher/PyInterpreterInfo;", "getInstance", "Lcom/jetbrains/python/docker/watcher/PyDockerInterpretersUpdater;", "logDebug", "", "lazyMessage", "Lkotlin/Function0;", "logException", "message", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "intellij.python.docker"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final PyDockerInterpretersUpdater getInstance() {
            boolean $i$f$service = false;
            Object object = ApplicationManager.getApplication().getService(PyDockerInterpretersUpdater.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
            return (PyDockerInterpretersUpdater)object;
        }

        private final RemoteServer<DockerCloudConfiguration> findDockerServer(String accountName) {
            return RemoteServersManager.getInstance().findByName(accountName, (ServerType)DockerCloudType.getInstance());
        }

        private final String findImageIdForInterpreter(CachedDockerRuntime cachedDockerRuntime, PyInterpreterInfo<?> info) {
            String string;
            PyInterpreterInfo<?> pyInterpreterInfo = info;
            if (pyInterpreterInfo instanceof PyDockerInterpreterInfo) {
                string = this.findImageIdForDockerInterpreter(cachedDockerRuntime, (PyDockerInterpreterInfo)info);
            } else if (pyInterpreterInfo instanceof PyDockerComposeInterpreterInfo) {
                string = this.findImageIdForComposeInterpreter((PyDockerComposeInterpreterInfo)info, cachedDockerRuntime);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        private final String findImageIdForDockerInterpreter(CachedDockerRuntime cachedDockerRuntime, PyDockerInterpreterInfo info) {
            String string;
            String string2 = info.getCredentials().getImageName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"info.credentials.imageName");
            String imageName = string2;
            DockerAgentApplication image = cachedDockerRuntime.findImageByName(imageName);
            if (image == null) {
                this.logDebug((Function0<String>)((Function0)new Function0<String>(imageName){
                    final /* synthetic */ String $imageName;

                    @NotNull
                    public final String invoke() {
                        return "Cannot find image by name '" + this.$imageName + '\'';
                    }
                    {
                        this.$imageName = string;
                        super(0);
                    }
                }));
                string = null;
            } else {
                String imageId = image.getImageId();
                this.logDebug((Function0<String>)((Function0)new Function0<String>(imageName, imageId){
                    final /* synthetic */ String $imageName;
                    final /* synthetic */ String $imageId;

                    @NotNull
                    public final String invoke() {
                        return "Image found by its name: '" + this.$imageName + "', image id: '" + this.$imageId + '\'';
                    }
                    {
                        this.$imageName = string;
                        this.$imageId = string2;
                        super(0);
                    }
                }));
                string = imageId;
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        private final String findImageIdForComposeInterpreter(PyDockerComposeInterpreterInfo info, CachedDockerRuntime cachedDockerRuntime) {
            String string;
            void $this$mapTo$iv$iv;
            List list = info.getCredentials().getComposeFilePaths();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"info.credentials.composeFilePaths");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Path path = Paths.get((String)it, new String[0]);
                collection.add(path);
            }
            List composeFilePaths = (List)destination$iv$iv;
            EnvironmentVariablesData environmentVariablesData = info.getCredentials().getEnvs();
            Intrinsics.checkExpressionValueIsNotNull((Object)environmentVariablesData, (String)"info.credentials.envs");
            String string3 = DockerComposeConfigurationUtil.getEffectiveDockerComposeProjectName((List)composeFilePaths, (Map)environmentVariablesData.getEnvs());
            if (string3 == null) {
                string3 = PyDockerInterpretersUpdater.DEFAULT_DOCKER_COMPOSE_PROJECT_NAME;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"DockerComposeConfigurati\u2026CKER_COMPOSE_PROJECT_NAME");
            String projectName = string3;
            String serviceName = info.getCredentials().getComposeServiceName();
            List<DockerAgentApplication> containers = cachedDockerRuntime.getContainers(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)PyDockerInterpretersUpdater.DOCKER_COMPOSE_PROJECT_LABEL, (Object)projectName), TuplesKt.to((Object)PyDockerInterpretersUpdater.DOCKER_COMPOSE_SERVICE_LABEL, (Object)serviceName), TuplesKt.to((Object)PyDockerInterpretersUpdater.DOCKER_COMPOSE_ONE_OFF_LABEL, (Object)PyDockerInterpretersUpdater.FALSE_VALUE)}));
            if (containers.isEmpty()) {
                this.logDebug((Function0<String>)((Function0)new Function0<String>(serviceName){
                    final /* synthetic */ String $serviceName;

                    @NotNull
                    public final String invoke() {
                        return "Cannot find container for Compose service '" + this.$serviceName + '\'';
                    }
                    {
                        this.$serviceName = string;
                        super(0);
                    }
                }));
                string = null;
            } else {
                if (containers.size() > 1) {
                    this.logDebug((Function0<String>)((Function0)new Function0<String>(serviceName){
                        final /* synthetic */ String $serviceName;

                        @NotNull
                        public final String invoke() {
                            return "Several containers found for Compose service '" + this.$serviceName + '\'';
                        }
                        {
                            this.$serviceName = string;
                            super(0);
                        }
                    }));
                }
                DockerAgentApplication container = containers.get(0);
                String imageId = container.getImageId();
                this.logDebug((Function0<String>)((Function0)new Function0<String>(container, serviceName, imageId){
                    final /* synthetic */ DockerAgentApplication $container;
                    final /* synthetic */ String $serviceName;
                    final /* synthetic */ String $imageId;

                    @NotNull
                    public final String invoke() {
                        return "Container '" + this.$container.getContainerName() + "' found for Compose service '" + this.$serviceName + "', image id: '" + this.$imageId + '\'';
                    }
                    {
                        this.$container = dockerAgentApplication;
                        this.$serviceName = string;
                        this.$imageId = string2;
                        super(0);
                    }
                }));
                string = imageId;
            }
            return string;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final void logDebug(Function0<String> lazyMessage) {
            Logger $this$debugOrInfoIfTestMode$iv = LOG;
            Exception e$iv = null;
            boolean $i$f$debugOrInfoIfTestMode = false;
            Application application = ApplicationManager.getApplication();
            if (application != null) {
                if (application.isUnitTestMode()) {
                    $this$debugOrInfoIfTestMode$iv.info((String)lazyMessage.invoke());
                    return;
                }
            }
            Logger $this$debug$iv$iv = $this$debugOrInfoIfTestMode$iv;
            boolean $i$f$debug = false;
            if (!$this$debug$iv$iv.isDebugEnabled()) return;
            $this$debug$iv$iv.debug((String)lazyMessage.invoke(), (Throwable)e$iv);
        }

        private final void logException(String message, Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(message, (Throwable)e);
            } else {
                LOG.info(message + ": " + e.getLocalizedMessage());
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

