/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.docker.watcher;

import com.intellij.ProjectTopics;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.jetbrains.python.docker.watcher.PyDockerComposeInterpreterInfo;
import com.jetbrains.python.docker.watcher.PyDockerInterpreterInfo;
import com.jetbrains.python.docker.watcher.PyDockerInterpretersUpdater;
import com.jetbrains.python.docker.watcher.PyInterpreterInfo;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\u001a\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0002J\b\u0010\u0012\u001a\u00020\u000bH\u0002R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/python/docker/watcher/PyDockerProjectInterpretersWatcher;", "Lcom/intellij/openapi/components/ProjectComponent;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "moduleToRegisteredInterpreters", "", "Lcom/intellij/openapi/module/Module;", "Lcom/jetbrains/python/docker/watcher/PyInterpreterInfo;", "dispose", "", "projectClosed", "projectOpened", "updateSdkStatusForModule", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "module", "updateSdkStatusForProject", "Companion", "intellij.python.docker"})
public final class PyDockerProjectInterpretersWatcher
implements ProjectComponent,
Disposable {
    private final Map<Module, PyInterpreterInfo<?>> moduleToRegisteredInterpreters;
    private final Project project;
    private static final Logger LOG;
    public static final Companion Companion;

    public void projectOpened() {
        this.updateSdkStatusForProject();
        this.project.getMessageBus().connect((Disposable)this).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(this){
            final /* synthetic */ PyDockerProjectInterpretersWatcher this$0;

            public void rootsChanged(@NotNull ModuleRootEvent event2) {
                Intrinsics.checkParameterIsNotNull((Object)event2, (String)"event");
                if (PyDockerProjectInterpretersWatcher.access$getProject$p(this.this$0).isDisposed()) {
                    return;
                }
                Logger $this$debug$iv = PyDockerProjectInterpretersWatcher.access$getLOG$cp();
                Exception e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug$iv.isDebugEnabled()) {
                    Logger logger = $this$debug$iv;
                    boolean bl = false;
                    String string = "Update of watch status for modules' SDKs in project '" + PyDockerProjectInterpretersWatcher.access$getProject$p(this.this$0).getName() + "' triggered by 'roots changed' event";
                    logger.debug(string, (Throwable)e$iv);
                }
                PyDockerProjectInterpretersWatcher.access$updateSdkStatusForProject(this.this$0);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void updateSdkStatusForProject() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] moduleArray = moduleManager.getModules();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
        Module[] $this$forEach$iv = moduleArray;
        boolean $i$f$forEach = false;
        Module[] moduleArray2 = $this$forEach$iv;
        int n = moduleArray2.length;
        for (int i = 0; i < n; ++i) {
            Module element$iv;
            Module module = element$iv = moduleArray2[i];
            boolean bl = false;
            Sdk pythonSdk2 = PythonSdkUtil.findPythonSdk(module);
            Module module2 = module;
            Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"module");
            this.updateSdkStatusForModule(pythonSdk2, module2);
        }
    }

    private final void updateSdkStatusForModule(Sdk sdk, Module module) {
        PyInterpreterInfo info;
        PyInterpreterInfo pyInterpreterInfo;
        PyRemoteSdkAdditionalData pyRemoteSdkAdditionalData;
        Object credentials;
        Sdk sdk2 = sdk;
        Object object = sdk2 != null ? sdk2.getSdkAdditionalData() : null;
        if (!(object instanceof PyRemoteSdkAdditionalData)) {
            object = null;
        }
        Object object2 = credentials = (pyRemoteSdkAdditionalData = (PyRemoteSdkAdditionalData)object) != null && (pyRemoteSdkAdditionalData = pyRemoteSdkAdditionalData.connectionCredentials()) != null ? pyRemoteSdkAdditionalData.getCredentials() : null;
        if (object2 != null) {
            Object object3 = object2;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object3;
            boolean bl3 = false;
            Object object4 = it;
            pyInterpreterInfo = object4 instanceof DockerCredentialsHolder ? (PyInterpreterInfo)new PyDockerInterpreterInfo(module, sdk, (DockerCredentialsHolder)it) : (object4 instanceof DockerComposeCredentialsHolder ? (PyInterpreterInfo)new PyDockerComposeInterpreterInfo(module, sdk, (DockerComposeCredentialsHolder)it) : null);
        } else {
            pyInterpreterInfo = info = null;
        }
        if (info == null) {
            PyDockerInterpretersUpdater.Companion.getInstance().unregisterForModule$intellij_python_docker(module);
        } else {
            PyInterpreterInfo<?> oldInfo;
            PyInterpreterInfo<?> pyInterpreterInfo2 = oldInfo = this.moduleToRegisteredInterpreters.get(module);
            if (Intrinsics.areEqual(pyInterpreterInfo2 != null ? pyInterpreterInfo2.getCredentials() : null, info.getCredentials()) ^ true) {
                this.moduleToRegisteredInterpreters.put(module, info);
                PyDockerInterpretersUpdater.Companion.getInstance().registerInterpreter$intellij_python_docker(info);
            }
        }
    }

    public void projectClosed() {
    }

    public void dispose() {
    }

    public PyDockerProjectInterpretersWatcher(@NotNull Project project) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        PyDockerProjectInterpretersWatcher pyDockerProjectInterpretersWatcher = this;
        boolean bl = false;
        pyDockerProjectInterpretersWatcher.moduleToRegisteredInterpreters = map2 = (Map)new LinkedHashMap();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PyDockerProjectInterpretersWatcher.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Project access$getProject$p(PyDockerProjectInterpretersWatcher $this) {
        return $this.project;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$updateSdkStatusForProject(PyDockerProjectInterpretersWatcher $this) {
        $this.updateSdkStatusForProject();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/python/docker/watcher/PyDockerProjectInterpretersWatcher$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.python.docker"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

