/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.doctest;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.references.PyReferenceImpl;
import com.jetbrains.python.psi.resolve.CompletionVariantsProcessor;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveProcessor;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDocReference
extends PyReferenceImpl {
    public PyDocReference(PyQualifiedExpression element, @NotNull PyResolveContext context) {
        if (context == null) {
            PyDocReference.$$$reportNull$$$0(0);
        }
        super(element, context);
    }

    @Override
    public HighlightSeverity getUnresolvedHighlightSeverity(TypeEvalContext context) {
        HighlightSeverity severity = super.getUnresolvedHighlightSeverity(context);
        return severity != null ? HighlightSeverity.WARNING : null;
    }

    @Override
    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        ResolveResult[] results = super.multiResolve(incompleteCode);
        if (results.length == 0) {
            InjectedLanguageManager languageManager = InjectedLanguageManager.getInstance((Project)this.myElement.getProject());
            PsiLanguageInjectionHost host = languageManager.getInjectionHost((PsiElement)this.myElement);
            String referencedName = this.myElement.getReferencedName();
            if (referencedName == null) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    PyDocReference.$$$reportNull$$$0(1);
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            if (host != null) {
                List files = languageManager.getInjectedPsiFiles((PsiElement)host);
                if (files != null) {
                    for (Pair pair : files) {
                        if (!(pair.getFirst() instanceof PyFile)) continue;
                        PyResolveProcessor processor2 = new PyResolveProcessor(referencedName);
                        PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor2, (ScopeOwner)pair.getFirst(), referencedName, (PsiElement)pair.getFirst());
                        List<RatedResolveResult> resultList = this.getResultsFromProcessor(referencedName, processor2, (PsiElement)pair.getFirst(), (PsiElement)pair.getFirst());
                        if (resultList.size() <= 0) continue;
                        List<RatedResolveResult> ret = RatedResolveResult.sorted(resultList);
                        ResolveResult[] resolveResultArray = ret.toArray(RatedResolveResult.EMPTY_ARRAY);
                        if (resolveResultArray == null) {
                            PyDocReference.$$$reportNull$$$0(2);
                        }
                        return resolveResultArray;
                    }
                }
                PyResolveProcessor processor3 = new PyResolveProcessor(referencedName);
                ScopeOwner scopeOwner = this.getHostScopeOwner();
                if (scopeOwner != null) {
                    PsiFile topLevel = scopeOwner.getContainingFile();
                    PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor3, scopeOwner, referencedName, (PsiElement)topLevel);
                    PsiElement referenceAnchor = this.getScopeControlFlowAnchor(host);
                    List<RatedResolveResult> resultList = this.getResultsFromProcessor(referencedName, processor3, referenceAnchor, (PsiElement)topLevel);
                    if (resultList.size() > 0) {
                        List<RatedResolveResult> ret = RatedResolveResult.sorted(resultList);
                        ResolveResult[] resolveResultArray = ret.toArray(RatedResolveResult.EMPTY_ARRAY);
                        if (resolveResultArray == null) {
                            PyDocReference.$$$reportNull$$$0(3);
                        }
                        return resolveResultArray;
                    }
                }
            }
        }
        if (results == null) {
            PyDocReference.$$$reportNull$$$0(4);
        }
        return results;
    }

    @Nullable
    private PsiElement getScopeControlFlowAnchor(@NotNull PsiLanguageInjectionHost host) {
        if (host == null) {
            PyDocReference.$$$reportNull$$$0(5);
        }
        if (this.isInsideFormattedStringNode(host)) {
            return PyDocReference.getControlFlowAnchorForFString((PyStringLiteralExpression)host);
        }
        return null;
    }

    @Nullable
    public static PsiElement getControlFlowAnchorForFString(@NotNull PyStringLiteralExpression host) {
        PsiElement comprehensionPart;
        if (host == null) {
            PyDocReference.$$$reportNull$$$0(6);
        }
        if ((comprehensionPart = PsiTreeUtil.findFirstParent((PsiElement)host, PyDocReference::isComprehensionResultOrComponent)) != null) {
            return comprehensionPart;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)host, PyStatement.class);
    }

    private static boolean isComprehensionResultOrComponent(@NotNull PsiElement element) {
        if (element == null) {
            PyDocReference.$$$reportNull$$$0(7);
        }
        return element instanceof PyExpression && element.getParent() instanceof PyComprehensionElement;
    }

    private boolean isInsideFormattedStringNode(@NotNull PsiLanguageInjectionHost host) {
        if (host == null) {
            PyDocReference.$$$reportNull$$$0(8);
        }
        if (host instanceof PyStringLiteralExpression) {
            ASTNode node = PyDocReference.findContainingStringNode(this.getElement(), (PyStringLiteralExpression)host);
            return node != null && new PyUtil.StringNodeInfo(node).isFormatted();
        }
        return false;
    }

    @Nullable
    private static ASTNode findContainingStringNode(@NotNull PsiElement injectedElement, @NotNull PyStringLiteralExpression host) {
        PsiFile injectedFile;
        Pair first;
        InjectedLanguageManager manager;
        List files;
        if (injectedElement == null) {
            PyDocReference.$$$reportNull$$$0(9);
        }
        if (host == null) {
            PyDocReference.$$$reportNull$$$0(10);
        }
        if ((files = (manager = InjectedLanguageManager.getInstance((Project)host.getProject())).getInjectedPsiFiles((PsiElement)host)) != null && (first = (Pair)ContainerUtil.find((Iterable)files, arg_0 -> PyDocReference.lambda$findContainingStringNode$0(injectedFile = injectedElement.getContainingFile(), arg_0))) != null) {
            int hostOffset = -host.getTextRange().getStartOffset();
            for (ASTNode node : host.getStringNodes()) {
                TextRange relativeNodeRange = node.getTextRange().shiftRight(hostOffset);
                if (!relativeNodeRange.contains((TextRange)first.getSecond())) continue;
                return node;
            }
        }
        return null;
    }

    @Override
    public Object @NotNull [] getVariants() {
        ArrayList ret = Lists.newArrayList((Object[])super.getVariants());
        PyQualifiedExpression originalElement = (PyQualifiedExpression)CompletionUtilCoreImpl.getOriginalElement((PsiElement)this.myElement);
        PyQualifiedExpression element = originalElement != null ? originalElement : this.myElement;
        ScopeOwner scopeOwner = this.getHostScopeOwner();
        if (scopeOwner != null) {
            CompletionVariantsProcessor processor2 = new CompletionVariantsProcessor((PsiElement)element);
            PyResolveUtil.scopeCrawlUp((PsiScopeProcessor)processor2, scopeOwner, null, null);
            ret.addAll(processor2.getResultList());
        }
        Object[] objectArray = ret.toArray();
        if (objectArray == null) {
            PyDocReference.$$$reportNull$$$0(11);
        }
        return objectArray;
    }

    @Nullable
    private ScopeOwner getHostScopeOwner() {
        InjectedLanguageManager languageManager = InjectedLanguageManager.getInstance((Project)this.myElement.getProject());
        PsiLanguageInjectionHost host = languageManager.getInjectionHost((PsiElement)this.myElement);
        if (host != null) {
            PsiFile file2 = host.getContainingFile();
            ScopeOwner result = ScopeUtil.getScopeOwner((PsiElement)host);
            if (result == null && file2 instanceof ScopeOwner) {
                result = (ScopeOwner)file2;
            }
            return result;
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$findContainingStringNode$0(PsiFile injectedFile, Pair pair) {
        return pair.getFirst() == injectedFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/doctest/PyDocReference";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/doctest/PyDocReference";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getScopeControlFlowAnchor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlowAnchorForFString";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isComprehensionResultOrComponent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isInsideFormattedStringNode";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findContainingStringNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

