/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.gherkin.behave;

import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.gherkin.behave.PyBehaveFunctionNames;
import com.jetbrains.python.gherkin.behave.PyBehaveFunctionParameters;
import com.jetbrains.python.gherkin.matchers.PyBDDMatcher;
import com.jetbrains.python.nameResolver.FQNamesProvider;
import com.jetbrains.python.nameResolver.NameResolverTools;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PyBehaveUtils {
    @NotNull
    private static final PyBDDMatcher DEFAULT_MATCHER = PyBDDMatcher.PARSE;

    private PyBehaveUtils() {
    }

    @Nullable
    static PyBDDMatcher getRegexpMatcher(@NotNull PsiFile file2) {
        String matcherName;
        if (file2 == null) {
            PyBehaveUtils.$$$reportNull$$$0(0);
        }
        if ((matcherName = PyBehaveUtils.getMatcherName(file2)) != null) {
            return PyBDDMatcher.getByNameOrNull(matcherName);
        }
        PsiDirectory parentDirectory = file2.getContainingDirectory();
        if (parentDirectory == null) {
            return DEFAULT_MATCHER;
        }
        PsiDirectory grandparentDirectory = parentDirectory.getParent();
        if (grandparentDirectory == null) {
            return DEFAULT_MATCHER;
        }
        PyFile envFile = PyUtil.as(grandparentDirectory.findFile("environment.py"), PyFile.class);
        if (envFile == null) {
            return DEFAULT_MATCHER;
        }
        String envMatcherName = PyBehaveUtils.getMatcherName(envFile);
        if (envMatcherName == null) {
            return DEFAULT_MATCHER;
        }
        return PyBDDMatcher.getByNameOrNull(envMatcherName);
    }

    @Nullable
    private static String getMatcherName(@NotNull PsiFile file2) {
        if (file2 == null) {
            PyBehaveUtils.$$$reportNull$$$0(1);
        }
        if (!(file2 instanceof PyFile)) {
            return null;
        }
        if (!NameResolverTools.isContainsName(file2, (FQNamesProvider)PyBehaveFunctionNames.USE_STEP_MATCHER)) {
            return null;
        }
        TypeEvalContext context = TypeEvalContext.codeAnalysis(file2.getProject(), file2);
        for (PyCallExpression callExpression : PsiTreeUtil.findChildrenOfType((PsiElement)file2, PyCallExpression.class)) {
            PyExpression argument;
            if (!NameResolverTools.isCalleeShortCut(callExpression, PyBehaveFunctionNames.USE_STEP_MATCHER) || (argument = callExpression.getArgument(PyBehaveFunctionParameters.MATCHER_NAME, PyExpression.class)) == null) continue;
            return PyEvaluator.evaluate(argument, String.class);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "file";
        objectArray2[1] = "com/jetbrains/python/gherkin/behave/PyBehaveUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getRegexpMatcher";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getMatcherName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

