/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyStringFormatParser;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyAddSpecifierToFormatQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.NAME.add.specifier", new Object[0]);
        if (string == null) {
            PyAddSpecifierToFormatQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement element;
        PyBinaryExpression expression;
        if (project == null) {
            PyAddSpecifierToFormatQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            PyAddSpecifierToFormatQuickFix.$$$reportNull$$$0(2);
        }
        if ((expression = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)(element = descriptor2.getPsiElement()), PyBinaryExpression.class)) == null) {
            return;
        }
        PyExpression rightExpression = expression.getRightExpression();
        if (rightExpression instanceof PyParenthesizedExpression) {
            rightExpression = ((PyParenthesizedExpression)rightExpression).getContainedExpression();
        }
        if (rightExpression == null) {
            return;
        }
        PsiFile file2 = element.getContainingFile();
        Document document = FileDocumentManager.getInstance().getDocument(file2.getVirtualFile());
        if (document == null) {
            return;
        }
        int offset = element.getTextOffset();
        TypeEvalContext context = TypeEvalContext.userInitiated(file2.getProject(), file2);
        PyClassType strType = PyBuiltinCache.getInstance(element).getStrType();
        PyClassType floatType = PyBuiltinCache.getInstance(element).getFloatType();
        PyClassType intType = PyBuiltinCache.getInstance(element).getIntType();
        PyExpression leftExpression = expression.getLeftExpression();
        if (leftExpression instanceof PyStringLiteralExpression) {
            List<PyStringFormatParser.SubstitutionChunk> chunks = PyStringFormatParser.filterSubstitutions(PyStringFormatParser.parsePercentFormat(leftExpression.getText()));
            PyExpression[] elements = rightExpression instanceof PyTupleExpression ? ((PyTupleExpression)rightExpression).getElements() : new PyExpression[]{rightExpression};
            int shift = 1;
            for (int i = 0; i < chunks.size(); ++i) {
                PyStringFormatParser.PercentSubstitutionChunk chunk = PyUtil.as(chunks.get(i), PyStringFormatParser.PercentSubstitutionChunk.class);
                if (chunk == null) continue;
                if (elements.length <= i) {
                    return;
                }
                PyType type = context.getType(elements[i]);
                char conversionType = chunk.getConversionType();
                if (conversionType != '\u0000') continue;
                int insertOffset = offset + chunk.getStartIndex() + shift;
                if (insertOffset > leftExpression.getTextRange().getEndOffset()) {
                    return;
                }
                if (PyTypeChecker.match((PyType)strType, type, context)) {
                    document.insertString(insertOffset, (CharSequence)"s");
                    ++shift;
                }
                if (!PyTypeChecker.match((PyType)intType, type, context) && !PyTypeChecker.match((PyType)floatType, type, context)) continue;
                document.insertString(insertOffset, (CharSequence)"d");
                ++shift;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyAddSpecifierToFormatQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyAddSpecifierToFormatQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

