/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.profiler;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.profiler.OpenSnapshotKt;
import com.jetbrains.python.profiler.ProfilerSessionVirtualFileImpl;
import com.jetbrains.python.profiler.PythonProfilerBundle;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import icons.PythonProfilerIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001c\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/profiler/PyOpenPStatAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "findPythonSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "module", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "update", "intellij.python.profiler"})
public final class PyOpenPStatAction
extends AnAction {
    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        FileChooserDescriptor d = FileChooserDescriptorFactory.createSingleFileDescriptor().withTitle(PythonProfilerBundle.message("pstat.file.chooser.title", new Object[0]));
        Project project = e.getProject();
        VirtualFile pstatFile = FileChooser.chooseFile((FileChooserDescriptor)d, (Project)project, null);
        if (pstatFile != null) {
            Module module = (Module)e.getData(LangDataKeys.MODULE);
            if (project != null) {
                void $this$filterTo$iv$iv;
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
                Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManager, (String)"FileEditorManager.getInstance(project)");
                VirtualFile[] virtualFileArray = fileEditorManager.getOpenFiles();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"FileEditorManager.getInstance(project).openFiles");
                VirtualFile[] $this$filter$iv = virtualFileArray;
                boolean $i$f$filter = false;
                VirtualFile[] virtualFileArray2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                void var11_11 = $this$filterTo$iv$iv;
                int n = ((void)var11_11).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void f = element$iv$iv = var11_11[i];
                    boolean bl = false;
                    if (!(f instanceof ProfilerSessionVirtualFileImpl && pstatFile.equals((Object)((ProfilerSessionVirtualFileImpl)f).getOriginalFile()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                if (((List)destination$iv$iv).isEmpty()) {
                    ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, module, project, pstatFile){
                        final /* synthetic */ PyOpenPStatAction this$0;
                        final /* synthetic */ Module $module;
                        final /* synthetic */ Project $project;
                        final /* synthetic */ VirtualFile $pstatFile;

                        public final void run() {
                            Sdk sdk = PyOpenPStatAction.access$findPythonSdk(this.this$0, this.$module, this.$project);
                            String string = this.$pstatFile.getPath();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"pstatFile.path");
                            OpenSnapshotKt.openSnapshotInEditor(sdk, this.$project, string);
                        }
                        {
                            this.this$0 = pyOpenPStatAction;
                            this.$module = module;
                            this.$project = project;
                            this.$pstatFile = virtualFile2;
                        }
                    });
                }
            }
        }
    }

    private final Sdk findPythonSdk(Module module, Project project) {
        Sdk sdk = PythonSdkUtil.findPythonSdk(module);
        if (sdk != null && !PythonSdkUtil.isRemote(sdk)) {
            return sdk;
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        for (Module m : moduleManager.getModules()) {
            sdk = PythonSdkUtil.findPythonSdk(m);
            if (sdk == null || PythonSdkUtil.isRemote(sdk)) continue;
            return sdk;
        }
        sdk = PythonSdkType.findLocalCPython(module);
        return sdk;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setVisible(e.getProject() != null);
    }

    public PyOpenPStatAction() {
        super(PythonProfilerIcons.Open_PYHeapSnapshot);
    }

    public static final /* synthetic */ Sdk access$findPythonSdk(PyOpenPStatAction $this, Module module, Project project) {
        return $this.findPythonSdk(module, project);
    }
}

