/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSourceItem;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.skeleton.PySkeletonHeader;
import com.jetbrains.python.sdk.skeletons.PySkeletonGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PyRemoteSkeletonGeneratorBase
extends PySkeletonGenerator {
    protected HashSet<String> myListedLocalPaths;
    protected HashSet<String> myListedBinaries;

    public PyRemoteSkeletonGeneratorBase(String skeletonPath, @NotNull Sdk pySdk, @Nullable String currentFolder) {
        if (pySdk == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(0);
        }
        super(skeletonPath, pySdk, currentFolder);
        this.myListedLocalPaths = Sets.newHashSet();
        this.myListedBinaries = Sets.newHashSet();
    }

    protected static long doneIn(long started) {
        return System.currentTimeMillis() - started;
    }

    @NotNull
    protected List<PyRemoteSourceItem> listSources(Sdk sdk, String extraSysPathEntry) throws InvalidSdkException, ExecutionException {
        String homePath = sdk.getHomePath();
        long startTime = System.currentTimeMillis();
        List pathList = ContainerUtil.append(PythonCommandLineState.getAddedPaths(sdk), (Object[])new String[]{extraSysPathEntry});
        ProcessOutput process2 = this.commandBuilder().extraSysPath(pathList).extraArgs("-v", "-S").timeout(240000).runProcess(true);
        LOG.info("Retrieving binary module list took " + PyRemoteSkeletonGeneratorBase.doneIn(startTime) + " ms");
        List lines = process2.getStdoutLines();
        if (lines.size() < 1) {
            throw new InvalidSdkException("Empty output from generator3/__main__.py for " + homePath);
        }
        Iterator iter = lines.iterator();
        int generatorVersion = PySkeletonHeader.fromVersionString(((String)iter.next()).trim());
        ArrayList result = Lists.newArrayList();
        boolean end = false;
        while (iter.hasNext()) {
            String line2 = (String)iter.next();
            if ("END".equals(line2 = line2.trim())) {
                end = true;
                break;
            }
            try {
                int size;
                String[] strs = line2.split("\t");
                String path = strs[0];
                String rootPath = strs[1];
                try {
                    size = Integer.parseInt(strs[2]);
                }
                catch (Exception e) {
                    size = 0;
                }
                PyRemoteSourceItem item = new PyRemoteSourceItem(path, rootPath, size);
                result.add(item);
            }
            catch (Exception e) {
                LOG.error("Error parsing output: " + line2, (Throwable)e);
            }
        }
        if (!end) {
            LOG.error("Skeletons generator: list_sources: no END of output");
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    public boolean deleteOrLog(@NotNull File item) {
        if (item == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(2);
        }
        if (!this.myListedLocalPaths.contains(item.getPath())) {
            return super.deleteOrLog(item);
        }
        return false;
    }

    protected void storeListedLocalPaths(List<PyRemoteSourceItem> list) {
        this.myListedLocalPaths.clear();
        for (PyRemoteSourceItem item : list) {
            this.myListedLocalPaths.add(item.getLocalFile(this.getSkeletonsPath()).getPath());
        }
    }

    @Override
    @NotNull
    protected List<PySkeletonGenerator.GenerationResult> runGeneration(@NotNull PySkeletonGenerator.Builder builder, @Nullable ProgressIndicator indicator) throws InvalidSdkException, ExecutionException {
        if (builder == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(3);
        }
        if (this.hasIndependentRemoteSkeletonsDirectory()) {
            File stateMarkerFile = new File(this.getSkeletonsPath(), ".state.json");
            try (FileInputStream stream = new FileInputStream(stateMarkerFile);){
                LOG.debug("Sending skeletons state file to the remote generator: " + stateMarkerFile.getPath());
                String skeletonsState = StreamUtil.readText((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                builder.extraArgs("--state-file-policy", "readwrite");
                builder.stdin(skeletonsState);
            }
            catch (FileNotFoundException ignored) {
                builder.extraArgs("--state-file-policy", "write");
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
        List<PySkeletonGenerator.GenerationResult> results = super.runGeneration(builder, indicator);
        this.myListedBinaries.clear();
        results.stream().map(PySkeletonGenerator.GenerationResult::getModuleOrigin).filter(origin -> !"(built-in)".equals(origin)).forEach(path -> this.myListedBinaries.add((String)path));
        List<PySkeletonGenerator.GenerationResult> list = results;
        if (list == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(4);
        }
        return list;
    }

    protected boolean hasIndependentRemoteSkeletonsDirectory() {
        return this.getRemoteSkeletonsPath() != null;
    }

    @Override
    public boolean exists(@NotNull String name) {
        if (name == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(5);
        }
        return this.myListedBinaries.contains(name);
    }

    @NotNull
    protected PyRemotePathMapper createPathMappings(@Nullable Project project, @NotNull PyRemoteSdkAdditionalDataBase remoteSdkAdditionalData) {
        if (remoteSdkAdditionalData == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(6);
        }
        PyRemotePathMapper pathMapper = new PyRemotePathMapper();
        PythonRemoteInterpreterManager.addHelpersMapping(remoteSdkAdditionalData, pathMapper);
        String skeletonsPath = this.getRemoteSkeletonsPath();
        if (skeletonsPath != null) {
            pathMapper.addMapping(this.getSkeletonsPath(), skeletonsPath, PyRemotePathMapper.PyPathMappingType.SKELETONS);
        }
        PyRemotePathMapper pyRemotePathMapper = pathMapper = PythonRemoteInterpreterManager.appendBasicMappings(project, pathMapper, remoteSdkAdditionalData);
        if (pyRemotePathMapper == null) {
            PyRemoteSkeletonGeneratorBase.$$$reportNull$$$0(7);
        }
        return pyRemotePathMapper;
    }

    protected static String[] addUnbuffered(String homePath, String[] commandLine) {
        ArrayList cmd = Lists.newArrayList((Object[])commandLine);
        if (!homePath.contains("jython")) {
            if (cmd.isEmpty()) {
                LOG.warn("Command line is empty for getProcessOutput");
            } else {
                cmd.add(1, "-u");
            }
        }
        commandLine = ArrayUtilRt.toStringArray((Collection)cmd);
        return commandLine;
    }

    @Nullable
    protected String getRemoteSkeletonsPath() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pySdk";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/PyRemoteSkeletonGeneratorBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSdkAdditionalData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/PyRemoteSkeletonGeneratorBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "listSources";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "runGeneration";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deleteOrLog";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runGeneration";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPathMappings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

