/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.templateLanguages;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.templateLanguages.TemplateFileReference;
import com.jetbrains.python.templateLanguages.TemplatesService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateFileReferenceSet
extends FileReferenceSet {
    private final String mySeparatorString;

    public TemplateFileReferenceSet(@NotNull PsiElement element, @Nullable PsiReferenceProvider provider) {
        if (element == null) {
            TemplateFileReferenceSet.$$$reportNull$$$0(0);
        }
        this(TemplateFileReferenceSet.str(element), element, provider);
    }

    public TemplateFileReferenceSet(String text2, @NotNull PsiElement element, @Nullable PsiReferenceProvider provider) {
        if (element == null) {
            TemplateFileReferenceSet.$$$reportNull$$$0(1);
        }
        super(text2, element, TemplateFileReferenceSet.detectShift(element, text2), provider, SystemInfo.isFileSystemCaseSensitive);
        this.mySeparatorString = TemplateFileReferenceSet.detectSeparator(element);
        this.reparse();
    }

    private static String str(@NotNull PsiElement element) {
        if (element == null) {
            TemplateFileReferenceSet.$$$reportNull$$$0(2);
        }
        return PyStringLiteralUtil.stripQuotesAroundValue(element.getText());
    }

    public static int detectShift(PsiElement element, String text2) {
        String elementText = element.getText();
        int from = 0;
        Pair<String, String> quotes = PyStringLiteralUtil.getQuotes(elementText);
        if (quotes != null) {
            from = ((String)quotes.first).length();
        }
        return elementText.indexOf(text2, from);
    }

    public static String detectSeparator(PsiElement element) {
        String winSeparator = TemplateFileReferenceSet.isRawString(element.getText()) ? "\\" : "\\\\";
        return TemplateFileReferenceSet.str(element).contains(winSeparator) ? winSeparator : "/";
    }

    public String getSeparatorString() {
        if (this.mySeparatorString == null) {
            return super.getSeparatorString();
        }
        return this.mySeparatorString;
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        ArrayList<PsiFileSystemItem> contexts = new ArrayList<PsiFileSystemItem>();
        if (this.getPathString().startsWith("/") || this.getPathString().startsWith("\\")) {
            ArrayList<PsiFileSystemItem> arrayList = contexts;
            if (arrayList == null) {
                TemplateFileReferenceSet.$$$reportNull$$$0(3);
            }
            return arrayList;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        if (module != null) {
            List<VirtualFile> templatesFolders = this.getRoots(module);
            for (VirtualFile folder : templatesFolders) {
                PsiFileSystemItem directory2 = this.getPsiDirectory(module, folder);
                if (directory2 == null) continue;
                contexts.add(directory2);
            }
        }
        ArrayList<PsiFileSystemItem> arrayList = contexts;
        if (arrayList == null) {
            TemplateFileReferenceSet.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Nullable
    protected PsiFileSystemItem getPsiDirectory(@NotNull Module module, @NotNull VirtualFile folder) {
        if (module == null) {
            TemplateFileReferenceSet.$$$reportNull$$$0(5);
        }
        if (folder == null) {
            TemplateFileReferenceSet.$$$reportNull$$$0(6);
        }
        return PsiManager.getInstance((Project)module.getProject()).findDirectory(folder);
    }

    protected List<VirtualFile> getRoots(Module module) {
        return TemplatesService.getInstance(module).getTemplateFolders();
    }

    public FileReference createFileReference(TextRange range, int index, String text2) {
        return new TemplateFileReference(this, range, index, text2);
    }

    private static boolean isRawString(String text2) {
        text2 = StringUtil.toLowerCase((String)text2);
        String text1 = StringUtil.toLowerCase((String)(text2 = StringUtil.trimStart((String)text2, (String)"u")));
        return StringUtil.startsWith((CharSequence)text1, (CharSequence)"r\"") && StringUtil.endsWith((CharSequence)text1, (CharSequence)"\"") || StringUtil.startsWith((CharSequence)text1, (CharSequence)"r'") && StringUtil.endsWith((CharSequence)text1, (CharSequence)"'");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/templateLanguages/TemplateFileReferenceSet";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/templateLanguages/TemplateFileReferenceSet";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDefaultContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "str";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPsiDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

