/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.wsl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLDistributionWithRoot;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.remote.CredentialsType;
import com.intellij.ui.TextAccessor;
import com.intellij.wsl.WSLCredentialsEditor;
import com.intellij.wsl.WSLCredentialsHolder;
import com.intellij.wsl.WSLCredentialsType;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.Result;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.remote.PyRemoteInterpreterUtil;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.sdk.add.PyAddSdkUsingCredentialsEditor;
import com.jetbrains.python.remote.sdk.add.RemoteSdkCreationUtilKt;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.wsl.PyAddWslPanel;
import com.jetbrains.python.wsl.PyWSLUtilsKt;
import com.jetbrains.python.wsl.PyWslPathBrowser;
import com.jetbrains.python.wsl.PythonWslBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001bH\u0014J\b\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0002H\u0014J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0004H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\u00142\u0006\u0010&\u001a\u00020\u001bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0019\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006'"}, d2={"Lcom/jetbrains/python/wsl/PyAddWslPanel;", "Lcom/jetbrains/python/remote/sdk/add/PyAddSdkUsingCredentialsEditor;", "Lcom/intellij/wsl/WSLCredentialsHolder;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "(Ljava/util/List;)V", "browser", "Lcom/jetbrains/python/wsl/PyWslPathBrowser;", "credentialsEditor", "Lcom/intellij/wsl/WSLCredentialsEditor;", "getCredentialsEditor", "()Lcom/intellij/wsl/WSLCredentialsEditor;", "credentialsEditor$delegate", "Lkotlin/Lazy;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "panelName", "", "Lorg/jetbrains/annotations/NotNull;", "getPanelName", "()Ljava/lang/String;", "configure", "", "data", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalData;", "configure$intellij_python_wsl", "createSdk", "additionalData", "getBrowseButtonActionListener", "Ljava/awt/event/ActionListener;", "getHelpersPath", "credentials", "validateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "validateDataAndSuggestName", "sdkAdditionalData", "intellij.python.wsl"})
public final class PyAddWslPanel
extends PyAddSdkUsingCredentialsEditor<WSLCredentialsHolder> {
    @NotNull
    private final Icon icon;
    @NotNull
    private final Lazy credentialsEditor$delegate;
    private final PyWslPathBrowser browser;

    @Override
    @NotNull
    public String getPanelName() {
        String string = PythonWslBundle.message("python.add.sdk.panel.name.wsl", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PythonWslBundle.message(\u2026.add.sdk.panel.name.wsl\")");
        return string;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @NotNull
    protected WSLCredentialsEditor getCredentialsEditor() {
        Lazy lazy = this.credentialsEditor$delegate;
        PyAddWslPanel pyAddWslPanel = this;
        Object var3_3 = null;
        boolean bl = false;
        return (WSLCredentialsEditor)lazy.getValue();
    }

    @Override
    @NotNull
    protected String getHelpersPath(@NotNull WSLCredentialsHolder credentials) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
                object = credentials.getDistribution();
                if (object == null) break block2;
                File file2 = PythonHelpersLocator.getHelpersRoot();
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"PythonHelpersLocator.getHelpersRoot()");
                String string = file2.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PythonHelpersLocator.getHelpersRoot().absolutePath");
                if ((object = PyWSLUtilsKt.toRemotePath(object, string)) != null) break block3;
            }
            object = super.getHelpersPath(credentials);
        }
        return object;
    }

    @Override
    @NotNull
    public List<ValidationInfo> validateAll() {
        if (!WSLUtil.hasAvailableDistributions()) {
            return CollectionsKt.listOf((Object)new ValidationInfo(PythonProBundle.message("python.wsl.error.no.installed.distributions")));
        }
        return super.validateAll();
    }

    @Override
    @NotNull
    protected ActionListener getBrowseButtonActionListener() {
        return new ActionListener(this){
            final /* synthetic */ PyAddWslPanel this$0;

            public final void actionPerformed(ActionEvent it) {
                block0: {
                    WSLDistribution wSLDistribution = this.this$0.getCredentialsEditor().getWslDistribution();
                    if (wSLDistribution == null) break block0;
                    WSLDistribution wSLDistribution2 = wSLDistribution;
                    boolean bl = false;
                    boolean bl2 = false;
                    WSLDistribution distro = wSLDistribution2;
                    boolean bl3 = false;
                    PyWslPathBrowser pyWslPathBrowser = PyAddWslPanel.access$getBrowser$p(this.this$0);
                    WSLDistributionWithRoot wSLDistributionWithRoot = new WSLDistributionWithRoot(distro);
                    JPanel jPanel = this.this$0.getCredentialsEditor().getMainPanel();
                    Intrinsics.checkExpressionValueIsNotNull((Object)jPanel, (String)"credentialsEditor.mainPanel");
                    pyWslPathBrowser.browsePath$intellij_python_wsl(wSLDistributionWithRoot, jPanel);
                }
            }
            {
                this.this$0 = pyAddWslPanel;
            }
        };
    }

    @Override
    @NotNull
    protected Sdk createSdk(@NotNull PyRemoteSdkAdditionalData additionalData) {
        Intrinsics.checkParameterIsNotNull((Object)additionalData, (String)"additionalData");
        return RemoteSdkCreationUtilKt.createAndInitRemoteSdk$default(null, additionalData, this.getExistingSdks(), this.validateDataAndSuggestName(additionalData), 1, null);
    }

    private final String validateDataAndSuggestName(PyRemoteSdkAdditionalData sdkAdditionalData) {
        String string;
        String string2 = PyRemoteInterpreterUtil.getInterpreterVersion(null, sdkAdditionalData, false);
        if (string2 == null) {
            throw (Throwable)((Object)new PyExecutionException("Bad command", sdkAdditionalData.getInterpreterPath(), CollectionsKt.emptyList()));
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PyRemoteInterpreterUtil.\u2026rpreterPath, emptyList())");
        String versionString = string2;
        PythonSdkFlavor pythonSdkFlavor = sdkAdditionalData.getFlavor();
        if (pythonSdkFlavor == null) {
            Intrinsics.throwNpe();
        }
        LanguageLevel languageLevel = pythonSdkFlavor.getLanguageLevelFromVersionString(versionString);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)languageLevel), (String)"sdkAdditionalData.flavor\u2026sionString(versionString)");
        LanguageLevel version = languageLevel;
        Result<WSLDistribution, String> result = PyWSLUtilsKt.getDistribution(sdkAdditionalData);
        boolean bl = false;
        boolean bl2 = false;
        Result<WSLDistribution, String> it = result;
        boolean bl3 = false;
        Result<WSLDistribution, String> result2 = it;
        if (result2 instanceof Result.Success) {
            string = (Object)((Object)version) + " @ " + ((WSLDistribution)((Result.Success)it).getResult()).getPresentableName();
        } else if (result2 instanceof Result.Failure) {
            string = "Error: " + (String)((Result.Failure)it).getError();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public final void configure$intellij_python_wsl(@NotNull PyRemoteSdkAdditionalData data) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            this.getInterpreterPathField().setText(data.getInterpreterPath());
            WSLCredentialsHolder wSLCredentialsHolder = PyWSLUtilsKt.getWslCredentials(data);
            if (wSLCredentialsHolder == null) break block0;
            WSLCredentialsHolder wSLCredentialsHolder2 = wSLCredentialsHolder;
            boolean bl = false;
            boolean bl2 = false;
            WSLCredentialsHolder it = wSLCredentialsHolder2;
            boolean bl3 = false;
            this.getCredentialsEditor().init(it);
        }
    }

    public PyAddWslPanel(@NotNull List<? extends Sdk> existingSdks) {
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        WSLCredentialsType wSLCredentialsType = WSLCredentialsType.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)wSLCredentialsType, (String)"WSLCredentialsType.getInstance()");
        super(existingSdks, (CredentialsType)wSLCredentialsType);
        Icon icon = AllIcons.RunConfigurations.Wsl;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.RunConfigurations.Wsl");
        this.icon = icon;
        this.credentialsEditor$delegate = LazyKt.lazy((Function0)credentialsEditor.2.INSTANCE);
        if (!WSLUtil.hasAvailableDistributions()) {
            this.setLayout(new BorderLayout());
            this.add((Component)Messages.configureMessagePaneUi((JTextPane)new JTextPane(), (String)"<html>You don't have WSL distribution installed. <a href=\"ms-windows-store://search/?query=Linux\">Install WSL distributions.</a></html>"), "North");
        } else {
            this.initUI();
        }
        this.getInterpreterPathField().setText("/usr/bin/python");
        this.browser = new PyWslPathBrowser((TextAccessor)this.getInterpreterPathField());
    }

    public static final /* synthetic */ PyWslPathBrowser access$getBrowser$p(PyAddWslPanel $this) {
        return $this.browser;
    }
}

