/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.wsl;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.wsl.WSLCredentialsHolder;
import com.intellij.wsl.WSLCredentialsType;
import com.jetbrains.extensions.python.ProgressManagerExtKt;
import com.jetbrains.python.Result;
import com.jetbrains.python.console.PydevConsoleCli;
import com.jetbrains.python.console.PydevConsoleCommunicationClient;
import com.jetbrains.python.console.PydevConsoleRunnerImpl;
import com.jetbrains.python.console.PythonConsoleRemoteProcessCreator;
import com.jetbrains.python.console.RemoteConsoleProcessData;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.wsl.PyWSLProcessHandler;
import com.jetbrains.python.wsl.PyWSLSocketProvider;
import com.jetbrains.python.wsl.PyWSLUtilsKt;
import com.jetbrains.python.wsl.Wsl2IPs;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J8\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0016J\u0018\u0010\u0019\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/python/wsl/PyWSLConsoleCreator;", "Lcom/jetbrains/python/console/PythonConsoleRemoteProcessCreator;", "Lcom/intellij/wsl/WSLCredentialsHolder;", "()V", "credentialsType", "Lcom/intellij/wsl/WSLCredentialsType;", "getCredentialsType", "()Lcom/intellij/wsl/WSLCredentialsType;", "createClient", "Lcom/jetbrains/python/console/PydevConsoleCommunicationClient;", "process", "Ljava/lang/Process;", "project", "Lcom/intellij/openapi/project/Project;", "data", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;", "createRemoteConsoleProcess", "Lcom/jetbrains/python/console/RemoteConsoleProcessData;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "pathMapper", "Lcom/jetbrains/python/remote/PyRemotePathMapper;", "runnerFileFromHelpers", "", "credentials", "getLinuxIp", "intellij.python.wsl"})
public final class PyWSLConsoleCreator
implements PythonConsoleRemoteProcessCreator<WSLCredentialsHolder> {
    @NotNull
    public WSLCredentialsType getCredentialsType() {
        WSLCredentialsType wSLCredentialsType = WSLCredentialsType.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)wSLCredentialsType, (String)"WSLCredentialsType.getInstance()");
        return wSLCredentialsType;
    }

    @Override
    @NotNull
    public RemoteConsoleProcessData createRemoteConsoleProcess(@NotNull GeneralCommandLine commandLine, @NotNull PyRemotePathMapper pathMapper, @NotNull Project project, @NotNull PyRemoteSdkAdditionalDataBase data, @NotNull String runnerFileFromHelpers, @NotNull WSLCredentialsHolder credentials) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        Intrinsics.checkParameterIsNotNull((Object)pathMapper, (String)"pathMapper");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)runnerFileFromHelpers, (String)"runnerFileFromHelpers");
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        File file2 = commandLine.getWorkDirectory();
        boolean bl = false;
        boolean bl2 = false;
        File dir = file2;
        boolean bl3 = false;
        if (!dir.exists()) {
            Object object = credentials.getDistribution();
            if (object != null) {
                File file3 = dir;
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"dir");
                if ((object = object.getWindowsPath(FileUtil.toSystemIndependentName((String)file3.getPath()))) != null) {
                    Object object2 = object;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Object winPath = object2;
                    boolean bl6 = false;
                    commandLine.setWorkDirectory(new File((String)winPath));
                }
            }
        }
        PydevConsoleCli.setupPythonConsoleScriptInServerMode$default(commandLine, (SdkAdditionalData)data, null, 2, null);
        PyWSLProcessHandler processHandler2 = PyWSLUtilsKt.startWslProcess$default(project, commandLine, data, false, null, false, 32, null);
        Process process2 = processHandler2.getProcess();
        Intrinsics.checkExpressionValueIsNotNull((Object)process2, (String)"processHandler.process");
        Process process3 = process2;
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
        PydevConsoleCommunicationClient client2 = (PydevConsoleCommunicationClient)ProgressManagerExtKt.runUnderProgress(progressManager, "Accessing WSL...", (Function0)new Function0<PydevConsoleCommunicationClient>(this, process3, project, data){
            final /* synthetic */ PyWSLConsoleCreator this$0;
            final /* synthetic */ Process $process;
            final /* synthetic */ Project $project;
            final /* synthetic */ PyRemoteSdkAdditionalDataBase $data;

            @NotNull
            public final PydevConsoleCommunicationClient invoke() {
                return PyWSLConsoleCreator.access$createClient(this.this$0, this.$process, this.$project, this.$data);
            }
            {
                this.this$0 = pyWSLConsoleCreator;
                this.$process = process2;
                this.$project = project;
                this.$data = pyRemoteSdkAdditionalDataBase;
                super(0);
            }
        });
        client2.connect();
        return new RemoteConsoleProcessData((ProcessHandler)processHandler2, client2, processHandler2.getCommandLine(), process3, new PyWSLSocketProvider(project, data));
    }

    private final PydevConsoleCommunicationClient createClient(Process process2, Project project, PyRemoteSdkAdditionalDataBase data) {
        int remotePort = PydevConsoleRunnerImpl.getRemotePortFromProcess(process2);
        String ip = this.getLinuxIp(project, data);
        return new PydevConsoleCommunicationClient(project, ip, remotePort, process2);
    }

    private final String getLinuxIp(Project project, PyRemoteSdkAdditionalDataBase data) {
        String string;
        if (PyWSLUtilsKt.isWsl1(project, data)) {
            string = "127.0.0.1";
        } else {
            Result<Wsl2IPs, String> wsl2Ip = PyWSLUtilsKt.getWsl2WindowsIp(project, data);
            if (wsl2Ip instanceof Result.Success) {
                string = ((Wsl2IPs)((Result.Success)wsl2Ip).getResult()).getLinIp();
            } else if (wsl2Ip instanceof Result.Failure) {
                Logger.getInstance(PyWSLConsoleCreator.class).warn("Can't get linux ip: " + (String)((Result.Failure)wsl2Ip).getError());
                string = "127.0.0.1";
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public static final /* synthetic */ PydevConsoleCommunicationClient access$createClient(PyWSLConsoleCreator $this, Process process2, Project project, PyRemoteSdkAdditionalDataBase data) {
        return $this.createClient(process2, project, data);
    }
}

