/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.wsl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.jetbrains.python.Result;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSocketToLocalHostProvider;
import com.jetbrains.python.wsl.PyWSLUtilsKt;
import com.jetbrains.python.wsl.Wsl2IPs;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\u0007\u001a\u001e\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b0\b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/wsl/PyWSLSocketProvider;", "Lcom/jetbrains/python/remote/PyRemoteSocketToLocalHostProvider;", "project", "Lcom/intellij/openapi/project/Project;", "additionalData", "Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/python/remote/PyRemoteSdkAdditionalDataBase;)V", "getRemoteSocket", "Lcom/intellij/openapi/util/Pair;", "", "kotlin.jvm.PlatformType", "", "localPort", "intellij.python.wsl"})
public final class PyWSLSocketProvider
implements PyRemoteSocketToLocalHostProvider {
    private final Project project;
    private final PyRemoteSdkAdditionalDataBase additionalData;

    @Override
    @NotNull
    public Pair<String, Integer> getRemoteSocket(int localPort) {
        Pair pair;
        if (PyWSLUtilsKt.isWsl1(this.project, this.additionalData)) {
            pair = new Pair((Object)"127.0.0.1", (Object)localPort);
        } else {
            Result<Wsl2IPs, String> wsl2WindowsIp = PyWSLUtilsKt.getWsl2WindowsIp(this.project, this.additionalData);
            if (wsl2WindowsIp instanceof Result.Success) {
                pair = new Pair((Object)((Wsl2IPs)((Result.Success)wsl2WindowsIp).getResult()).getWinIp(), (Object)localPort);
            } else {
                if (wsl2WindowsIp instanceof Result.Failure) {
                    throw (Throwable)((Object)new AssertionError(((Result.Failure)wsl2WindowsIp).getError()));
                }
                throw new NoWhenBranchMatchedException();
            }
        }
        return pair;
    }

    public PyWSLSocketProvider(@Nullable Project project, @NotNull PyRemoteSdkAdditionalDataBase additionalData) {
        Intrinsics.checkParameterIsNotNull((Object)additionalData, (String)"additionalData");
        this.project = project;
        this.additionalData = additionalData;
    }
}

