/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.web2py.templates.editor;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.web2py.templates.file.Web2PyFileViewProvider;
import com.jetbrains.web2py.templates.lexer.Web2PyTokenTypes;
import com.jetbrains.web2py.templates.psi.Web2PyFile;
import org.jetbrains.annotations.NotNull;

public class Web2PyBracesHandler
extends TypedHandlerDelegate {
    static void typeInStringAndMoveCaret(Editor editor2, String str, int caretShift) {
        EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)str, (boolean)true, (int)caretShift);
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2, @NotNull FileType fileType) {
        if (project == null) {
            Web2PyBracesHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            Web2PyBracesHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            Web2PyBracesHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            Web2PyBracesHandler.$$$reportNull$$$0(3);
        }
        if (file2 instanceof Web2PyFile || file2.getViewProvider() instanceof Web2PyFileViewProvider) {
            Document document = editor2.getDocument();
            int offset = editor2.getCaretModel().getOffset();
            CharSequence chars = document.getCharsSequence();
            if (offset > 0 && chars.charAt(offset - 1) == '{' && c == '{' && (chars.length() <= offset + 1 || chars.charAt(offset + 1) != '}')) {
                String interpolation = "{}}";
                Web2PyBracesHandler.typeInStringAndMoveCaret(editor2, interpolation, 1);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    Web2PyBracesHandler.$$$reportNull$$$0(4);
                }
                return result;
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            Web2PyBracesHandler.$$$reportNull$$$0(5);
        }
        return result;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file2) {
        if (project == null) {
            Web2PyBracesHandler.$$$reportNull$$$0(6);
        }
        if (editor2 == null) {
            Web2PyBracesHandler.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            Web2PyBracesHandler.$$$reportNull$$$0(8);
        }
        if (file2 instanceof Web2PyFile || file2.getViewProvider() instanceof Web2PyFileViewProvider) {
            int offset = editor2.getCaretModel().getOffset();
            PsiElement element = file2.findElementAt(offset - 1);
            if (element == null) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    Web2PyBracesHandler.$$$reportNull$$$0(9);
                }
                return result;
            }
            if (element.getNode().getElementType() == Web2PyTokenTypes.WEB2PY_TAG_END) {
                String text2 = null;
                if (c == '(') {
                    text2 = ")";
                } else if (c == '[') {
                    text2 = "]";
                }
                if (text2 != null) {
                    Web2PyBracesHandler.typeInStringAndMoveCaret(editor2, text2, 0);
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                    if (result == null) {
                        Web2PyBracesHandler.$$$reportNull$$$0(10);
                    }
                    return result;
                }
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            Web2PyBracesHandler.$$$reportNull$$$0(11);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/web2py/templates/editor/Web2PyBracesHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/web2py/templates/editor/Web2PyBracesHandler";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

