/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.web2py.templates.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.parsing.ExpressionParsing;
import com.jetbrains.python.parsing.ParsingContext;
import com.jetbrains.web2py.templates.lexer.Web2PyTokenTypes;
import com.jetbrains.web2py.templates.parser.Web2PyParsingContext;
import com.jetbrains.web2py.templates.parser.Web2PyStatementParsing;
import com.jetbrains.web2py.templates.psi.Web2PyElementTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Web2PyParser
implements PsiParser,
Web2PyElementTypes,
Web2PyTokenTypes {
    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        PsiBuilder.Marker rootMarker = builder.mark();
        Parsing parsing = new Parsing(builder);
        parsing.parseDocument();
        rootMarker.done(root);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            Web2PyParser.$$$reportNull$$$0(0);
        }
        return aSTNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/web2py/templates/parser/Web2PyParser", "parse"));
    }

    private static class Parsing {
        protected ParsingContext myContext;
        private final PsiBuilder myBuilder;
        private final TokenSet ourKeywords = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.IF_KEYWORD, PyTokenTypes.FOR_KEYWORD, PyTokenTypes.CLASS_KEYWORD, PyTokenTypes.DEF_KEYWORD, PyTokenTypes.ELIF_KEYWORD, PyTokenTypes.WHILE_KEYWORD, PyTokenTypes.EXCEPT_KEYWORD, PyTokenTypes.WITH_KEYWORD});

        Parsing(PsiBuilder builder) {
            this.myBuilder = builder;
            this.myContext = new Web2PyParsingContext(this.myBuilder);
        }

        private void parseDocument() {
            while (!this.myBuilder.eof()) {
                this.parseTag();
            }
        }

        private void parseTag() {
            if (this.token() == Web2PyTokenTypes.WEB2PY_TAG_START) {
                PsiBuilder.Marker tag = this.mark();
                this.advance();
                while (this.token() != Web2PyTokenTypes.WEB2PY_TAG_END && !this.myBuilder.eof()) {
                    IElementType token = this.token();
                    PsiBuilder.Marker errorMark = this.myBuilder.mark();
                    boolean hasErrors = this.parseTagContent();
                    if (hasErrors) {
                        errorMark.drop();
                        if (this.token() == Web2PyTokenTypes.WEB2PY_TAG_END) {
                            this.advance();
                            tag.done((IElementType)Web2PyElementTypes.WEB2PY_TAG);
                        } else {
                            this.error("Closing '}}' expected.");
                            tag.drop();
                        }
                        return;
                    }
                    if (token == PyTokenTypes.BAD_CHARACTER) {
                        errorMark.rollbackTo();
                        this.error("Closing '}}' expected.");
                        tag.drop();
                        return;
                    }
                    errorMark.drop();
                    while (this.token() == PyTokenTypes.STATEMENT_BREAK || this.token() == PyTokenTypes.INDENT || this.token() == PyTokenTypes.DEDENT || this.token() == PyTokenTypes.INCONSISTENT_DEDENT) {
                        this.advance();
                    }
                }
                if (this.token() == Web2PyTokenTypes.WEB2PY_TAG_END) {
                    this.advance();
                    tag.done((IElementType)Web2PyElementTypes.WEB2PY_TAG);
                } else {
                    this.error("Closing '}}' expected.");
                    tag.drop();
                }
            } else {
                this.advance();
            }
        }

        private boolean parseTagContent() {
            if (this.token() == PyTokenTypes.EQ) {
                this.advance();
                ExpressionParsing parser = this.myContext.getExpressionParser();
                parser.parseExpression();
            } else if (this.token() == Web2PyTokenTypes.WEB2PY_EXTEND || this.token() == Web2PyTokenTypes.WEB2PY_INCLUDE) {
                this.advance();
                if (this.token() == PyTokenTypes.SINGLE_QUOTED_STRING) {
                    this.myContext.getExpressionParser().parseStringLiteralExpression();
                }
            } else if (this.token() == Web2PyTokenTypes.WEB2PY_BLOCK) {
                this.advance();
                if (this.token() == PyTokenTypes.IDENTIFIER) {
                    this.advance();
                }
            } else if (this.token() == PyTokenTypes.PASS_KEYWORD || this.token() == Web2PyTokenTypes.WEB2PY_SUPER || this.token() == Web2PyTokenTypes.WEB2PY_END) {
                this.advance();
            } else {
                if (this.token() == PyTokenTypes.ELSE_KEYWORD || this.token() == PyTokenTypes.TRY_KEYWORD || this.token() == PyTokenTypes.FINALLY_KEYWORD) {
                    this.advance();
                    if (this.token() != PyTokenTypes.COLON) {
                        this.error("Colon expected");
                        return true;
                    }
                    this.advance();
                    return false;
                }
                if (this.token() == PyTokenTypes.DEF_KEYWORD) {
                    this.myContext.pushScope(this.myContext.emptyParsingScope());
                    this.myContext.getFunctionParser().parseFunctionDeclaration(this.myBuilder.mark(), false);
                    this.myContext.popScope();
                } else {
                    if (this.token() == PyTokenTypes.EXCEPT_KEYWORD) {
                        this.advance();
                        if (this.token() == PyTokenTypes.COLON) {
                            this.advance();
                            return true;
                        }
                        this.myContext.getExpressionParser().parseExpression();
                        if (this.token() != PyTokenTypes.COLON) {
                            this.error("Colon expected");
                            return true;
                        }
                        this.advance();
                        return false;
                    }
                    if (this.ourKeywords.contains(this.token())) {
                        this.advance();
                        this.myContext.getExpressionParser().parseExpression();
                        if (this.token() != PyTokenTypes.COLON) {
                            this.error("Colon expected");
                            return true;
                        }
                        this.advance();
                        return false;
                    }
                    Web2PyStatementParsing statementParser = (Web2PyStatementParsing)this.myContext.getStatementParser();
                    this.myContext.pushScope(this.myContext.emptyParsingScope());
                    statementParser.parseStatement();
                    this.myContext.popScope();
                    if (statementParser.isHasError()) {
                        statementParser.setHasError(false);
                        return true;
                    }
                    return false;
                }
            }
            return false;
        }

        private IElementType token() {
            return this.myBuilder.getTokenType();
        }

        private PsiBuilder.Marker mark() {
            return this.myBuilder.mark();
        }

        private void advance() {
            this.myBuilder.advanceLexer();
        }

        private void error(@Nullable PsiBuilder.Marker marker, @NotNull String errorString) {
            if (errorString == null) {
                Parsing.$$$reportNull$$$0(0);
            }
            PsiBuilder.Marker err = this.mark();
            err.error(errorString);
            this.advance();
            if (marker != null) {
                marker.drop();
            }
        }

        private void error(@NotNull String errorString) {
            if (errorString == null) {
                Parsing.$$$reportNull$$$0(1);
            }
            this.error(null, errorString);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorString", "com/jetbrains/web2py/templates/parser/Web2PyParser$Parsing", "error"));
        }
    }
}

