/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.debugger;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.core.impl.file.NotebookVirtualFile;
import org.jetbrains.plugins.notebooks.jupyter.debugger.CellSourcePosition;
import org.jetbrains.plugins.notebooks.jupyter.debugger.JupyterDebugProcess;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterCellUtilKt;
import org.jetbrains.plugins.notebooks.jupyter.psi.JupyterCell;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005J\u0016\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0006J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\tJ \u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u001fH\u0002J\"\u0010$\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u001d2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u0013R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/debugger/JupyterDebugCellIdManager;", "Lcom/intellij/openapi/Disposable;", "()V", "idToPosition", "", "", "Lorg/jetbrains/plugins/notebooks/jupyter/debugger/CellSourcePosition;", "indexedFiles", "", "", "latestCellId", "latestCellPosition", "positionToId", "cleanPositionsForFile", "", "filepath", "dispose", "generateCellId", "cell", "Lorg/jetbrains/plugins/notebooks/jupyter/psi/JupyterCell;", "getCellPositionById", "project", "Lcom/intellij/openapi/project/Project;", "cellId", "getIdByPosition", "cellPosition", "getValidCellIds", "", "notebookFile", "Lorg/jetbrains/plugins/notebooks/core/impl/file/NotebookVirtualFile;", "isFileIndexed", "", "updateCellInfo", "originalFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "latest", "updatePositions", "virtualFile", "latestCell", "Companion", "intellij.python.jupyter"})
public final class JupyterDebugCellIdManager
implements Disposable {
    private Map<Integer, CellSourcePosition> idToPosition;
    private Map<CellSourcePosition, Integer> positionToId;
    private Set<String> indexedFiles;
    private CellSourcePosition latestCellPosition;
    private int latestCellId;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    public final synchronized void updatePositions(@NotNull Project project, @NotNull NotebookVirtualFile virtualFile2, @Nullable JupyterCell latestCell) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)virtualFile2), (String)"virtualFile");
        VirtualFile originalFile = virtualFile2.getOriginFile();
        String string = originalFile.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"originalFile.path");
        String filePath = string;
        this.cleanPositionsForFile(filePath);
        this.indexedFiles.add(filePath);
        List<JupyterCell> list = JupyterCellUtilKt.getCells(project, virtualFile2);
        if (list == null) {
            return;
        }
        List<JupyterCell> cells2 = list;
        for (JupyterCell cell : cells2) {
            this.updateCellInfo(originalFile, cell, false);
        }
        if (latestCell != null) {
            this.updateCellInfo(originalFile, latestCell, true);
        }
    }

    public static /* synthetic */ void updatePositions$default(JupyterDebugCellIdManager jupyterDebugCellIdManager, Project project, NotebookVirtualFile notebookVirtualFile, JupyterCell jupyterCell, int n, Object object) {
        if ((n & 4) != 0) {
            jupyterCell = null;
        }
        jupyterDebugCellIdManager.updatePositions(project, notebookVirtualFile, jupyterCell);
    }

    private final void updateCellInfo(VirtualFile originalFile, JupyterCell cell, boolean latest) {
        int cellId = this.generateCellId(cell);
        CellSourcePosition cellPosition = JupyterCellUtilKt.getCellPositionForJupyterCell(originalFile, cell);
        if (cellPosition != null) {
            this.idToPosition.put(cellId, cellPosition);
            this.positionToId.put(cellPosition, cellId);
        }
        if (latest) {
            this.latestCellPosition = cellPosition;
            this.latestCellId = cellId;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> getValidCellIds(@NotNull NotebookVirtualFile notebookFile) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)notebookFile), (String)"notebookFile");
        Map<CellSourcePosition, Integer> $this$filter$iv = this.positionToId;
        boolean $i$f$filter = false;
        Map<CellSourcePosition, Integer> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var7_7 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var7_7.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            VirtualFile virtualFile2 = ((CellSourcePosition)it.getKey()).getStart().getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"it.key.start.file");
            if (!Intrinsics.areEqual((Object)virtualFile2.getPath(), (Object)notebookFile.getOriginFile().getPath())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.toList((Iterable)destination$iv$iv.values());
    }

    private final void cleanPositionsForFile(String filepath) {
        Map.Entry<Object, Object> it;
        Map<Integer, CellSourcePosition> $this$filterTo$iv$iv;
        Map<Integer, CellSourcePosition> $this$filter$iv;
        Map<CellSourcePosition, Integer> map2 = this.positionToId;
        JupyterDebugCellIdManager jupyterDebugCellIdManager = this;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Map<Integer, CellSourcePosition> map3 = $this$filterTo$iv$iv;
        boolean bl = false;
        for (Map.Entry entry : map3.entrySet()) {
            it = entry;
            boolean bl2 = false;
            VirtualFile virtualFile2 = ((CellSourcePosition)it.getKey()).getStart().getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"it.key.start.file");
            if (!(Intrinsics.areEqual((Object)virtualFile2.getPath(), (Object)filepath) ^ true)) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        Map map4 = destination$iv$iv;
        jupyterDebugCellIdManager.positionToId = MapsKt.toMutableMap((Map)map4);
        $this$filter$iv = this.idToPosition;
        jupyterDebugCellIdManager = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        map3 = $this$filterTo$iv$iv;
        bl = false;
        for (Map.Entry<Object, Object> entry : map3.entrySet()) {
            it = entry;
            boolean bl3 = false;
            VirtualFile virtualFile3 = ((CellSourcePosition)it.getValue()).getStart().getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"it.value.start.file");
            if (!(Intrinsics.areEqual((Object)virtualFile3.getPath(), (Object)filepath) ^ true)) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        map4 = destination$iv$iv;
        jupyterDebugCellIdManager.idToPosition = MapsKt.toMutableMap((Map)map4);
    }

    public final synchronized boolean isFileIndexed(@NotNull String filepath) {
        Intrinsics.checkParameterIsNotNull((Object)filepath, (String)"filepath");
        return this.indexedFiles.contains(filepath);
    }

    public final int generateCellId(@NotNull JupyterCell cell) {
        Intrinsics.checkParameterIsNotNull((Object)cell, (String)"cell");
        return cell.getText().hashCode();
    }

    @Nullable
    public final synchronized CellSourcePosition getCellPositionById(@NotNull Project project, int cellId) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        CellSourcePosition position = this.idToPosition.get(cellId);
        if (position == null) {
            JupyterDebugProcess.Companion.showCellEditedDuringSession(project);
            return this.latestCellPosition;
        }
        return position;
    }

    public final synchronized int getIdByPosition(@NotNull Project project, @NotNull CellSourcePosition cellPosition) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)cellPosition, (String)"cellPosition");
        Integer id = this.positionToId.get(cellPosition);
        if (id == null) {
            VirtualFile virtualFile2 = cellPosition.getStart().getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"cellPosition.start.file");
            if (this.indexedFiles.contains(virtualFile2.getPath())) {
                JupyterDebugProcess.Companion.showCellEditedDuringSession(project);
            }
            return 0;
        }
        int n = this.latestCellId;
        if (id == n && Intrinsics.areEqual((Object)cellPosition, (Object)this.latestCellPosition) ^ true) {
            return 0;
        }
        return id;
    }

    public void dispose() {
        this.idToPosition.clear();
        this.positionToId.clear();
        this.latestCellPosition = null;
    }

    public JupyterDebugCellIdManager() {
        JupyterDebugCellIdManager jupyterDebugCellIdManager = this;
        boolean bl = false;
        Object object = new LinkedHashMap();
        jupyterDebugCellIdManager.idToPosition = object;
        jupyterDebugCellIdManager = this;
        bl = false;
        object = new LinkedHashMap();
        jupyterDebugCellIdManager.positionToId = object;
        jupyterDebugCellIdManager = this;
        bl = false;
        jupyterDebugCellIdManager.indexedFiles = object = (Set)new LinkedHashSet();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Metho\u2026s.lookup().lookupClass())");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/debugger/JupyterDebugCellIdManager$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lorg/jetbrains/plugins/notebooks/jupyter/debugger/JupyterDebugCellIdManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.python.jupyter"})
    public static final class Companion {
        @NotNull
        public final JupyterDebugCellIdManager getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, JupyterDebugCellIdManager.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026ellIdManager::class.java)");
            return (JupyterDebugCellIdManager)object;
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

