/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.editor;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyUtil;
import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.core.impl.file.NotebookVirtualFile;
import org.jetbrains.plugins.notebooks.jupyter.actions.JupyterEditorActionsKt;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterRuntimeService;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.JupyterWebSockerClientClosedException;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterCellExecutionCallbackAdapter;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.core.JupyterNotebookSession;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterCompleteRequestMessageBuilder;
import org.jetbrains.plugins.notebooks.jupyter.connections.execution.message.JupyterMessage;
import org.jetbrains.plugins.notebooks.jupyter.connections.http.JupyterRestClientErrorResponseException;
import org.jetbrains.plugins.notebooks.jupyter.editor.JupyterRuntimeCompletionContributorKt;
import org.jetbrains.plugins.notebooks.jupyter.python.JupyterPyDialect;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002JF\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u0018R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterRuntimeCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "()V", "replyNotifier", "Ljava/util/concurrent/CountDownLatch;", "getReplyNotifier", "()Ljava/util/concurrent/CountDownLatch;", "setReplyNotifier", "(Ljava/util/concurrent/CountDownLatch;)V", "sendCompleteRequestMessage", "", "session", "Lorg/jetbrains/plugins/notebooks/jupyter/connections/execution/core/JupyterNotebookSession;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "otherResults", "", "Lcom/intellij/codeInsight/completion/CompletionResult;", "code", "", "cursorPos", "", "qualifier", "parent", "Lcom/intellij/psi/PsiElement;", "Companion", "intellij.python.jupyter"})
public final class JupyterRuntimeCompletionContributor
extends CompletionContributor {
    @NotNull
    private CountDownLatch replyNotifier = new CountDownLatch(1);
    @NotNull
    private static final Logger LOG;
    private static final String JUPYTER_RUNTIME = "Jupyter Runtime";
    private static final String COMPLETION_LOG_MESSAGE = "Failed to send Jupyter completion message:";
    public static final Companion Companion;

    @NotNull
    public final CountDownLatch getReplyNotifier() {
        return this.replyNotifier;
    }

    public final void setReplyNotifier(@NotNull CountDownLatch countDownLatch) {
        Intrinsics.checkParameterIsNotNull((Object)countDownLatch, (String)"<set-?>");
        this.replyNotifier = countDownLatch;
    }

    public final void sendCompleteRequestMessage(@NotNull JupyterNotebookSession session, @NotNull CompletionResultSet result, @NotNull Set<? extends CompletionResult> otherResults, @NotNull String code, int cursorPos, @Nullable String qualifier, @NotNull PsiElement parent) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Intrinsics.checkParameterIsNotNull(otherResults, (String)"otherResults");
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        JupyterMessage message = new JupyterCompleteRequestMessageBuilder(code, cursorPos, session.getSessionId(), null, 8, null).build();
        session.sendMessage(message, new JupyterCellExecutionCallbackAdapter(this, otherResults, qualifier, parent, result){
            final /* synthetic */ JupyterRuntimeCompletionContributor this$0;
            final /* synthetic */ Set $otherResults;
            final /* synthetic */ String $qualifier;
            final /* synthetic */ PsiElement $parent;
            final /* synthetic */ CompletionResultSet $result;

            /*
             * WARNING - void declaration
             */
            public void onCompleteReply(@NotNull JupyterMessage message) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                Iterable $this$map$iv = this.$otherResults;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CompletionResult completionResult = (CompletionResult)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    LookupElement lookupElement = it.getLookupElement();
                    Intrinsics.checkExpressionValueIsNotNull((Object)lookupElement, (String)"it.lookupElement");
                    String string = lookupElement.getLookupString();
                    collection.add(string);
                }
                List otherCompletionStrings = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                List<String> list = JupyterRuntimeCompletionContributorKt.getCompletionMatches(message, this.$qualifier, this.$parent);
                if (list != null) {
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$filterTo$iv$iv;
                    List<String> list2 = list;
                    boolean bl = false;
                    boolean bl2 = false;
                    List<String> completionMatches = list2;
                    boolean bl3 = false;
                    boolean isSubscription = this.$parent instanceof PySubscriptionExpression || this.$parent instanceof PyStringLiteralExpression && ((PyStringLiteralExpression)this.$parent).getParent() instanceof PySubscriptionExpression;
                    Iterable $this$filter$iv = completionMatches;
                    boolean $i$f$filter = false;
                    Iterable bl4 = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        String it = (String)element$iv$iv;
                        boolean bl5 = false;
                        if (!(!otherCompletionStrings.contains(it))) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    Iterable $this$mapNotNull$iv = (List)destination$iv$iv2;
                    boolean $i$f$mapNotNull = false;
                    $this$filterTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv2 = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        LookupElementBuilder lookupElementBuilder;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl6 = false;
                        String it = (String)element$iv$iv;
                        boolean bl7 = false;
                        String typeText = isSubscription && StringsKt.startsWith$default((String)it, (String)"'", (boolean)false, (int)2, null) ? "dict key" : "Jupyter Runtime";
                        if (LookupElementBuilder.create((String)it).withTypeText(typeText) == null) continue;
                        boolean bl8 = false;
                        boolean bl9 = false;
                        LookupElementBuilder it$iv$iv = lookupElementBuilder;
                        boolean bl10 = false;
                        destination$iv$iv2.add(it$iv$iv);
                    }
                    List lookupElements = (List)destination$iv$iv2;
                    this.$result.addAllElements((Iterable)lookupElements);
                }
                this.this$0.getReplyNotifier().countDown();
            }
            {
                this.this$0 = $outer;
                this.$otherResults = $captured_local_variable$1;
                this.$qualifier = $captured_local_variable$2;
                this.$parent = $captured_local_variable$3;
                this.$result = $captured_local_variable$4;
            }
        });
    }

    public JupyterRuntimeCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                PsiFile psiFile = parameters.getOriginalFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"parameters.originalFile");
                PsiFile psiFile2 = psiFile;
                if (Intrinsics.areEqual((Object)psiFile2.getLanguage(), (Object)((Object)JupyterPyDialect.INSTANCE)) ^ true) {
                    return;
                }
                VirtualFile virtualFile2 = psiFile2.getVirtualFile();
                if (!(virtualFile2 instanceof NotebookVirtualFile)) {
                    virtualFile2 = null;
                }
                NotebookVirtualFile notebookVirtualFile = (NotebookVirtualFile)virtualFile2;
                if (notebookVirtualFile == null) {
                    return;
                }
                NotebookVirtualFile notebookVirtualFile2 = notebookVirtualFile;
                Project project = psiFile2.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"psiFile.project");
                if (JupyterEditorActionsKt.isUnderDebugger(project, notebookVirtualFile2)) {
                    return;
                }
                Project project2 = psiFile2.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"psiFile.project");
                JupyterRuntimeService jupyterRuntimeService = JupyterRuntimeService.Companion.getInstance(project2);
                VirtualFile virtualFile3 = psiFile2.getVirtualFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"psiFile.virtualFile");
                JupyterNotebookSession jupyterNotebookSession = jupyterRuntimeService.getSession(virtualFile3);
                if (jupyterNotebookSession == null) {
                    return;
                }
                JupyterNotebookSession session = jupyterNotebookSession;
                LinkedHashSet otherResults = result.runRemainingContributors(parameters, true);
                ProgressManager.checkCanceled();
                Editor editor2 = parameters.getEditor();
                Intrinsics.checkExpressionValueIsNotNull((Object)editor2, (String)"parameters.editor");
                Editor editor3 = editor2;
                CaretModel caretModel = editor3.getCaretModel();
                Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
                int caretOffset = caretModel.getOffset();
                PsiElement psiElement = PyUtil.findElementAtOffset(psiFile2, caretOffset);
                if (psiElement == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"PyUtil.findElementAtOffs\u2026e, caretOffset) ?: return");
                PsiElement caretElement = psiElement;
                PyStatement pyStatement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)caretElement, PyStatement.class);
                if (pyStatement == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)pyStatement, (String)"PsiTreeUtil.getParentOfT\u2026nt::class.java) ?: return");
                PyStatement caretStatement = pyStatement;
                int startOffset = caretStatement.getTextOffset();
                PyReferenceExpression ref = (PyReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)caretElement, PyReferenceExpression.class);
                PyExpression pyExpression = ref;
                String qualifier = pyExpression != null && (pyExpression = pyExpression.getQualifier()) != null ? pyExpression.getText() : null;
                this.setReplyNotifier(new CountDownLatch(1));
                String statementText = caretStatement.getText();
                PsiElement parent = caretElement.getParent();
                Callable callable = new Callable<Unit>(this, session, result, otherResults, statementText, caretOffset, startOffset, qualifier, parent){
                    final /* synthetic */ 1 this$0;
                    final /* synthetic */ JupyterNotebookSession $session;
                    final /* synthetic */ CompletionResultSet $result;
                    final /* synthetic */ LinkedHashSet $otherResults;
                    final /* synthetic */ String $statementText;
                    final /* synthetic */ int $caretOffset;
                    final /* synthetic */ int $startOffset;
                    final /* synthetic */ String $qualifier;
                    final /* synthetic */ PsiElement $parent;

                    public final void call() {
                        block2: {
                            try {
                                JupyterRuntimeCompletionContributor jupyterRuntimeCompletionContributor = this.this$0.this;
                                LinkedHashSet linkedHashSet = this.$otherResults;
                                Intrinsics.checkExpressionValueIsNotNull((Object)linkedHashSet, (String)"otherResults");
                                Set set = linkedHashSet;
                                String string = this.$statementText;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"statementText");
                                PsiElement psiElement = this.$parent;
                                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"parent");
                                jupyterRuntimeCompletionContributor.sendCompleteRequestMessage(this.$session, this.$result, set, string, this.$caretOffset - this.$startOffset, this.$qualifier, psiElement);
                                this.this$0.this.getReplyNotifier().await();
                            }
                            catch (Throwable e) {
                                Throwable throwable = e;
                                if (throwable instanceof InterruptedException || throwable instanceof JupyterWebSockerClientClosedException || throwable instanceof JupyterRestClientErrorResponseException || throwable instanceof ConnectException) break block2;
                                JupyterRuntimeCompletionContributor.Companion.getLOG().warn("Failed to send Jupyter completion message:", e);
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$session = jupyterNotebookSession;
                        this.$result = completionResultSet;
                        this.$otherResults = linkedHashSet;
                        this.$statementText = string;
                        this.$caretOffset = n;
                        this.$startOffset = n2;
                        this.$qualifier = string2;
                        this.$parent = psiElement;
                    }
                };
                ProgressManager progressManager = ProgressManager.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
                ApplicationUtil.runWithCheckCanceled((Callable)callable, (ProgressIndicator)progressManager.getProgressIndicator());
            }
        });
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(MethodHandles.lookup().lookupClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(Metho\u2026s.lookup().lookupClass())");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/editor/JupyterRuntimeCompletionContributor$Companion;", "", "()V", "COMPLETION_LOG_MESSAGE", "", "JUPYTER_RUNTIME", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.jupyter"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

