/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.jupyter.variables.introspect;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.jupyter.JupyterBundle;
import org.jetbrains.plugins.notebooks.jupyter.variables.introspect.JupyterIntrospectionManagerKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0004R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/notebooks/jupyter/variables/introspect/JupyterIntrospectionPanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/Disposable;", "text", "", "(Ljava/lang/String;)V", "scrollPane", "Ljavax/swing/JScrollPane;", "createContent", "Lcom/intellij/ui/content/Content;", "dispose", "", "scrollToStart", "showIntrospectionInfo", "intellij.python.jupyter"})
final class JupyterIntrospectionPanel
extends SimpleToolWindowPanel
implements Disposable {
    private JScrollPane scrollPane;

    public final void showIntrospectionInfo(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        this.removeAll();
        JBTextArea initLabel = new JBTextArea();
        initLabel.setText(JupyterIntrospectionManagerKt.reformatIntrospectionText(text2));
        initLabel.setBorder(BorderFactory.createEmptyBorder(20, 20, 0, 0));
        initLabel.setEditable(false);
        this.scrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)initLabel), (boolean)true);
        this.add(this.scrollPane);
        this.repaint();
    }

    public final void scrollToStart() {
        block0: {
            JComponent jComponent = this.scrollPane;
            if (jComponent == null || (jComponent = ((JScrollPane)jComponent).getVerticalScrollBar()) == null) break block0;
            ((JScrollBar)jComponent).setValue(0);
        }
    }

    @NotNull
    public final Content createContent() {
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content content2 = contentFactory.createContent((JComponent)((Object)this), JupyterBundle.message("jupyter.introspection", new Object[0]), true);
        Intrinsics.checkExpressionValueIsNotNull((Object)content2, (String)"contentFactory.createCon\u2026er.introspection\"), true)");
        Content content3 = content2;
        content3.setComponent((JComponent)((Object)this));
        content3.setShouldDisposeContent(true);
        Disposer.register((Disposable)this, (Disposable)((Disposable)content3));
        return content3;
    }

    public void dispose() {
    }

    public JupyterIntrospectionPanel(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        super(false);
        this.showIntrospectionInfo(text2);
    }
}

