/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.inspections.CucumberCreateAllStepsFix;
import org.jetbrains.plugins.cucumber.inspections.CucumberCreateStepFix;
import org.jetbrains.plugins.cucumber.inspections.GherkinInspection;
import org.jetbrains.plugins.cucumber.psi.GherkinElementVisitor;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.CucumberStepHelper;
import org.jetbrains.plugins.cucumber.steps.reference.CucumberStepReference;

public class CucumberStepInspection
extends GherkinInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        return "CucumberUndefinedStep";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CucumberStepInspection.$$$reportNull$$$0(0);
        }
        return new GherkinElementVisitor(){

            @Override
            public void visitStep(GherkinStep step) {
                super.visitStep(step);
                PsiElement parent = step.getParent();
                if (parent instanceof GherkinStepsHolder) {
                    PsiReference[] references = step.getReferences();
                    if (references.length != 1 || !(references[0] instanceof CucumberStepReference)) {
                        return;
                    }
                    CucumberStepReference reference = (CucumberStepReference)references[0];
                    AbstractStepDefinition definition = reference.resolveToDefinition();
                    if (definition == null) {
                        CucumberCreateStepFix createStepFix = null;
                        CucumberCreateAllStepsFix createAllStepsFix = null;
                        if (CucumberStepHelper.getExtensionCount() > 0) {
                            createStepFix = new CucumberCreateStepFix();
                            createAllStepsFix = new CucumberCreateAllStepsFix();
                        }
                        holder.registerProblem(reference.getElement(), reference.getRangeInElement(), CucumberBundle.message("cucumber.inspection.undefined.step.msg.name", new Object[0]) + " #loc #ref", new LocalQuickFix[]{createStepFix, createAllStepsFix});
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/cucumber/inspections/CucumberStepInspection", "buildVisitor"));
    }
}

