/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.cell.JTableCellReader;
import org.fest.swing.driver.BasicCellRendererReader;
import org.fest.swing.driver.BasicJComboBoxCellReader;
import org.fest.swing.driver.CellRendererReader;
import org.fest.swing.driver.ModelValueToString;
import org.fest.util.Preconditions;

public class BasicJTableCellReader
implements JTableCellReader {
    private final CellRendererReader rendererReader;
    private final BasicJComboBoxCellReader comboBoxCellReader = new BasicJComboBoxCellReader();

    public BasicJTableCellReader() {
        this(new BasicCellRendererReader());
    }

    public BasicJTableCellReader(@Nonnull CellRendererReader reader) {
        this.rendererReader = (CellRendererReader)Preconditions.checkNotNull((Object)reader);
    }

    @Override
    @Nullable
    @RunsInCurrentThread
    public String valueAt(@Nonnull JTable table, int row, int column) {
        String value;
        Component c = this.cellRendererIn(table, row, column);
        String string = value = c != null ? this.rendererReader.valueFrom(c) : null;
        if (value != null) {
            return value;
        }
        if (c instanceof JLabel) {
            return ((JLabel)c).getText();
        }
        if (c instanceof JCheckBox) {
            return String.valueOf(((JCheckBox)c).isSelected());
        }
        if (c instanceof JComboBox) {
            return this.valueAsText((JComboBox)c);
        }
        return ModelValueToString.asText(table.getValueAt(row, column));
    }

    @Nullable
    private String valueAsText(@Nonnull JComboBox comboBox) {
        int selectedIndex = comboBox.getSelectedIndex();
        if (selectedIndex == -1) {
            return null;
        }
        return this.comboBoxCellReader.valueAt(comboBox, selectedIndex);
    }

    @Override
    @Nullable
    @RunsInCurrentThread
    public Font fontAt(@Nonnull JTable table, int row, int column) {
        Component c = this.cellRendererIn(table, row, column);
        return c != null ? c.getFont() : null;
    }

    @Override
    @Nullable
    @RunsInCurrentThread
    public Color backgroundAt(@Nonnull JTable table, int row, int column) {
        Component c = this.cellRendererIn(table, row, column);
        return c != null ? c.getBackground() : null;
    }

    @Override
    @Nullable
    @RunsInCurrentThread
    public Color foregroundAt(@Nonnull JTable table, int row, int column) {
        Component c = this.cellRendererIn(table, row, column);
        return c != null ? c.getForeground() : null;
    }

    @Nullable
    @RunsInCurrentThread
    private Component cellRendererIn(@Nonnull JTable table, int row, int column) {
        return table.prepareRenderer(table.getCellRenderer(row, column), row, column);
    }
}

