/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.cell.JTreeCellReader;
import org.fest.swing.driver.BasicCellRendererReader;
import org.fest.swing.driver.CellRendererReader;
import org.fest.swing.util.Strings;
import org.fest.util.Preconditions;

public class BasicJTreeCellReader
implements JTreeCellReader {
    private final CellRendererReader rendererReader;

    public BasicJTreeCellReader() {
        this(new BasicCellRendererReader());
    }

    public BasicJTreeCellReader(@Nonnull CellRendererReader reader) {
        this.rendererReader = (CellRendererReader)Preconditions.checkNotNull((Object)reader);
    }

    @Override
    @Nullable
    @RunsInCurrentThread
    public String valueAt(@Nonnull JTree tree, @Nullable Object modelValue) {
        String value;
        TreeCellRenderer r = tree.getCellRenderer();
        Component c = r.getTreeCellRendererComponent(tree, modelValue, false, false, false, 0, false);
        String string = value = c != null ? this.rendererReader.valueFrom(c) : null;
        if (value != null) {
            return value;
        }
        value = tree.convertValueToText(modelValue, false, false, false, 0, false);
        if (Strings.isDefaultToString(value)) {
            return null;
        }
        return value;
    }
}

