/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.core.matcher.JButtonMatcher;
import org.fest.swing.driver.ComponentPreconditions;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JFileChooserApproveButtonTextQuery;
import org.fest.swing.driver.JFileChooserCancelButtonTextQuery;
import org.fest.swing.driver.JFileChooserSelectFileTask;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

@InternalApi
public class JFileChooserDriver
extends JComponentDriver {
    private static final String APPROVE_BUTTON = "Approve";
    private static final String CANCEL_BUTTON = "Cancel";

    public JFileChooserDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void selectFile(@Nonnull JFileChooser fileChooser, @Nonnull File file) {
        JFileChooserSelectFileTask.setSelectedFile(fileChooser, (File)Preconditions.checkNotNull((Object)file));
    }

    public void selectFiles(@Nonnull JFileChooser fileChooser, @Nonnull File[] files) {
        Preconditions.checkNotNull((Object)files);
        for (File file : (File[])Preconditions.checkNotNullOrEmpty((Object[])files)) {
            Preconditions.checkNotNull((Object)file);
        }
        JFileChooserSelectFileTask.setSelectedFiles(fileChooser, files);
    }

    @RunsInEDT
    public void setCurrentDirectory(final @Nonnull JFileChooser fileChooser, final @Nonnull File dir) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                ComponentPreconditions.checkEnabledAndShowing(fileChooser);
                fileChooser.setCurrentDirectory(dir);
            }
        });
    }

    @RunsInEDT
    public JTextField fileNameTextBox(@Nonnull JFileChooser fileChooser) {
        return this.robot.finder().findByType(fileChooser, JTextField.class);
    }

    @RunsInEDT
    public void clickCancelButton(@Nonnull JFileChooser fileChooser) {
        this.click(this.cancelButton(fileChooser));
    }

    @Nonnull
    @RunsInEDT
    public JButton cancelButton(@Nonnull JFileChooser fileChooser) {
        return this.findButton(fileChooser, CANCEL_BUTTON, JFileChooserCancelButtonTextQuery.cancelButtonText());
    }

    @RunsInEDT
    public void clickApproveButton(@Nonnull JFileChooser fileChooser) {
        this.click(this.approveButton(fileChooser));
    }

    @Nonnull
    @RunsInEDT
    public JButton approveButton(@Nonnull JFileChooser fileChooser) {
        return this.findButton(fileChooser, APPROVE_BUTTON, JFileChooserApproveButtonTextQuery.approveButtonTextFrom(fileChooser));
    }

    @Nonnull
    @RunsInEDT
    private JButton findButton(@Nonnull JFileChooser fileChooser, @Nonnull String logicalName, @Nullable String text) {
        return this.robot.finder().find((Container)fileChooser, JButtonMatcher.withText(text).andShowing());
    }
}

