/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.cli;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.npm.registry.NpmRegistryService;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.angular2.cli.AngularCliSchematicsRegistryService;
import org.angular2.cli.AngularCliUtil;
import org.angular2.cli.Schematic;
import org.angular2.cli.SchematicsLoaderKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularCliSchematicsRegistryServiceImpl
extends AngularCliSchematicsRegistryService {
    @NonNls
    private static final String USER_AGENT = "JetBrains IDE";
    @NonNls
    private static final String NG_PACKAGES_URL = "https://raw.githubusercontent.com/JetBrains/intellij-plugins/master/AngularJS/resources/org/angularjs/cli/ng-packages.json";
    @NonNls
    private static final Logger LOG = Logger.getInstance(AngularCliSchematicsRegistryServiceImpl.class);
    private static final int CACHE_EXPIRY = 1500000;
    @NonNls
    private static final ExecutorService ourExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Angular CLI Schematics Registry Pool", (int)5);
    @NonNls
    private static final Key<CachedSchematics> SCHEMATICS_PUBLIC = new Key("angular.cli.schematics.public");
    @NonNls
    private static final Key<CachedSchematics> SCHEMATICS_ALL = new Key("angular.cli.schematics.all");
    private static final SimpleModificationTracker SCHEMATICS_CACHE_TRACKER = new SimpleModificationTracker();
    @NonNls
    private static final String NG_PACKAGES_JSON_PATH = "../../angularjs/cli/ng-packages.json";
    @NonNls
    private static final String SCHEMATICS_PROP = "schematics";
    @NonNls
    private static final String NG_ADD_SCHEMATIC = "ng-add";
    private final CachedValue<List<NodePackageBasicInfo>> myNgAddPackages = new CachedValue<List>(AngularCliSchematicsRegistryServiceImpl::fetchPackagesSupportingNgAdd);
    private final Map<String, Pair<Boolean, Long>> myLocalNgAddPackages = ContainerUtil.newConcurrentMap();
    private final Map<String, CachedValue<Boolean>> myNgAddSupportedCache = ContainerUtil.newConcurrentMap();

    @Override
    @NotNull
    public List<NodePackageBasicInfo> getPackagesSupportingNgAdd(long timeout) {
        List list = ContainerUtil.notNullize(this.myNgAddPackages.getValue(timeout));
        if (list == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    public boolean supportsNgAdd(@NotNull String packageName, long timeout) {
        if (packageName == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(1);
        }
        return this.getPackagesSupportingNgAdd(timeout).stream().anyMatch(pkg -> packageName.equals(pkg.getName()));
    }

    @Override
    public boolean supportsNgAdd(@NotNull String packageName, @NotNull String versionOrRange, long timeout) {
        if (packageName == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(2);
        }
        if (versionOrRange == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(3);
        }
        return this.supportsNgAdd(packageName, timeout) && Boolean.TRUE.equals(this.myNgAddSupportedCache.computeIfAbsent(AngularCliSchematicsRegistryServiceImpl.getKey(packageName, versionOrRange), k -> new CachedValue<Boolean>(() -> AngularCliSchematicsRegistryServiceImpl.checkForNgAddSupport(packageName, versionOrRange))).getValue(timeout));
    }

    @Override
    public boolean supportsNgAdd(@NotNull InstalledPackageVersion version) {
        if (version == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(4);
        }
        try {
            if (version.getPackageJson() != null) {
                return (Boolean)this.myLocalNgAddPackages.compute(version.getPackageJson().getPath(), (key, curValue) -> {
                    if (curValue != null && version.getPackageJson().getModificationStamp() == ((Long)curValue.getSecond()).longValue()) {
                        return curValue;
                    }
                    try {
                        File schematicsCollection = AngularCliSchematicsRegistryServiceImpl.getSchematicsCollection(new File(version.getPackageJson().getPath()));
                        return Pair.create((Object)(schematicsCollection != null && AngularCliSchematicsRegistryServiceImpl.hasNgAddSchematic(schematicsCollection) ? 1 : 0), (Object)version.getPackageJson().getModificationStamp());
                    }
                    catch (IOException e) {
                        return Pair.create((Object)false, (Object)version.getPackageJson().getModificationStamp());
                    }
                }).getFirst();
            }
        }
        catch (Exception e) {
            LOG.info("Failed to retrieve schematics info for " + version.getPackageDir().getName(), (Throwable)e);
        }
        return false;
    }

    @NotNull
    public List<Schematic> getSchematics(@NotNull Project project, @NotNull VirtualFile cliFolder, boolean includeHidden, boolean logErrors) {
        if (project == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(5);
        }
        if (cliFolder == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(6);
        }
        List list = Optional.ofNullable(AngularCliUtil.findCliJson(cliFolder)).map(angularJson -> (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)project).findFile(angularJson))).map(angularJson -> AngularCliSchematicsRegistryServiceImpl.getCachedSchematics((UserDataHolder)angularJson, includeHidden ? SCHEMATICS_ALL : SCHEMATICS_PUBLIC).getUpToDateOrCompute(() -> CachedValueProvider.Result.create(SchematicsLoaderKt.doLoad(angularJson.getProject(), angularJson.getVirtualFile().getParent(), includeHidden, logErrors), (Object[])new Object[]{NodeModulesDirectoryManager.getInstance((Project)angularJson.getProject()).getNodeModulesDirChangeTracker(), SCHEMATICS_CACHE_TRACKER, angularJson}))).orElseGet(Collections::emptyList);
        if (list == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    public void clearProjectSchematicsCache() {
        SCHEMATICS_CACHE_TRACKER.incModificationCount();
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static List<NodePackageBasicInfo> fetchPackagesSupportingNgAdd() {
        try {
            RequestBuilder builder = HttpRequests.request((String)NG_PACKAGES_URL);
            builder.userAgent(USER_AGENT);
            builder.gzip(true);
            return AngularCliSchematicsRegistryServiceImpl.readNgAddPackages(builder.readString(null));
        }
        catch (IOException e) {
            List<NodePackageBasicInfo> list;
            Throwable throwable;
            InputStream is;
            block18: {
                block19: {
                    LOG.info("Failed to load current list of ng-add compatible packages.", (Throwable)e);
                    is = AngularCliSchematicsRegistryServiceImpl.class.getResourceAsStream(NG_PACKAGES_JSON_PATH);
                    throwable = null;
                    list = AngularCliSchematicsRegistryServiceImpl.readNgAddPackages(FileUtil.loadTextAndClose((Reader)new InputStreamReader(is, StandardCharsets.UTF_8)));
                    if (is == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                is.close();
            }
            List<NodePackageBasicInfo> list2 = list;
            if (list2 == null) {
                AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(8);
            }
            return list2;
            {
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (is != null) {
                                if (throwable != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    is.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (Exception e1) {
                        LOG.error("Failed to load list of ng-add compatible packages from static file.", (Throwable)e1);
                        List<NodePackageBasicInfo> list3 = Collections.emptyList();
                        if (list3 == null) {
                            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(9);
                        }
                        return list3;
                    }
                }
            }
        }
    }

    @NotNull
    private static List<NodePackageBasicInfo> readNgAddPackages(@NotNull String content) {
        if (content == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(10);
        }
        JsonObject contents = (JsonObject)new JsonParser().parse(content);
        List<NodePackageBasicInfo> list = Collections.unmodifiableList(ContainerUtil.map((Collection)contents.get(NG_ADD_SCHEMATIC).getAsJsonObject().entrySet(), e -> new NodePackageBasicInfo((String)e.getKey(), ((JsonElement)e.getValue()).getAsString())));
        if (list == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Nullable
    private static File getSchematicsCollection(@NotNull File packageJson) throws IOException {
        if (packageJson == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(12);
        }
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)new FileInputStream(packageJson), StandardCharsets.UTF_8));){
            reader.beginObject();
            while (reader.hasNext()) {
                String key = reader.nextName();
                if (key.equals(SCHEMATICS_PROP)) {
                    String path = reader.nextString();
                    File file = Paths.get(packageJson.getParent(), path).normalize().toAbsolutePath().toFile();
                    return file;
                }
                reader.skipValue();
            }
            File file = null;
            return file;
        }
    }

    private static boolean hasNgAddSchematic(@NotNull File schematicsCollection) throws IOException {
        if (schematicsCollection == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(13);
        }
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)new FileInputStream(schematicsCollection), StandardCharsets.UTF_8));){
            boolean bl = AngularCliSchematicsRegistryServiceImpl.hasNgAddSchematic(reader);
            return bl;
        }
    }

    public static boolean hasNgAddSchematic(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(14);
        }
        reader.setLenient(true);
        reader.beginObject();
        while (reader.hasNext()) {
            String key = reader.nextName();
            if (SCHEMATICS_PROP.equals(key)) {
                reader.beginObject();
                while (reader.hasNext()) {
                    String schematicName = reader.nextName();
                    if (schematicName.equals(NG_ADD_SCHEMATIC)) {
                        return true;
                    }
                    reader.skipValue();
                }
                reader.endObject();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return false;
    }

    private static boolean checkForNgAddSupport(@NotNull String packageName, @NotNull String versionOrRange) {
        if (packageName == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(15);
        }
        if (versionOrRange == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(16);
        }
        try {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            JsonObject pkgJson = NpmRegistryService.getInstance().fetchPackageJson(packageName, versionOrRange, indicator);
            return pkgJson != null && pkgJson.get(SCHEMATICS_PROP) != null;
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            return false;
        }
    }

    private static String getKey(@NotNull String packageName, @NotNull String version) {
        if (packageName == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(17);
        }
        if (version == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(18);
        }
        return packageName + "@" + version;
    }

    @NotNull
    private static CachedSchematics getCachedSchematics(@NotNull UserDataHolder dataHolder, @NotNull Key<CachedSchematics> key) {
        CachedSchematics result;
        if (dataHolder == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(19);
        }
        if (key == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(20);
        }
        if ((result = (CachedSchematics)dataHolder.getUserData(key)) != null) {
            CachedSchematics cachedSchematics = result;
            if (cachedSchematics == null) {
                AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(21);
            }
            return cachedSchematics;
        }
        if (dataHolder instanceof UserDataHolderEx) {
            CachedSchematics cachedSchematics = (CachedSchematics)((UserDataHolderEx)dataHolder).putUserDataIfAbsent(key, (Object)new CachedSchematics());
            if (cachedSchematics == null) {
                AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(22);
            }
            return cachedSchematics;
        }
        result = new CachedSchematics();
        dataHolder.putUserData(key, (Object)result);
        CachedSchematics cachedSchematics = result;
        if (cachedSchematics == null) {
            AngularCliSchematicsRegistryServiceImpl.$$$reportNull$$$0(23);
        }
        return cachedSchematics;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/cli/AngularCliSchematicsRegistryServiceImpl";
                break;
            }
            case 1: 
            case 2: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 3: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionOrRange";
                break;
            }
            case 4: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cliFolder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schematicsCollection";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagesSupportingNgAdd";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/cli/AngularCliSchematicsRegistryServiceImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchematics";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchPackagesSupportingNgAdd";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "readNgAddPackages";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedSchematics";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "supportsNgAdd";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSchematics";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readNgAddPackages";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSchematicsCollection";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasNgAddSchematic";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkForNgAddSupport";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getKey";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCachedSchematics";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CachedValue<T> {
        private long myUpdateTime;
        private Future<T> myCacheComputation;
        private T myCachedValue;
        private final Callable<T> myValueSupplier;

        CachedValue(Callable<T> valueSupplier) {
            this.myValueSupplier = valueSupplier;
        }

        protected synchronized boolean isCacheExpired() {
            return this.myUpdateTime + 1500000L <= System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public T getValue(long timeout) {
            Future<T> cacheComputation;
            CachedValue cachedValue = this;
            synchronized (cachedValue) {
                if (this.myCachedValue != null && !this.isCacheExpired()) {
                    return this.myCachedValue;
                }
                if (this.myCacheComputation == null) {
                    this.myCachedValue = null;
                    this.myCacheComputation = ourExecutorService.submit(this.myValueSupplier);
                }
                cacheComputation = this.myCacheComputation;
            }
            Object result = JSLanguageServiceUtil.awaitFuture(cacheComputation, (long)timeout, (long)10L, null, (boolean)false, null);
            CachedValue cachedValue2 = this;
            synchronized (cachedValue2) {
                if (this.myCacheComputation != null && this.myCacheComputation.isDone()) {
                    try {
                        this.myCachedValue = this.myCacheComputation.get();
                        result = this.myCachedValue;
                    }
                    catch (InterruptedException | CancellationException exception) {
                    }
                    catch (ExecutionException e) {
                        LOG.error((Throwable)e);
                    }
                    this.myCacheComputation = null;
                    this.myUpdateTime = System.currentTimeMillis();
                }
            }
            return (T)result;
        }
    }

    private static class CachedSchematics {
        private List<Schematic> mySchematics;
        private List<Pair<Object, Long>> myTrackers;

        private CachedSchematics() {
        }

        public synchronized List<Schematic> getUpToDateOrCompute(Supplier<CachedValueProvider.Result<List<Schematic>>> provider) {
            if (this.mySchematics != null && this.myTrackers != null && ContainerUtil.all(this.myTrackers, pair -> (Long)pair.second >= 0L && CachedSchematics.getTimestamp(pair.first) == (Long)pair.second)) {
                return this.mySchematics;
            }
            CachedValueProvider.Result<List<Schematic>> schematics = provider.get();
            this.mySchematics = Collections.unmodifiableList((List)schematics.getValue());
            this.myTrackers = ContainerUtil.map((Object[])schematics.getDependencyItems(), obj -> Pair.pair((Object)obj, (Object)CachedSchematics.getTimestamp(obj)));
            return this.mySchematics;
        }

        private static long getTimestamp(Object dependency) {
            if (dependency instanceof ModificationTracker) {
                return ((ModificationTracker)dependency).getModificationCount();
            }
            if (dependency instanceof PsiElement) {
                PsiElement element = (PsiElement)dependency;
                if (!element.isValid()) {
                    return -1L;
                }
                PsiFile containingFile = element.getContainingFile();
                if (containingFile != null) {
                    return containingFile.getVirtualFile().getModificationStamp();
                }
                return -1L;
            }
            throw new UnsupportedOperationException(dependency.getClass().toString());
        }
    }
}

