/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.javascript.nodejs.packageJson.NodeInstalledPackageFinder;
import com.intellij.javascript.nodejs.packageJson.codeInsight.PackageJsonMismatchedDependencyInspection;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.angular2.cli.AngularCliSchematicsRegistryService;
import org.angular2.cli.AngularCliUtil;
import org.angular2.inspections.quickfixes.AngularCliAddQuickFix;
import org.angular2.lang.Angular2Bundle;
import org.jetbrains.annotations.NotNull;

public class AngularCliAddDependencyInspection
extends LocalInspectionTool {
    private static final long TIMEOUT = 2000L;

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AngularCliAddDependencyInspection.$$$reportNull$$$0(0);
        }
        return new JsonElementVisitor(){

            public void visitFile(@NotNull PsiFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PackageJsonUtil.isPackageJsonFile((PsiFile)file) && AngularCliUtil.findCliJson(file.getVirtualFile().getParent()) != null) {
                    AngularCliAddDependencyInspection.annotate((JsonFile)file, holder);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/angular2/inspections/AngularCliAddDependencyInspection$1", "visitFile"));
            }
        };
    }

    private static void annotate(@NotNull JsonFile file, @NotNull ProblemsHolder holder) {
        if (file == null) {
            AngularCliAddDependencyInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            AngularCliAddDependencyInspection.$$$reportNull$$$0(2);
        }
        VirtualFile packageJson = file.getVirtualFile();
        Project project = file.getProject();
        if (packageJson == null || !JSLibraryUtil.isUnderContentRootsAndOutsideOfLibraryRoots((Project)project, (VirtualFile)packageJson)) {
            return;
        }
        List properties = PackageJsonMismatchedDependencyInspection.getDependencies((JsonFile)file);
        if (properties.isEmpty()) {
            return;
        }
        NodeInstalledPackageFinder finder = new NodeInstalledPackageFinder(project, packageJson);
        for (JsonProperty property : properties) {
            JsonStringLiteral nameLiteral = (JsonStringLiteral)ObjectUtils.tryCast((Object)property.getNameElement(), JsonStringLiteral.class);
            JsonStringLiteral versionLiteral = (JsonStringLiteral)ObjectUtils.tryCast((Object)property.getValue(), JsonStringLiteral.class);
            if (nameLiteral == null) continue;
            String packageName = property.getName();
            String version = versionLiteral == null ? "" : versionLiteral.getValue();
            InstalledPackageVersion pkgVersion = finder.findInstalledPackage(packageName);
            if ((pkgVersion == null || !AngularCliSchematicsRegistryService.getInstance().supportsNgAdd(pkgVersion)) && (pkgVersion != null || !AngularCliSchematicsRegistryService.getInstance().supportsNgAdd(packageName, 2000L))) continue;
            String message = Angular2Bundle.message("angular.inspection.json.install-with-ng-add", StringUtil.wrapWithDoubleQuote((String)packageName));
            AngularCliAddQuickFix quickFix = new AngularCliAddQuickFix(packageJson, packageName, version, pkgVersion != null);
            if (versionLiteral != null) {
                if (pkgVersion == null) {
                    holder.registerProblem((PsiElement)versionLiteral, AngularCliAddDependencyInspection.getTextRange((JsonValue)versionLiteral), message, new LocalQuickFix[]{quickFix});
                } else if (holder.isOnTheFly()) {
                    holder.registerProblem((PsiElement)versionLiteral, message, ProblemHighlightType.INFORMATION, new LocalQuickFix[]{quickFix});
                }
            }
            if (!holder.isOnTheFly()) continue;
            holder.registerProblem((PsiElement)nameLiteral, message, ProblemHighlightType.INFORMATION, new LocalQuickFix[]{quickFix});
        }
    }

    @NotNull
    private static TextRange getTextRange(@NotNull JsonValue element) {
        if (element == null) {
            AngularCliAddDependencyInspection.$$$reportNull$$$0(3);
        }
        TextRange range = element.getTextRange();
        if (element instanceof JsonStringLiteral && range.getLength() > 2 && StringUtil.isQuotedString((String)element.getText())) {
            return new TextRange(1, range.getLength() - 1);
        }
        TextRange textRange = TextRange.create((int)0, (int)range.getLength());
        if (textRange == null) {
            AngularCliAddDependencyInspection.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/inspections/AngularCliAddDependencyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/inspections/AngularCliAddDependencyInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTextRange";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

