/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.inspections.quickfixes;

import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.ecmascript6.ES6QualifiedNamedElementRenderer;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import org.angular2.codeInsight.Angular2DeclarationsScope;
import org.angular2.codeInsight.attributes.Angular2ApplicableDirectivesProvider;
import org.angular2.codeInsight.attributes.Angular2AttributeDescriptor;
import org.angular2.entities.Angular2Component;
import org.angular2.entities.Angular2Declaration;
import org.angular2.entities.Angular2Directive;
import org.angular2.entities.Angular2DirectiveProperty;
import org.angular2.entities.Angular2EntitiesProvider;
import org.angular2.entities.Angular2Entity;
import org.angular2.entities.Angular2Pipe;
import org.angular2.inspections.actions.Angular2ActionFactory;
import org.angular2.inspections.quickfixes.AddNgModuleDeclarationQuickFix;
import org.angular2.inspections.quickfixes.AddNgModuleImportQuickFix;
import org.angular2.inspections.quickfixes.ExportNgModuleDeclarationQuickFix;
import org.angular2.lang.Angular2Bundle;
import org.angular2.lang.expr.psi.Angular2PipeReferenceExpression;
import org.angular2.lang.expr.psi.Angular2TemplateBinding;
import org.angular2.lang.expr.psi.Angular2TemplateBindings;
import org.angular2.lang.html.parser.Angular2AttributeNameParser;
import org.angular2.lang.html.parser.Angular2AttributeType;
import org.angular2.lang.html.psi.Angular2HtmlEvent;
import org.angular2.lang.html.psi.PropertyBindingType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class Angular2FixesFactory {
    @NonNls
    public static final Key<String> DECLARATION_TO_CHOOSE = Key.create((String)"declaration.to.choose");

    public static void ensureDeclarationResolvedAfterCodeCompletion(@NotNull PsiElement element, @NotNull Editor editor) {
        MultiMap<Angular2DeclarationsScope.DeclarationProximity, Angular2Declaration> candidates;
        if (element == null) {
            Angular2FixesFactory.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            Angular2FixesFactory.$$$reportNull$$$0(1);
        }
        if (!(candidates = Angular2FixesFactory.getCandidatesForResolution(element, true)).get((Object)Angular2DeclarationsScope.DeclarationProximity.EXPORTED_BY_PUBLIC_MODULE).isEmpty()) {
            Angular2ActionFactory.createNgModuleImportAction(editor, element, true).execute();
        } else if (!candidates.get((Object)Angular2DeclarationsScope.DeclarationProximity.NOT_DECLARED_IN_ANY_MODULE).isEmpty()) {
            Angular2FixesFactory.selectAndRun(editor, Angular2Bundle.message("angular.quickfix.ngmodule.declare.select.declarable", Angular2FixesFactory.getCommonNameForDeclarations(candidates.get((Object)Angular2DeclarationsScope.DeclarationProximity.NOT_EXPORTED_BY_MODULE))), candidates.get((Object)Angular2DeclarationsScope.DeclarationProximity.NOT_DECLARED_IN_ANY_MODULE), candidate -> Angular2ActionFactory.createAddNgModuleDeclarationAction(editor, element, candidate, true));
        } else if (!candidates.get((Object)Angular2DeclarationsScope.DeclarationProximity.NOT_EXPORTED_BY_MODULE).isEmpty()) {
            Angular2FixesFactory.selectAndRun(editor, Angular2Bundle.message("angular.quickfix.ngmodule.export.select.declarable", Angular2FixesFactory.getCommonNameForDeclarations(candidates.get((Object)Angular2DeclarationsScope.DeclarationProximity.NOT_EXPORTED_BY_MODULE))), candidates.get((Object)Angular2DeclarationsScope.DeclarationProximity.NOT_EXPORTED_BY_MODULE), candidate -> Angular2ActionFactory.createExportNgModuleDeclarationAction(editor, element, candidate, true));
        }
    }

    public static void addUnresolvedDeclarationFixes(@NotNull PsiElement element, @NotNull List<LocalQuickFix> fixes) {
        MultiMap<Angular2DeclarationsScope.DeclarationProximity, Angular2Declaration> candidates;
        if (element == null) {
            Angular2FixesFactory.$$$reportNull$$$0(2);
        }
        if (fixes == null) {
            Angular2FixesFactory.$$$reportNull$$$0(3);
        }
        if ((candidates = Angular2FixesFactory.getCandidatesForResolution(element, false)).containsKey((Object)Angular2DeclarationsScope.DeclarationProximity.IN_SCOPE)) {
            return;
        }
        if (!candidates.get((Object)Angular2DeclarationsScope.DeclarationProximity.EXPORTED_BY_PUBLIC_MODULE).isEmpty()) {
            fixes.add((LocalQuickFix)new AddNgModuleImportQuickFix(element, candidates.get((Object)Angular2DeclarationsScope.DeclarationProximity.EXPORTED_BY_PUBLIC_MODULE)));
        }
        for (Angular2Declaration declaration : candidates.get((Object)Angular2DeclarationsScope.DeclarationProximity.NOT_DECLARED_IN_ANY_MODULE)) {
            AddNgModuleDeclarationQuickFix.add(element, declaration, fixes);
        }
        for (Angular2Declaration declaration : candidates.get((Object)Angular2DeclarationsScope.DeclarationProximity.NOT_EXPORTED_BY_MODULE)) {
            ExportNgModuleDeclarationQuickFix.add(element, declaration, fixes);
        }
    }

    @NotNull
    public static MultiMap<Angular2DeclarationsScope.DeclarationProximity, Angular2Declaration> getCandidatesForResolution(@NotNull PsiElement element, boolean codeCompletion) {
        Supplier<List<? extends Angular2Declaration>> secondaryProvider;
        Supplier<List> provider;
        Angular2DeclarationsScope scope;
        if (element == null) {
            Angular2FixesFactory.$$$reportNull$$$0(4);
        }
        if ((scope = new Angular2DeclarationsScope(element)).getModule() == null || !scope.isInSource(scope.getModule())) {
            MultiMap multiMap = MultiMap.empty();
            if (multiMap == null) {
                Angular2FixesFactory.$$$reportNull$$$0(5);
            }
            return multiMap;
        }
        Ref filter = new Ref(declaration -> true);
        if (element instanceof XmlAttribute) {
            Angular2AttributeDescriptor attributeDescriptor = (Angular2AttributeDescriptor)((Object)ObjectUtils.tryCast((Object)((XmlAttribute)element).getDescriptor(), Angular2AttributeDescriptor.class));
            if (attributeDescriptor == null) {
                MultiMap multiMap = MultiMap.empty();
                if (multiMap == null) {
                    Angular2FixesFactory.$$$reportNull$$$0(6);
                }
                return multiMap;
            }
            Angular2AttributeNameParser.AttributeInfo info = attributeDescriptor.getInfo();
            provider = new Angular2ApplicableDirectivesProvider(((XmlAttribute)element).getParent())::getMatched;
            secondaryProvider = info.type == Angular2AttributeType.REFERENCE ? null : attributeDescriptor::getSourceDirectives;
            switch (info.type) {
                case PROPERTY_BINDING: {
                    if (((Angular2AttributeNameParser.PropertyBindingInfo)info).bindingType != PropertyBindingType.PROPERTY) {
                        MultiMap multiMap = MultiMap.empty();
                        if (multiMap == null) {
                            Angular2FixesFactory.$$$reportNull$$$0(7);
                        }
                        return multiMap;
                    }
                    filter.set(declaration -> declaration instanceof Angular2Directive && ContainerUtil.exists(((Angular2Directive)declaration).getInputs(), input -> info.name.equals(input.getName())));
                    break;
                }
                case EVENT: {
                    if (((Angular2AttributeNameParser.EventInfo)info).eventType != Angular2HtmlEvent.EventType.REGULAR) {
                        MultiMap multiMap = MultiMap.empty();
                        if (multiMap == null) {
                            Angular2FixesFactory.$$$reportNull$$$0(8);
                        }
                        return multiMap;
                    }
                    filter.set(declaration -> declaration instanceof Angular2Directive && ContainerUtil.exists(((Angular2Directive)declaration).getOutputs(), output -> info.name.equals(output.getName())));
                }
                case BANANA_BOX_BINDING: {
                    filter.set(declaration -> declaration instanceof Angular2Directive && ContainerUtil.exists(((Angular2Directive)declaration).getInOuts(), inout -> info.name.equals(((Angular2DirectiveProperty)inout.first).getName())));
                    break;
                }
                case REGULAR: {
                    filter.set(declaration -> declaration instanceof Angular2Directive && (ContainerUtil.exists(((Angular2Directive)declaration).getInputs(), input -> info.name.equals(input.getName()) && Angular2AttributeDescriptor.isOneTimeBindingProperty(input)) || ContainerUtil.exists(((Angular2Directive)declaration).getSelector().getSimpleSelectors(), selector -> ContainerUtil.exists(selector.getAttrNames(), info.name::equals))));
                    break;
                }
                case REFERENCE: {
                    String exportName = ((XmlAttribute)element).getValue();
                    if (exportName == null || exportName.isEmpty()) {
                        MultiMap multiMap = MultiMap.empty();
                        if (multiMap == null) {
                            Angular2FixesFactory.$$$reportNull$$$0(9);
                        }
                        return multiMap;
                    }
                    filter.set(declaration -> declaration instanceof Angular2Directive && ((Angular2Directive)declaration).getExportAsList().contains(exportName));
                    break;
                }
                default: {
                    MultiMap multiMap = MultiMap.empty();
                    if (multiMap == null) {
                        Angular2FixesFactory.$$$reportNull$$$0(10);
                    }
                    return multiMap;
                }
            }
        } else if (element instanceof XmlTag) {
            provider = new Angular2ApplicableDirectivesProvider((XmlTag)element, true)::getMatched;
            secondaryProvider = null;
        } else if (element instanceof Angular2TemplateBinding) {
            provider = new Angular2ApplicableDirectivesProvider((Angular2TemplateBindings)element.getParent())::getMatched;
            secondaryProvider = Angular2FixesFactory.createSecondaryProvider((Angular2TemplateBindings)element.getParent());
            if (((Angular2TemplateBinding)element).keyIsVar()) {
                MultiMap multiMap = MultiMap.empty();
                if (multiMap == null) {
                    Angular2FixesFactory.$$$reportNull$$$0(11);
                }
                return multiMap;
            }
            String key = ((Angular2TemplateBinding)element).getKey();
            filter.set(declaration -> declaration instanceof Angular2Directive && ContainerUtil.exists(((Angular2Directive)declaration).getInputs(), input -> key.equals(input.getName())));
        } else if (element instanceof Angular2TemplateBindings) {
            provider = new Angular2ApplicableDirectivesProvider((Angular2TemplateBindings)element)::getMatched;
            secondaryProvider = Angular2FixesFactory.createSecondaryProvider((Angular2TemplateBindings)element);
        } else if (element instanceof Angular2PipeReferenceExpression) {
            String referencedName = ((Angular2PipeReferenceExpression)element).getReferenceName();
            if (referencedName == null || referencedName.isEmpty()) {
                MultiMap multiMap = MultiMap.empty();
                if (multiMap == null) {
                    Angular2FixesFactory.$$$reportNull$$$0(12);
                }
                return multiMap;
            }
            provider = () -> Angular2EntitiesProvider.findPipes(element.getProject(), referencedName);
            secondaryProvider = null;
        } else {
            throw new IllegalArgumentException(element.getClass().getName());
        }
        MultiMap result = new MultiMap();
        Consumer declarationProcessor = p -> ((StreamEx)StreamEx.of((Collection)((Collection)p.get())).filter((Predicate)filter.get())).forEach(declaration -> result.putValue((Object)scope.getDeclarationProximity((Angular2Declaration)declaration), declaration));
        declarationProcessor.consume(provider);
        if (result.isEmpty() && codeCompletion && secondaryProvider != null) {
            declarationProcessor.consume(secondaryProvider);
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            Angular2FixesFactory.$$$reportNull$$$0(13);
        }
        return multiMap;
    }

    @NotNull
    private static Supplier<List<? extends Angular2Declaration>> createSecondaryProvider(@NotNull Angular2TemplateBindings bindings) {
        if (bindings == null) {
            Angular2FixesFactory.$$$reportNull$$$0(14);
        }
        Supplier<List<? extends Angular2Declaration>> supplier = () -> Optional.of(ObjectUtils.notNull((Object)InjectedLanguageManager.getInstance((Project)bindings.getProject()).getInjectionHost((PsiElement)bindings), (Object)bindings)).map(element -> (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class)).map(XmlAttribute::getDescriptor).map(d -> (Angular2AttributeDescriptor)((Object)((Object)((Object)ObjectUtils.tryCast((Object)d, Angular2AttributeDescriptor.class))))).map(Angular2AttributeDescriptor::getSourceDirectives).orElse(Collections.emptyList());
        if (supplier == null) {
            Angular2FixesFactory.$$$reportNull$$$0(15);
        }
        return supplier;
    }

    private static String getCommonNameForDeclarations(@NotNull Collection<Angular2Declaration> declarations) {
        if (declarations == null) {
            Angular2FixesFactory.$$$reportNull$$$0(16);
        }
        if (ContainerUtil.getFirstItem(declarations) instanceof Angular2Pipe) {
            return Angular2Bundle.message("angular.entity.pipe", new Object[0]);
        }
        boolean hasDirective = false;
        boolean hasComponent = false;
        for (Angular2Declaration declaration : declarations) {
            if (declaration instanceof Angular2Component) {
                hasComponent = true;
                continue;
            }
            hasDirective = true;
        }
        return hasComponent == hasDirective ? Angular2Bundle.message("angular.entity.component.or.directive", new Object[0]) : (hasComponent ? Angular2Bundle.message("angular.entity.component", new Object[0]) : Angular2Bundle.message("angular.entity.directive", new Object[0]));
    }

    private static void selectAndRun(@NotNull Editor editor, @NotNull String title, @NotNull Collection<Angular2Declaration> declarations, final @NotNull Function<Angular2Declaration, QuestionAction> actionFactory) {
        if (editor == null) {
            Angular2FixesFactory.$$$reportNull$$$0(17);
        }
        if (title == null) {
            Angular2FixesFactory.$$$reportNull$$$0(18);
        }
        if (declarations == null) {
            Angular2FixesFactory.$$$reportNull$$$0(19);
        }
        if (actionFactory == null) {
            Angular2FixesFactory.$$$reportNull$$$0(20);
        }
        if (declarations.isEmpty()) {
            return;
        }
        if (declarations.size() == 1) {
            ObjectUtils.doIfNotNull((Object)actionFactory.apply((Angular2Declaration)ContainerUtil.getFirstItem(declarations)), QuestionAction::execute);
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final Map elementMap = StreamEx.of(declarations).mapToEntry(Angular2Entity::getTypeScriptClass, Function.identity()).selectKeys(JSElement.class).toMap();
        PsiElementProcessor<JSElement> processor = new PsiElementProcessor<JSElement>(){

            public boolean execute(@NotNull JSElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                Optional.ofNullable(elementMap.get(element)).map(actionFactory).ifPresent(QuestionAction::execute);
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/angular2/inspections/quickfixes/Angular2FixesFactory$1", "execute"));
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            processor.execute((PsiElement)Optional.ofNullable(editor.getUserData(DECLARATION_TO_CHOOSE)).map(name -> (Angular2Declaration)ContainerUtil.find((Iterable)declarations, declaration -> declaration.getName().equals(name))).map(Angular2Entity::getTypeScriptClass).orElseThrow(() -> new AssertionError((Object)("Declaration name must be specified in test mode. Available names: " + ((StreamEx)StreamEx.of((Collection)declarations).filter(decl -> decl.getTypeScriptClass() != null)).map(Angular2Entity::getName).joining((CharSequence)",")))));
            return;
        }
        if (editor.isDisposed()) {
            return;
        }
        NavigationUtil.getPsiElementPopup((PsiElement[])((PsiElement[])elementMap.keySet().toArray(JSElement.EMPTY_ARRAY)), (PsiElementListCellRenderer)new ES6QualifiedNamedElementRenderer(), (String)title, (PsiElementProcessor)processor).showInBestPositionFor(editor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/inspections/quickfixes/Angular2FixesFactory";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindings";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/inspections/quickfixes/Angular2FixesFactory";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidatesForResolution";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createSecondaryProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ensureDeclarationResolvedAfterCodeCompletion";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addUnresolvedDeclarationFixes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCandidatesForResolution";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createSecondaryProvider";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCommonNameForDeclarations";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "selectAndRun";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

