/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight;

import com.intellij.lang.Language;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.HtmlXmlExtension;
import org.angular2.lang.Angular2LangUtil;
import org.angular2.lang.html.Angular2HtmlFileType;
import org.angular2.lang.html.psi.Angular2HtmlBananaBoxBinding;
import org.angular2.lang.html.psi.Angular2HtmlElementVisitor;
import org.angular2.lang.html.psi.Angular2HtmlPropertyBinding;
import org.angular2.lang.html.psi.PropertyBindingType;
import org.angular2.lang.svg.Angular2SvgLanguage;
import org.angularjs.codeInsight.DirectiveUtil;
import org.angularjs.codeInsight.tags.AngularJSTagDescriptor;
import org.angularjs.index.AngularIndexUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularJSHtmlExtension
extends HtmlXmlExtension {
    public boolean isAvailable(PsiFile file) {
        return super.isAvailable(file) && AngularIndexUtil.hasAngularJS(file.getProject()) || file.getFileType() instanceof Angular2HtmlFileType && Angular2LangUtil.isAngular2Context((PsiElement)file);
    }

    public boolean isSelfClosingTagAllowed(@NotNull XmlTag tag) {
        if (tag == null) {
            AngularJSHtmlExtension.$$$reportNull$$$0(0);
        }
        return tag.getDescriptor() instanceof AngularJSTagDescriptor || tag.getLanguage().is((Language)Angular2SvgLanguage.INSTANCE) || super.isSelfClosingTagAllowed(tag);
    }

    public boolean isRequiredAttributeImplicitlyPresent(XmlTag tag, final String attrName) {
        String ngAttr = DirectiveUtil.normalizeAttributeName("ng-" + attrName);
        for (XmlAttribute attribute : tag.getAttributes()) {
            if (!ngAttr.equals(DirectiveUtil.normalizeAttributeName(attribute.getName()))) continue;
            return true;
        }
        final Ref result = new Ref();
        tag.acceptChildren((PsiElementVisitor)new Angular2HtmlElementVisitor(){

            @Override
            public void visitPropertyBinding(Angular2HtmlPropertyBinding propertyBinding) {
                this.checkBinding(propertyBinding.getBindingType(), propertyBinding.getPropertyName());
            }

            @Override
            public void visitBananaBoxBinding(Angular2HtmlBananaBoxBinding bananaBoxBinding) {
                this.checkBinding(bananaBoxBinding.getBindingType(), bananaBoxBinding.getPropertyName());
            }

            private void checkBinding(PropertyBindingType type, String name) {
                switch (type) {
                    case PROPERTY: 
                    case ATTRIBUTE: {
                        if (!attrName.equals(name)) break;
                        result.set((Object)Boolean.TRUE);
                    }
                }
            }
        });
        if (!result.isNull()) {
            return (Boolean)result.get();
        }
        return super.isRequiredAttributeImplicitlyPresent(tag, attrName);
    }

    public SchemaPrefix getPrefixDeclaration(XmlTag context, String namespacePrefix) {
        SchemaPrefix attribute;
        if ("ng".equals(namespacePrefix) && (attribute = AngularJSHtmlExtension.findAttributeSchema(context, namespacePrefix, 0)) != null) {
            return attribute;
        }
        if (namespacePrefix != null && (namespacePrefix.startsWith("(") || namespacePrefix.startsWith("[")) && (attribute = AngularJSHtmlExtension.findAttributeSchema(context, namespacePrefix, 1)) != null) {
            return attribute;
        }
        return super.getPrefixDeclaration(context, namespacePrefix);
    }

    @Nullable
    private static SchemaPrefix findAttributeSchema(XmlTag context, String namespacePrefix, int offset) {
        for (XmlAttribute attribute : context.getAttributes()) {
            if (!attribute.getName().startsWith(namespacePrefix)) continue;
            return new SchemaPrefix(attribute, TextRange.create((int)offset, (int)namespacePrefix.length()), namespacePrefix.substring(offset));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "org/angularjs/codeInsight/AngularJSHtmlExtension", "isSelfClosingTagAllowed"));
    }
}

