/*
 * Decompiled with CFR 0.152.
 */
package org.angularjs.codeInsight;

import com.intellij.json.psi.JsonElement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import org.angular2.index.Angular2IndexingHandler;
import org.angularjs.index.AngularDirectivesDocIndex;
import org.angularjs.index.AngularDirectivesIndex;
import org.angularjs.index.AngularIndexUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectiveUtil {
    @NotNull
    public static String getPropertyAlias(@NotNull String propertyName, @Nullable JSExpression attributeTypeExpr) {
        String typeStr;
        if (propertyName == null) {
            DirectiveUtil.$$$reportNull$$$0(0);
        }
        if (attributeTypeExpr instanceof JSLiteralExpression && (typeStr = ((JSLiteralExpression)attributeTypeExpr).getStringValue()) != null) {
            String attrName;
            int start;
            for (start = 0; start < typeStr.length() && "@=*<&?".indexOf(typeStr.charAt(start)) >= 0; ++start) {
            }
            if (start < typeStr.length() && !(attrName = typeStr.substring(start)).isEmpty()) {
                String string = attrName;
                if (string == null) {
                    DirectiveUtil.$$$reportNull$$$0(1);
                }
                return string;
            }
        }
        String string = propertyName;
        if (string == null) {
            DirectiveUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getAttributeName(@NotNull String text) {
        if (text == null) {
            DirectiveUtil.$$$reportNull$$$0(3);
        }
        return DirectiveUtil.getAttributeName(text, false);
    }

    @NotNull
    public static Collection<String> getAttributeNameVariations(@NotNull String text) {
        if (text == null) {
            DirectiveUtil.$$$reportNull$$$0(4);
        }
        HashSet hashSet = ContainerUtil.newHashSet((Object[])new String[]{DirectiveUtil.getAttributeName(text, false), DirectiveUtil.getAttributeName(text, true)});
        if (hashSet == null) {
            DirectiveUtil.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @NotNull
    private static String getAttributeName(@NotNull String text, boolean splitDigits) {
        if (text == null) {
            DirectiveUtil.$$$reportNull$$$0(6);
        }
        StringBuilder result = new StringBuilder();
        boolean wasDigit = false;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (Character.isDigit(ch)) {
                if (splitDigits && !wasDigit) {
                    result.append('-');
                }
                result.append(ch);
                wasDigit = true;
                continue;
            }
            if (Character.isUpperCase(ch)) {
                result.append('-');
            }
            result.append(Character.toLowerCase(ch));
            wasDigit = false;
        }
        String string = result.toString();
        if (string == null) {
            DirectiveUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Contract(value="null -> null")
    public static String normalizeAttributeName(String name) {
        return DirectiveUtil.normalizeAttributeName(name, true);
    }

    @Contract(value="null,_ -> null")
    public static String normalizeAttributeName(String name, boolean stripStartEnd) {
        if (name == null) {
            return null;
        }
        int index = 0;
        if (name.startsWith("data-")) {
            index = 5;
        } else if (name.startsWith("x-")) {
            index = 2;
        }
        StringBuilder result = new StringBuilder();
        boolean upperCase = false;
        while (index < name.length()) {
            char ch = name.charAt(index);
            if (ch == ':' || ch == '_' || ch == '-') {
                upperCase = true;
            } else if (upperCase) {
                result.append(Character.toUpperCase(ch));
                upperCase = false;
            } else {
                result.append(Character.toLowerCase(ch));
            }
            ++index;
        }
        if (stripStartEnd) {
            if (result.indexOf("Start", result.length() - 5) >= 0) {
                result.setLength(result.length() - 5);
            } else if (result.indexOf("End", result.length() - 3) >= 0) {
                result.setLength(result.length() - 3);
            }
        }
        return result.toString();
    }

    public static boolean isAngular2Directive(@Nullable PsiElement directive) {
        return directive instanceof JSImplicitElement && !Angular2IndexingHandler.isPipe((JSImplicitElement)directive) && (directive.getParent() instanceof JSCallExpression || directive.getParent() instanceof ES6Decorator || directive.getParent() instanceof JsonElement);
    }

    public static boolean processTagDirectives(@NotNull Project project, @NotNull Processor<? super JSImplicitElement> processor) {
        if (project == null) {
            DirectiveUtil.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            DirectiveUtil.$$$reportNull$$$0(9);
        }
        Collection<String> docDirectives = AngularIndexUtil.getAllKeys(AngularDirectivesDocIndex.KEY, project);
        for (String directiveName : docDirectives) {
            JSImplicitElement directive = DirectiveUtil.getTagDirective(project, directiveName, AngularDirectivesDocIndex.KEY);
            if (directive == null || processor.process((Object)directive)) continue;
            return false;
        }
        Collection<String> directives = AngularIndexUtil.getAllKeys(AngularDirectivesIndex.KEY, project);
        for (String directiveName : directives) {
            JSImplicitElement directive;
            if (docDirectives.contains(directiveName) || (directive = DirectiveUtil.getTagDirective(project, directiveName, AngularDirectivesIndex.KEY)) == null || processor.process((Object)directive)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static JSImplicitElement getTagDirective(@NotNull String directiveName, @NotNull Project project) {
        if (directiveName == null) {
            DirectiveUtil.$$$reportNull$$$0(10);
        }
        if (project == null) {
            DirectiveUtil.$$$reportNull$$$0(11);
        }
        return DirectiveUtil.getDirective(directiveName, project);
    }

    @Nullable
    private static JSImplicitElement getTagDirective(@NotNull Project project, @NotNull String directiveName, @NotNull StubIndexKey<String, JSImplicitElementProvider> index) {
        if (project == null) {
            DirectiveUtil.$$$reportNull$$$0(12);
        }
        if (directiveName == null) {
            DirectiveUtil.$$$reportNull$$$0(13);
        }
        if (index == null) {
            DirectiveUtil.$$$reportNull$$$0(14);
        }
        return DirectiveUtil.getDirective(directiveName, project, index);
    }

    @Nullable
    private static JSImplicitElement getDirective(@NotNull String name, @NotNull Project project) {
        JSImplicitElement directive;
        if (name == null) {
            DirectiveUtil.$$$reportNull$$$0(15);
        }
        if (project == null) {
            DirectiveUtil.$$$reportNull$$$0(16);
        }
        return (directive = DirectiveUtil.getDirective(name, project, AngularDirectivesDocIndex.KEY)) == null ? DirectiveUtil.getDirective(name, project, AngularDirectivesIndex.KEY) : directive;
    }

    @Nullable
    private static JSImplicitElement getDirective(@NotNull String name, @NotNull Project project, @NotNull StubIndexKey<String, JSImplicitElementProvider> index) {
        String[] split;
        String restrict;
        JSImplicitElement directive;
        String restrictions;
        if (name == null) {
            DirectiveUtil.$$$reportNull$$$0(17);
        }
        if (project == null) {
            DirectiveUtil.$$$reportNull$$$0(18);
        }
        if (index == null) {
            DirectiveUtil.$$$reportNull$$$0(19);
        }
        String string = restrictions = (directive = AngularIndexUtil.resolve(project, index, name)) != null ? directive.getTypeString() : null;
        if (restrictions != null && !StringUtil.isEmpty((String)(restrict = AngularIndexUtil.convertRestrictions(project, (split = restrictions.split(";", -1))[0]))) && StringUtil.containsIgnoreCase((String)restrict, (String)"E")) {
            return directive;
        }
        return null;
    }

    @Nullable
    public static JSImplicitElement getDirective(@Nullable PsiElement element) {
        if (element instanceof JSImplicitElement) {
            return DirectiveUtil.isAngular2Directive(element) ? null : DirectiveUtil.getDirective(element, ((JSImplicitElement)element).getName());
        }
        if (element instanceof JSLiteralExpression && ((JSLiteralExpression)element).isQuotedLiteral()) {
            return DirectiveUtil.getDirective(element, StringUtil.unquoteString((String)element.getText()));
        }
        return null;
    }

    @Nullable
    private static JSImplicitElement getDirective(@NotNull PsiElement element, @NotNull String directiveName) {
        JSImplicitElement directive;
        if (element == null) {
            DirectiveUtil.$$$reportNull$$$0(20);
        }
        if (directiveName == null) {
            DirectiveUtil.$$$reportNull$$$0(21);
        }
        if ((directive = AngularIndexUtil.resolve(element.getProject(), AngularDirectivesIndex.KEY, directiveName)) != null && directive.isEquivalentTo(element)) {
            return directive;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angularjs/codeInsight/DirectiveUtil";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: 
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directiveName";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angularjs/codeInsight/DirectiveUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyAlias";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeNameVariations";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyAlias";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeNameVariations";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processTagDirectives";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTagDirective";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDirective";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

