/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.conditional;

import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.BoolUtils;
import org.jetbrains.annotations.NotNull;

public class JSFlipConditionalIntention
extends JSIntention {
    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        return new FlipConditionalPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSFlipConditionalIntention.$$$reportNull$$$0(0);
        }
        JSConditionalExpression exp = (JSConditionalExpression)element;
        JSExpression condition = exp.getCondition();
        JSExpression elseExpression = exp.getElse();
        JSExpression thenExpression = exp.getThen();
        assert (elseExpression != null);
        assert (thenExpression != null);
        String newExpression = BoolUtils.getNegatedExpressionText(condition) + '?' + elseExpression.getText() + ':' + thenExpression.getText();
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)exp, (String)newExpression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/conditional/JSFlipConditionalIntention", "processIntention"));
    }

    private static class FlipConditionalPredicate
    implements JSElementPredicate {
        private FlipConditionalPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                FlipConditionalPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSConditionalExpression)) {
                return false;
            }
            if (PsiUtilCore.hasErrorElementChild((PsiElement)element)) {
                return false;
            }
            JSConditionalExpression condition = (JSConditionalExpression)element;
            return condition.getCondition() != null && condition.getThen() != null && condition.getElse() != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/conditional/JSFlipConditionalIntention$FlipConditionalPredicate", "satisfiedBy"));
        }
    }
}

