/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.net.Proxy;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystem;
import org.apache.commons.vfs2.provider.ftp.FtpFileType;
import org.apache.commons.vfs2.provider.ftp.JBFtpKeepAliveCommand;

public class FtpFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final String _PREFIX = FtpFileSystemConfigBuilder.class.getName();
    private static final FtpFileSystemConfigBuilder BUILDER = new FtpFileSystemConfigBuilder();
    private static final String CONNECT_TIMEOUT = _PREFIX + ".CONNECT_TIMEOUT";
    private static final String DATA_TIMEOUT = _PREFIX + ".DATA_TIMEOUT";
    private static final String DEFAULT_DATE_FORMAT = _PREFIX + ".DEFAULT_DATE_FORMAT";
    private static final String ENCODING = _PREFIX + ".ENCODING";
    private static final String FACTORY_KEY = FTPFileEntryParserFactory.class.getName() + ".KEY";
    private static final String FILE_TYPE = _PREFIX + ".FILE_TYPE";
    private static final String PASSIVE_MODE = _PREFIX + ".PASSIVE";
    private static final String PROXY = _PREFIX + ".PROXY";
    private static final String RECENT_DATE_FORMAT = _PREFIX + ".RECENT_DATE_FORMAT";
    private static final String REMOTE_VERIFICATION = _PREFIX + ".REMOTE_VERIFICATION";
    private static final String SERVER_LANGUAGE_CODE = _PREFIX + ".SERVER_LANGUAGE_CODE";
    private static final String SERVER_TIME_ZONE_ID = _PREFIX + ".SERVER_TIME_ZONE_ID";
    private static final String SHORT_MONTH_NAMES = _PREFIX + ".SHORT_MONTH_NAMES";
    private static final String SO_TIMEOUT = _PREFIX + ".SO_TIMEOUT";
    private static final String USER_DIR_IS_ROOT = _PREFIX + ".USER_DIR_IS_ROOT";
    private static final String SHOW_HIDDEN_FILES = _PREFIX + ".SHOW_HIDDEN_FILES";
    private static final String HOME_FOLDER_OVERRIDE = _PREFIX + ".HOME_FOLDER_OVERRIDE";
    private static final String COMPATIBLE_MODE = _PREFIX + ".COMPATIBLE_MODE";
    private static final String SOCKET_FACTORY = _PREFIX + ".SOCKET_FACTORY";
    private static final String SERVER_SOCKET_FACTORY = _PREFIX + ".SERVER_SOCKET_FACTORY";
    private static final String FORCE_LIST_COMMAND = _PREFIX + ".FORCE_LIST_COMMAND";
    private static final String KEEP_ALIVE_TIMEOUT = _PREFIX + ".KEEP_ALIVE_TIMEOUT";
    private static final String KEEP_ALIVE_COMMAND = _PREFIX + ".KEEP_ALIVE_COMMAND";
    private static final String PROTOCOL_COMMAND_LISTENER = _PREFIX + ".PROTOCOL_COMMAND_LISTENER";

    private FtpFileSystemConfigBuilder() {
        super("ftp.");
    }

    protected FtpFileSystemConfigBuilder(String prefix) {
        super(prefix);
    }

    public static FtpFileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    @Override
    protected Class<? extends FileSystem> getConfigClass() {
        return FtpFileSystem.class;
    }

    public Integer getConnectTimeout(FileSystemOptions opts) {
        return this.getInteger(opts, CONNECT_TIMEOUT);
    }

    public String getControlEncoding(FileSystemOptions opts) {
        return this.getString(opts, ENCODING);
    }

    public Integer getDataTimeout(FileSystemOptions opts) {
        return this.getInteger(opts, DATA_TIMEOUT);
    }

    public String getDefaultDateFormat(FileSystemOptions opts) {
        return this.getString(opts, DEFAULT_DATE_FORMAT);
    }

    public String getEntryParser(FileSystemOptions opts) {
        return this.getString(opts, FACTORY_KEY);
    }

    public FTPFileEntryParserFactory getEntryParserFactory(FileSystemOptions opts) {
        return (FTPFileEntryParserFactory)this.getParam(opts, FTPFileEntryParserFactory.class.getName());
    }

    public FtpFileType getFileType(FileSystemOptions opts) {
        return this.getEnum(FtpFileType.class, opts, FILE_TYPE);
    }

    public Boolean getPassiveMode(FileSystemOptions opts) {
        return this.getBoolean(opts, PASSIVE_MODE);
    }

    public Proxy getProxy(FileSystemOptions opts) {
        return (Proxy)this.getParam(opts, PROXY);
    }

    public String getRecentDateFormat(FileSystemOptions opts) {
        return this.getString(opts, RECENT_DATE_FORMAT);
    }

    public Boolean getRemoteVerification(FileSystemOptions opts) {
        return this.getBoolean(opts, REMOTE_VERIFICATION);
    }

    public String getServerLanguageCode(FileSystemOptions opts) {
        return this.getString(opts, SERVER_LANGUAGE_CODE);
    }

    public String getServerTimeZoneId(FileSystemOptions opts) {
        return this.getString(opts, SERVER_TIME_ZONE_ID);
    }

    public String[] getShortMonthNames(FileSystemOptions opts) {
        return (String[])this.getParam(opts, SHORT_MONTH_NAMES);
    }

    public Integer getSoTimeout(FileSystemOptions opts) {
        return this.getInteger(opts, SO_TIMEOUT);
    }

    public Boolean getUserDirIsRoot(FileSystemOptions opts) {
        return this.getBoolean(opts, USER_DIR_IS_ROOT, Boolean.TRUE);
    }

    public void setConnectTimeout(FileSystemOptions opts, Integer connectTimeout) {
        this.setParam(opts, CONNECT_TIMEOUT, connectTimeout);
    }

    public void setControlEncoding(FileSystemOptions opts, String encoding) {
        this.setParam(opts, ENCODING, encoding);
    }

    public void setDataTimeout(FileSystemOptions opts, Integer dataTimeout) {
        this.setParam(opts, DATA_TIMEOUT, dataTimeout);
    }

    public void setDefaultDateFormat(FileSystemOptions opts, String defaultDateFormat) {
        this.setParam(opts, DEFAULT_DATE_FORMAT, defaultDateFormat);
    }

    public void setEntryParser(FileSystemOptions opts, String key) {
        this.setParam(opts, FACTORY_KEY, key);
    }

    public void setEntryParserFactory(FileSystemOptions opts, FTPFileEntryParserFactory factory) {
        this.setParam(opts, FTPFileEntryParserFactory.class.getName(), factory);
    }

    public void setFileType(FileSystemOptions opts, FtpFileType ftpFileType) {
        this.setParam(opts, FILE_TYPE, (Object)ftpFileType);
    }

    public void setPassiveMode(FileSystemOptions opts, boolean passiveMode) {
        this.setParam(opts, PASSIVE_MODE, passiveMode ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setProxy(FileSystemOptions opts, Proxy proxy) {
        this.setParam(opts, PROXY, proxy);
    }

    public void setRecentDateFormat(FileSystemOptions opts, String recentDateFormat) {
        this.setParam(opts, RECENT_DATE_FORMAT, recentDateFormat);
    }

    public void setRemoteVerification(FileSystemOptions opts, boolean remoteVerification) {
        this.setParam(opts, REMOTE_VERIFICATION, remoteVerification);
    }

    public void setServerLanguageCode(FileSystemOptions opts, String serverLanguageCode) {
        this.setParam(opts, SERVER_LANGUAGE_CODE, serverLanguageCode);
    }

    public void setServerTimeZoneId(FileSystemOptions opts, String serverTimeZoneId) {
        this.setParam(opts, SERVER_TIME_ZONE_ID, serverTimeZoneId);
    }

    public void setShortMonthNames(FileSystemOptions opts, String[] shortMonthNames) {
        String[] clone = null;
        if (shortMonthNames != null) {
            clone = new String[shortMonthNames.length];
            System.arraycopy(shortMonthNames, 0, clone, 0, shortMonthNames.length);
        }
        this.setParam(opts, SHORT_MONTH_NAMES, clone);
    }

    public void setSoTimeout(FileSystemOptions opts, Integer soTimeout) {
        this.setParam(opts, SO_TIMEOUT, soTimeout);
    }

    public void setUserDirIsRoot(FileSystemOptions opts, boolean userDirIsRoot) {
        this.setParam(opts, USER_DIR_IS_ROOT, userDirIsRoot ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isShowHiddenFiles(FileSystemOptions opts) {
        return this.getBoolean(opts, SHOW_HIDDEN_FILES, false);
    }

    public void setShowHiddenFiles(FileSystemOptions opts, boolean value) {
        this.setParam(opts, SHOW_HIDDEN_FILES, (Object)value);
    }

    public String getHomeFolderOverride(FileSystemOptions opts) {
        return this.getString(opts, HOME_FOLDER_OVERRIDE);
    }

    public void setHomeFolderOverride(FileSystemOptions opts, String value) {
        this.setParam(opts, HOME_FOLDER_OVERRIDE, value);
    }

    public boolean isCompatibleMode(FileSystemOptions opts) {
        return this.getBoolean(opts, COMPATIBLE_MODE, false);
    }

    public void setCompatibleMode(FileSystemOptions opts, boolean value) {
        this.setParam(opts, COMPATIBLE_MODE, (Object)value);
    }

    public SocketFactory getSocketFactory(FileSystemOptions opts) {
        return (SocketFactory)this.getParam(opts, SOCKET_FACTORY);
    }

    public void setSocketFactory(FileSystemOptions opts, SocketFactory value) {
        this.setParam(opts, SOCKET_FACTORY, value);
    }

    public ServerSocketFactory getServerSocketFactory(FileSystemOptions opts) {
        return (ServerSocketFactory)this.getParam(opts, SERVER_SOCKET_FACTORY);
    }

    public void setServerSocketFactory(FileSystemOptions opts, ServerSocketFactory value) {
        this.setParam(opts, SERVER_SOCKET_FACTORY, value);
    }

    public boolean isForceListCommand(FileSystemOptions opts) {
        return this.getBoolean(opts, FORCE_LIST_COMMAND, false);
    }

    public void setForceListCommand(FileSystemOptions opts, boolean value) {
        this.setParam(opts, FORCE_LIST_COMMAND, (Object)value);
    }

    public Integer getKeepAliveTimeout(FileSystemOptions opts) {
        return this.getInteger(opts, KEEP_ALIVE_TIMEOUT);
    }

    public void setKeepAliveTimeout(FileSystemOptions opts, Integer value) {
        this.setParam(opts, KEEP_ALIVE_TIMEOUT, value);
    }

    public JBFtpKeepAliveCommand getKeepAliveCommand(FileSystemOptions opts) {
        return this.getEnum(JBFtpKeepAliveCommand.class, opts, KEEP_ALIVE_COMMAND);
    }

    public void setKeepAliveCommand(FileSystemOptions opts, JBFtpKeepAliveCommand value) {
        this.setParam(opts, KEEP_ALIVE_COMMAND, (Object)value);
    }

    public ProtocolCommandListener getProtocolCommandListener(FileSystemOptions opts) {
        return (ProtocolCommandListener)this.getParam(opts, PROTOCOL_COMMAND_LISTENER);
    }

    public void setProtocolCommandListener(FileSystemOptions opts, ProtocolCommandListener value) {
        this.setParam(opts, PROTOCOL_COMMAND_LISTENER, value);
    }
}

