/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.audit;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.audit.ListenerAuditService;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementData;
import com.intellij.database.dataSource.connection.statements.SmartStatementMark;
import com.intellij.database.dataSource.connection.statements.SmartStatementsUtil;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\bf\u0018\u0000 \u00052\u00020\u00012\u00020\u0002:\u000b\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService;", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "Ljava/lang/AutoCloseable;", "Block", "BlockType", "Companion", "Counter", "DataSourceBlock", "Log4JPrinter", "LogInfo", "Printer", "Service", "StandardPrinter", "TextBlock", "intellij.database.impl"})
public interface DatabaseGlobalAuditService
extends ListenerAuditService,
AutoCloseable {
    public static final Companion Companion = com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.$$INSTANCE;

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Printer;", "", "print", "", "blocks", "", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;", "intellij.database.impl"})
    public static interface Printer {
        public void print(@NotNull List<? extends Block> var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016J\b\u0010\u001a\u001a\u00020\bH\u0016J\b\u0010\u001b\u001a\u00020\bH\u0016J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0015H\u0016J\u0018\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0015H\u0016J\u0018\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0016JY\u0010\u001f\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020'0&\"\u00020'H\u0002\u00a2\u0006\u0002\u0010(J3\u0010\u001f\u001a\u00020\b2\b\u0010 \u001a\u0004\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\n2\u0012\u0010%\u001a\n\u0012\u0006\b\u0001\u0012\u00020'0&\"\u00020'H\u0002\u00a2\u0006\u0002\u0010)J\u0010\u0010*\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010+\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010,\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010-\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u0002002\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u00101\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0015H\u0016J\u0018\u00101\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Service;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService;", "project", "Lcom/intellij/openapi/project/Project;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/DatabaseConnection;)V", "afterStatement", "", "mark", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "beforeCallableStatement", "data", "Lcom/intellij/database/dataSource/connection/statements/CallableStatementData;", "beforeParameterizedStatement", "Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementData;", "beforeResultsClosing", "resultSet", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "beforeSimpleStatement", "sql", "", "beforeStatementClosing", "statement", "Lcom/intellij/database/remote/jdbc/RemoteStatement;", "close", "connected", "disconnected", "error", "message", "logStatement", "print", "type", "statementId", "sessionId", "department", "Lcom/intellij/database/dataSource/connection/DatabaseDepartment;", "blocks", "", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;", "(Lcom/intellij/database/dataSource/DatabaseConnection;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/database/dataSource/connection/DatabaseDepartment;[Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;)V", "(Ljava/lang/String;Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;[Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;)V", "processed", "resultsOpened", "resultsProcessed", "statementOpened", "updateCount", "count", "", "warning", "intellij.database.impl"})
    private static final class Service
    implements DatabaseGlobalAuditService {
        private final Project project;
        private final DatabaseConnection connection;

        @Override
        public void connected() {
            String sessionId = com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getSessionsCounter$p(Companion).incrementAndGet();
            com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getSessions$p(Companion).put(this.connection, sessionId);
            Service.print$default(this, this.connection, "connected", null, null, null, new Block[0], 24, null);
        }

        @Override
        public void disconnected() {
            String id = (String)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getSessions$p(Companion).get(this.connection);
            if (id == null) {
                return;
            }
            Service.print$default(this, this.connection, "disconnected", null, null, null, new Block[0], 24, null);
            com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getSessions$p(Companion).remove(this.connection);
        }

        @Override
        public void beforeCallableStatement(@NotNull CallableStatementData data, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
            this.logStatement(data.getBasis().getSql(), mark2);
        }

        @Override
        public void beforeSimpleStatement(@NotNull String sql, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
            Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
            this.logStatement(sql, mark2);
        }

        @Override
        public void beforeParameterizedStatement(@NotNull ParameterizedStatementData data, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
            this.logStatement(data.getBasis().getSql(), mark2);
        }

        private final void logStatement(String sql, SmartStatementMark mark2) {
            String id = com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getStatementsCounter$p(Companion).incrementAndGet();
            com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getPending$p(Companion).put(mark2, new LogInfo(id, System.currentTimeMillis(), (String)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getSessions$p(Companion).get(this.connection), 0L, 0L, 0, 56, null));
            this.print(null, mark2, new TextBlock(BlockType.STATEMENT, SmartStatementsUtil.trimSql(sql, 10000), false, 4, null));
        }

        @Override
        public void warning(@NotNull String message2) {
            Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
            this.print(this.connection, "warning", null, null, null, new TextBlock(BlockType.WARNING, message2, false, 4, null));
        }

        @Override
        public void warning(@NotNull String message2, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
            this.print("warning", mark2, new TextBlock(BlockType.WARNING, message2, false, 4, null));
        }

        @Override
        public void message(@NotNull String message2, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
            this.print("message", mark2, new TextBlock(BlockType.MESSAGE, message2, false, 4, null));
        }

        @Override
        public void message(@NotNull String message2) {
            Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
            this.print(this.connection, "message", null, null, null, new TextBlock(BlockType.MESSAGE, message2, false, 4, null));
        }

        @Override
        public void error(@NotNull String message2) {
            Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
            this.print(this.connection, "error", null, null, null, new TextBlock(BlockType.ERROR, message2, false, 4, null));
        }

        @Override
        public void error(@NotNull String message2, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
            this.print("error", mark2, new TextBlock(BlockType.ERROR, message2, false, 4, null));
        }

        @Override
        public void updateCount(int count2, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
            if (count2 < 1) {
                return;
            }
            LogInfo info = (LogInfo)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getPending$p(Companion).get(mark2);
            if (info != null) {
                LogInfo logInfo = info;
                logInfo.setUpdateCount(logInfo.getUpdateCount() + (long)count2);
            } else {
                com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getLog$p(Companion).warn("Logging update count without pending statement");
            }
            this.print("update count received", mark2, new TextBlock(BlockType.UPDATE_COUNT, String.valueOf(count2), false, 4, null));
        }

        @Override
        public void resultsOpened(@NotNull RemoteResultSet resultSet, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkParameterIsNotNull((Object)resultSet, (String)"resultSet");
            Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
            LogInfo info = (LogInfo)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getPending$p(Companion).get(mark2);
            if (info != null) {
                LogInfo logInfo = info;
                int n = logInfo.getResults();
                logInfo.setResults(n + 1);
            } else {
                com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getLog$p(Companion).warn("Logging result set without pending statement");
            }
            this.print("results received", mark2, new Block[0]);
        }

        @Override
        public void resultsProcessed(@NotNull SmartStatementMark mark2) {
            Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
            this.processed(mark2);
        }

        @Override
        public void beforeStatementClosing(@NotNull RemoteStatement statement, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
            Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
            this.processed(mark2);
        }

        @Override
        public void afterStatement(@NotNull SmartStatementMark mark2) {
            Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
            LogInfo info = (LogInfo)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getPending$p(Companion).get(mark2);
            if (info == null) {
                com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getLog$p(Companion).warn("Execution finished without pending statement");
                return;
            }
            info.setEndTime(System.currentTimeMillis());
        }

        /*
         * WARNING - void declaration
         */
        private final void processed(SmartStatementMark mark2) {
            Block[] blockArray;
            void $this$toTypedArray$iv;
            boolean bl;
            TextBlock textBlock;
            Collection collection;
            LogInfo info = (LogInfo)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getPending$p(Companion).remove(mark2);
            if (info == null) {
                return;
            }
            long endTime = info.getEndTime() == -1L ? System.currentTimeMillis() : info.getEndTime();
            long executionDurationMs = info.getEndTime() != -1L ? Math.max(endTime - info.getStartTime(), 1L) : -1L;
            long processingDurationMs = System.currentTimeMillis() - info.getStartTime();
            long fetchingDurationMs = info.getEndTime() == -1L ? -1L : processingDurationMs - executionDurationMs;
            ArrayList messages = new ArrayList();
            if (executionDurationMs > 0L) {
                collection = messages;
                textBlock = new TextBlock(BlockType.EXECUTION_DURATION, "execution time: " + StringUtil.formatDuration((long)executionDurationMs), false, 4, null);
                bl = false;
                collection.add(textBlock);
            }
            if (fetchingDurationMs > 0L && (info.getUpdateCount() > 0L || info.getResults() > 0)) {
                collection = messages;
                textBlock = new TextBlock(BlockType.FETCHING_DURATION, "fetching time: " + StringUtil.formatDuration((long)fetchingDurationMs), false, 4, null);
                bl = false;
                collection.add(textBlock);
            }
            if (info.getUpdateCount() > 0L) {
                collection = messages;
                textBlock = new TextBlock(BlockType.TOTAL_UPDATE_COUNT, "total update count: " + info.getUpdateCount(), false, 4, null);
                bl = false;
                collection.add(textBlock);
            }
            if (info.getResults() > 0) {
                collection = messages;
                textBlock = new TextBlock(BlockType.TOTAL_RESULT_SET_COUNT, "total result sets count: " + info.getResults(), false, 4, null);
                bl = false;
                collection.add(textBlock);
            }
            collection = messages;
            DatabaseDepartment databaseDepartment = mark2.getDepartment();
            String string = info.getSessionId();
            String string2 = info.getId();
            String string3 = "finished";
            DatabaseConnection databaseConnection = this.connection;
            Service service = this;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Block[] blockArray2 = thisCollection$iv.toArray(new Block[0]);
            if (blockArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Block[] blockArray3 = blockArray = blockArray2;
            service.print(databaseConnection, string3, string2, string, databaseDepartment, Arrays.copyOf(blockArray3, blockArray3.length));
        }

        private final void print(String type, SmartStatementMark mark2, Block ... blocks) {
            LogInfo logInfo = (LogInfo)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getPending$p(Companion).get(mark2);
            LogInfo logInfo2 = (LogInfo)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getPending$p(Companion).get(mark2);
            this.print(this.connection, type, logInfo != null ? logInfo.getId() : null, logInfo2 != null ? logInfo2.getSessionId() : null, mark2.getDepartment(), Arrays.copyOf(blocks, blocks.length));
        }

        private final void print(DatabaseConnection connection2, String type, String statementId, String sessionId, DatabaseDepartment department, Block ... blocks) {
            boolean statement;
            int n;
            Object $this$any$iv;
            ArrayList otherBlocks;
            block8: {
                boolean bl;
                int n2;
                Block[] blockArray;
                otherBlocks = new ArrayList();
                Collection collection = otherBlocks;
                String string = com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getFormatter$p(Companion).format(LocalDateTime.now());
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"formatter.format(LocalDateTime.now())");
                Object object = new TextBlock(BlockType.TIMESTAMP, string, false, 4, null);
                boolean bl2 = false;
                collection.add(object);
                collection = otherBlocks;
                DatabaseConnectionPoint databaseConnectionPoint = connection2.getConnectionPoint();
                Intrinsics.checkExpressionValueIsNotNull((Object)databaseConnectionPoint, (String)"connection.connectionPoint");
                LocalDataSource localDataSource = databaseConnectionPoint.getDataSource();
                Intrinsics.checkExpressionValueIsNotNull((Object)localDataSource, (String)"connection.connectionPoint.dataSource");
                object = new DataSourceBlock(localDataSource);
                bl2 = false;
                collection.add(object);
                if (department != null) {
                    collection = otherBlocks;
                    object = new TextBlock(BlockType.SUBSYSTEM, department.getDepartmentName(), false, 4, null);
                    bl2 = false;
                    collection.add(object);
                }
                if (sessionId != null || com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getSessions$p(Companion).get(connection2) != null) {
                    collection = otherBlocks;
                    StringBuilder stringBuilder = new StringBuilder().append("session id: ");
                    String string2 = sessionId;
                    if (string2 == null) {
                        string2 = (String)com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getSessions$p(Companion).get(connection2);
                    }
                    object = new TextBlock(BlockType.SESSION_ID, stringBuilder.append(string2).toString(), false, 4, null);
                    bl2 = false;
                    collection.add(object);
                }
                if (statementId != null) {
                    collection = otherBlocks;
                    object = new TextBlock(BlockType.STATEMENT_ID, "statement id: " + statementId, false, 4, null);
                    bl2 = false;
                    collection.add(object);
                }
                if (type != null) {
                    boolean bl3;
                    collection = otherBlocks;
                    object = blocks;
                    String string3 = type;
                    BlockType blockType = BlockType.EVENT_TYPE;
                    bl2 = false;
                    blockArray = object;
                    n2 = 0;
                    boolean bl4 = bl3 = !(blockArray.length == 0);
                    String string4 = string3;
                    BlockType blockType2 = blockType;
                    object = new TextBlock(blockType2, string4, bl4);
                    bl2 = false;
                    collection.add(object);
                }
                $this$any$iv = blocks;
                boolean $i$f$any = false;
                blockArray = $this$any$iv;
                n2 = blockArray.length;
                for (n = 0; n < n2; ++n) {
                    Block element$iv;
                    Block it2 = element$iv = blockArray[n];
                    boolean bl5 = false;
                    if (!(it2.getType() == BlockType.STATEMENT)) continue;
                    bl = true;
                    break block8;
                }
                bl = statement = false;
            }
            if (statement) {
                $this$any$iv = otherBlocks;
                TextBlock $i$f$any = new TextBlock(BlockType.STATEMENT_PREFIX, "-- [ --------------------------------------------------", false, 4, null);
                boolean bl = false;
                $this$any$iv.add($i$f$any);
                $this$any$iv = otherBlocks;
                $i$f$any = new TextBlock(BlockType.STATEMENT_SUFFIX, "-- ] --------------------------------------------------", false, 4, null);
                bl = false;
                $this$any$iv.add($i$f$any);
            }
            if (this.project != null) {
                $this$any$iv = otherBlocks;
                String string = this.project.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.name");
                TextBlock $i$f$any = new TextBlock(BlockType.PROJECT, string, false, 4, null);
                boolean bl = false;
                $this$any$iv.add($i$f$any);
            }
            $this$any$iv = otherBlocks;
            TextBlock $i$f$any = new TextBlock(BlockType.LINE_PREFIX, "--", false, 4, null);
            boolean bl = false;
            $this$any$iv.add($i$f$any);
            Iterable $this$sortedBy$iv = CollectionsKt.plus((Collection)otherBlocks, (Object[])blocks);
            boolean $i$f$sortedBy = false;
            Iterable iterable = $this$sortedBy$iv;
            n = 0;
            Comparator comparator2 = new Comparator<T>(){

                public final int compare(T a, T b2) {
                    boolean bl = false;
                    Block f = (Block)a;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(ArraysKt.indexOf((Object[])com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getORDER$p(DatabaseGlobalAuditService.Companion), (Object)((Object)f.getType())));
                    f = (Block)b2;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = ArraysKt.indexOf((Object[])com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getORDER$p(DatabaseGlobalAuditService.Companion), (Object)((Object)f.getType()));
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            };
            List resultBlocks = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator2);
            Companion.print(resultBlocks);
        }

        static /* synthetic */ void print$default(Service service, DatabaseConnection databaseConnection, String string, String string2, String string3, DatabaseDepartment databaseDepartment, Block[] blockArray, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            if ((n & 4) != 0) {
                string2 = null;
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            if ((n & 0x10) != 0) {
                databaseDepartment = null;
            }
            service.print(databaseConnection, string, string2, string3, databaseDepartment, blockArray);
        }

        @Override
        public void beforeResultsClosing(@NotNull RemoteResultSet resultSet, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkParameterIsNotNull((Object)resultSet, (String)"resultSet");
            Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
        }

        @Override
        public void statementOpened(@NotNull RemoteStatement statement, @NotNull SmartStatementMark mark2) {
            Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
            Intrinsics.checkParameterIsNotNull((Object)mark2, (String)"mark");
        }

        @Override
        public void close() {
        }

        public Service(@Nullable Project project, @NotNull DatabaseConnection connection2) {
            Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
            this.project = project;
            this.connection = connection2;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&J\u0016\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$StandardPrinter;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Printer;", "()V", "flush", "", "text", "", "print", "blocks", "", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;", "intellij.database.impl"})
    public static abstract class StandardPrinter
    implements Printer {
        /*
         * WARNING - void declaration
         */
        @Override
        public void print(@NotNull List<? extends Block> blocks) {
            Collection<String> collection;
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Intrinsics.checkParameterIsNotNull(blocks, (String)"blocks");
            Iterable iterable = blocks;
            StandardPrinter standardPrinter = this;
            boolean $i$f$mapIndexed = false;
            void var4_5 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void value2;
                void idx;
                int n = index$iv$iv++;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                Block block = (Block)item$iv$iv;
                int n3 = n2;
                collection = collection2;
                boolean bl2 = false;
                String string = idx == blocks.size() - 1 ? value2.getText() : value2.getText() + value2.getType().getSeparator();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            standardPrinter.flush(CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)"", null, null, (int)0, null, null, (int)62, null));
        }

        public abstract void flush(@NotNull String var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Log4JPrinter;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$StandardPrinter;", "()V", "databaseCategoryLog", "Lorg/apache/log4j/Logger;", "flush", "", "text", "", "intellij.database.impl"})
    private static final class Log4JPrinter
    extends StandardPrinter {
        private static final org.apache.log4j.Logger databaseCategoryLog;
        public static final Log4JPrinter INSTANCE;

        @Override
        public void flush(@NotNull String text2) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
                org.apache.log4j.Logger logger = databaseCategoryLog;
                if (logger == null) break block0;
                logger.info((Object)text2);
            }
        }

        private Log4JPrinter() {
        }

        static {
            org.apache.log4j.Logger logger;
            Log4JPrinter log4JPrinter;
            INSTANCE = log4JPrinter = new Log4JPrinter();
            try {
                Path path = SmartStatementsUtil.getLogPath();
                PatternLayout layout = new PatternLayout("%m\n");
                Layout layout2 = (Layout)layout;
                File file = path.toFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"path.toFile()");
                RollingFileAppender appender = new RollingFileAppender(layout2, file.getPath());
                appender.setMaxFileSize("1Mb");
                appender.setMaxBackupIndex(12);
                appender.setEncoding("UTF-8");
                org.apache.log4j.Logger logger2 = org.apache.log4j.Logger.getLogger((String)"database-global-audit-service");
                Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getLogger(\"database-global-audit-service\")");
                org.apache.log4j.Logger result = logger2;
                result.setAdditivity(false);
                result.addAppender((Appender)appender);
                result.setLevel(Level.INFO);
                logger = result;
            }
            catch (IOException e) {
                com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getLog$p(Companion).error("Failed to initialize database logging", (Throwable)e);
                logger = null;
            }
            databaseCategoryLog = logger;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;", "", "type", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "(Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;Z)V", "content", "", "getContent", "()Ljava/lang/String;", "getFormat", "()Z", "text", "getText", "text$delegate", "Lkotlin/Lazy;", "getType", "()Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "intellij.database.impl"})
    public static abstract class Block {
        @NotNull
        private final Lazy text$delegate;
        @NotNull
        private final BlockType type;
        private final boolean format;

        @NotNull
        protected abstract String getContent();

        @NotNull
        public final String getText() {
            Lazy lazy = this.text$delegate;
            Block block = this;
            Object var3_3 = null;
            boolean bl = false;
            return (String)lazy.getValue();
        }

        @NotNull
        public final BlockType getType() {
            return this.type;
        }

        public final boolean getFormat() {
            return this.format;
        }

        public Block(@NotNull BlockType type, boolean format) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
            this.type = type;
            this.format = format;
            this.text$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ Block this$0;

                @NotNull
                public final String invoke() {
                    return this.this$0.getFormat() ? this.this$0.getType().format(this.this$0.getContent()) : this.this$0.getContent();
                }
                {
                    this.this$0 = block;
                    super(0);
                }
            }));
        }

        public /* synthetic */ Block(BlockType blockType, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            this(blockType, bl);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$TextBlock;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;", "type", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "content", "", "format", "", "(Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;Ljava/lang/String;Z)V", "getContent", "()Ljava/lang/String;", "intellij.database.impl"})
    public static final class TextBlock
    extends Block {
        @NotNull
        private final String content;

        @Override
        @NotNull
        protected String getContent() {
            return this.content;
        }

        public TextBlock(@NotNull BlockType type, @NotNull String content, boolean format) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
            super(type, format);
            this.content = content;
        }

        public /* synthetic */ TextBlock(BlockType blockType, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = true;
            }
            this(blockType, string, bl);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$DataSourceBlock;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "(Lcom/intellij/database/dataSource/LocalDataSource;)V", "content", "", "getContent", "()Ljava/lang/String;", "getDataSource", "()Lcom/intellij/database/dataSource/LocalDataSource;", "intellij.database.impl"})
    public static final class DataSourceBlock
    extends Block {
        @NotNull
        private final LocalDataSource dataSource;

        @Override
        @NotNull
        protected String getContent() {
            String string = this.dataSource.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dataSource.name");
            return string;
        }

        @NotNull
        public final LocalDataSource getDataSource() {
            return this.dataSource;
        }

        public DataSourceBlock(@NotNull LocalDataSource dataSource2) {
            Intrinsics.checkParameterIsNotNull((Object)dataSource2, (String)"dataSource");
            super(BlockType.DATA_SOURCE, false, 2, null);
            this.dataSource = dataSource2;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u001b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u000e\u0010\n\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001d\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "", "separator", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getSeparator", "()Ljava/lang/String;", "bound", "s", "format", "inline", "STATEMENT_PREFIX", "LINE_PREFIX", "TIMESTAMP", "DATA_SOURCE", "SUBSYSTEM", "SESSION_ID", "STATEMENT_ID", "EVENT_TYPE", "STATEMENT", "MESSAGE", "WARNING", "ERROR", "PROJECT", "EXECUTION_DURATION", "FETCHING_DURATION", "UPDATE_COUNT", "TOTAL_UPDATE_COUNT", "TOTAL_RESULT_SET_COUNT", "STATEMENT_SUFFIX", "intellij.database.impl"})
    public static final class BlockType
    extends Enum<BlockType> {
        public static final /* enum */ BlockType STATEMENT_PREFIX;
        public static final /* enum */ BlockType LINE_PREFIX;
        public static final /* enum */ BlockType TIMESTAMP;
        public static final /* enum */ BlockType DATA_SOURCE;
        public static final /* enum */ BlockType SUBSYSTEM;
        public static final /* enum */ BlockType SESSION_ID;
        public static final /* enum */ BlockType STATEMENT_ID;
        public static final /* enum */ BlockType EVENT_TYPE;
        public static final /* enum */ BlockType STATEMENT;
        public static final /* enum */ BlockType MESSAGE;
        public static final /* enum */ BlockType WARNING;
        public static final /* enum */ BlockType ERROR;
        public static final /* enum */ BlockType PROJECT;
        public static final /* enum */ BlockType EXECUTION_DURATION;
        public static final /* enum */ BlockType FETCHING_DURATION;
        public static final /* enum */ BlockType UPDATE_COUNT;
        public static final /* enum */ BlockType TOTAL_UPDATE_COUNT;
        public static final /* enum */ BlockType TOTAL_RESULT_SET_COUNT;
        public static final /* enum */ BlockType STATEMENT_SUFFIX;
        private static final /* synthetic */ BlockType[] $VALUES;
        @NotNull
        private final String separator;

        static {
            BlockType[] blockTypeArray = new BlockType[19];
            BlockType[] blockTypeArray2 = blockTypeArray;
            blockTypeArray[0] = STATEMENT_PREFIX = new BlockType("\n");
            blockTypeArray[1] = LINE_PREFIX = new BlockType("LINE_PREFIX", 1, null, 1, null);
            blockTypeArray[2] = TIMESTAMP = new BlockType("TIMESTAMP", 2, null, 1, null);
            blockTypeArray[3] = DATA_SOURCE = new DATA_SOURCE("DATA_SOURCE", 3);
            blockTypeArray[4] = SUBSYSTEM = new SUBSYSTEM("SUBSYSTEM", 4);
            blockTypeArray[5] = SESSION_ID = new SESSION_ID("SESSION_ID", 5);
            blockTypeArray[6] = STATEMENT_ID = new STATEMENT_ID("STATEMENT_ID", 6);
            blockTypeArray[7] = EVENT_TYPE = new BlockType(" - ");
            blockTypeArray[8] = STATEMENT = new STATEMENT("STATEMENT", 8);
            blockTypeArray[9] = MESSAGE = new MESSAGE("MESSAGE", 9);
            blockTypeArray[10] = WARNING = new WARNING("WARNING", 10);
            blockTypeArray[11] = ERROR = new ERROR("ERROR", 11);
            blockTypeArray[12] = PROJECT = new PROJECT("PROJECT", 12);
            blockTypeArray[13] = EXECUTION_DURATION = new BlockType(", ");
            blockTypeArray[14] = FETCHING_DURATION = new BlockType(", ");
            blockTypeArray[15] = UPDATE_COUNT = new BlockType("UPDATE_COUNT", 15, null, 1, null);
            blockTypeArray[16] = TOTAL_UPDATE_COUNT = new BlockType(", ");
            blockTypeArray[17] = TOTAL_RESULT_SET_COUNT = new BlockType(", ");
            blockTypeArray[18] = STATEMENT_SUFFIX = new BlockType("");
            $VALUES = blockTypeArray;
        }

        @NotNull
        public String format(@NotNull String s) {
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            return s;
        }

        @NotNull
        public final String bound(@NotNull String s) {
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            return '[' + s + ']';
        }

        @NotNull
        public final String inline(@NotNull String s) {
            String string;
            Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
            if (StringUtil.containsLineBreak((CharSequence)s)) {
                String string2 = StringUtil.escapeStringCharacters((String)s);
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringUtil.escapeStringCharacters(s)");
            } else {
                string = s;
            }
            return string;
        }

        @NotNull
        public final String getSeparator() {
            return this.separator;
        }

        private BlockType(String separator) {
            this.separator = separator;
        }

        /* synthetic */ BlockType(String string, int n, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string2 = " ";
            }
            this(string2);
        }

        public /* synthetic */ BlockType(String $enum_name_or_ordinal$0, int $enum_name_or_ordinal$1, String separator, DefaultConstructorMarker $constructor_marker) {
            this(separator);
        }

        public static BlockType[] values() {
            return (BlockType[])$VALUES.clone();
        }

        public static BlockType valueOf(String string) {
            return Enum.valueOf(BlockType.class, string);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType$DATA_SOURCE;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.impl"})
        static final class DATA_SOURCE
        extends BlockType {
            @Override
            @NotNull
            public String format(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                return this.bound(s);
            }

            /*
             * WARNING - void declaration
             */
            DATA_SOURCE() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType$SUBSYSTEM;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.impl"})
        static final class SUBSYSTEM
        extends BlockType {
            @Override
            @NotNull
            public String format(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                return this.bound(s);
            }

            /*
             * WARNING - void declaration
             */
            SUBSYSTEM() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType$SESSION_ID;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.impl"})
        static final class SESSION_ID
        extends BlockType {
            @Override
            @NotNull
            public String format(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                return this.bound(s);
            }

            /*
             * WARNING - void declaration
             */
            SESSION_ID() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType$STATEMENT_ID;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.impl"})
        static final class STATEMENT_ID
        extends BlockType {
            @Override
            @NotNull
            public String format(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                return this.bound(s);
            }

            /*
             * WARNING - void declaration
             */
            STATEMENT_ID() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType$STATEMENT;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.impl"})
        static final class STATEMENT
        extends BlockType {
            @Override
            @NotNull
            public String format(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                return (!StringUtil.startsWith((CharSequence)s, (CharSequence)"\n") ? "\n" : "") + super.format(s);
            }

            /*
             * WARNING - void declaration
             */
            STATEMENT() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType$MESSAGE;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.impl"})
        static final class MESSAGE
        extends BlockType {
            @Override
            @NotNull
            public String format(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                return this.inline(s);
            }

            /*
             * WARNING - void declaration
             */
            MESSAGE() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType$WARNING;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.impl"})
        static final class WARNING
        extends BlockType {
            @Override
            @NotNull
            public String format(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                return this.inline(s);
            }

            /*
             * WARNING - void declaration
             */
            WARNING() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType$ERROR;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.impl"})
        static final class ERROR
        extends BlockType {
            @Override
            @NotNull
            public String format(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                return this.inline(s);
            }

            /*
             * WARNING - void declaration
             */
            ERROR() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType$PROJECT;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "format", "", "s", "intellij.database.impl"})
        static final class PROJECT
        extends BlockType {
            @Override
            @NotNull
            public String format(@NotNull String s) {
                Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
                return this.bound(s);
            }

            /*
             * WARNING - void declaration
             */
            PROJECT() {
                void var1_1;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\nH\u00c6\u0003JG\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020\nH\u00d6\u0001J\t\u0010%\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\r\"\u0004\b\u0019\u0010\u000f\u00a8\u0006&"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$LogInfo;", "", "id", "", "startTime", "", "sessionId", "endTime", "updateCount", "results", "", "(Ljava/lang/String;JLjava/lang/String;JJI)V", "getEndTime", "()J", "setEndTime", "(J)V", "getId", "()Ljava/lang/String;", "getResults", "()I", "setResults", "(I)V", "getSessionId", "getStartTime", "getUpdateCount", "setUpdateCount", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "intellij.database.impl"})
    public static final class LogInfo {
        @NotNull
        private final String id;
        private final long startTime;
        @Nullable
        private final String sessionId;
        private long endTime;
        private long updateCount;
        private int results;

        @NotNull
        public final String getId() {
            return this.id;
        }

        public final long getStartTime() {
            return this.startTime;
        }

        @Nullable
        public final String getSessionId() {
            return this.sessionId;
        }

        public final long getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(long l) {
            this.endTime = l;
        }

        public final long getUpdateCount() {
            return this.updateCount;
        }

        public final void setUpdateCount(long l) {
            this.updateCount = l;
        }

        public final int getResults() {
            return this.results;
        }

        public final void setResults(int n) {
            this.results = n;
        }

        public LogInfo(@NotNull String id, long startTime, @Nullable String sessionId, long endTime, long updateCount2, int results2) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            this.id = id;
            this.startTime = startTime;
            this.sessionId = sessionId;
            this.endTime = endTime;
            this.updateCount = updateCount2;
            this.results = results2;
        }

        public /* synthetic */ LogInfo(String string, long l, String string2, long l2, long l3, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                l = -1L;
            }
            if ((n2 & 8) != 0) {
                l2 = -1L;
            }
            if ((n2 & 0x10) != 0) {
                l3 = 0L;
            }
            if ((n2 & 0x20) != 0) {
                n = 0;
            }
            this(string, l, string2, l2, l3, n);
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        public final long component2() {
            return this.startTime;
        }

        @Nullable
        public final String component3() {
            return this.sessionId;
        }

        public final long component4() {
            return this.endTime;
        }

        public final long component5() {
            return this.updateCount;
        }

        public final int component6() {
            return this.results;
        }

        @NotNull
        public final LogInfo copy(@NotNull String id, long startTime, @Nullable String sessionId, long endTime, long updateCount2, int results2) {
            Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
            return new LogInfo(id, startTime, sessionId, endTime, updateCount2, results2);
        }

        public static /* synthetic */ LogInfo copy$default(LogInfo logInfo, String string, long l, String string2, long l2, long l3, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = logInfo.id;
            }
            if ((n2 & 2) != 0) {
                l = logInfo.startTime;
            }
            if ((n2 & 4) != 0) {
                string2 = logInfo.sessionId;
            }
            if ((n2 & 8) != 0) {
                l2 = logInfo.endTime;
            }
            if ((n2 & 0x10) != 0) {
                l3 = logInfo.updateCount;
            }
            if ((n2 & 0x20) != 0) {
                n = logInfo.results;
            }
            return logInfo.copy(string, l, string2, l2, l3, n);
        }

        @NotNull
        public String toString() {
            return "LogInfo(id=" + this.id + ", startTime=" + this.startTime + ", sessionId=" + this.sessionId + ", endTime=" + this.endTime + ", updateCount=" + this.updateCount + ", results=" + this.results + ")";
        }

        public int hashCode() {
            String string = this.id;
            String string2 = this.sessionId;
            return (((((string != null ? string.hashCode() : 0) * 31 + Long.hashCode(this.startTime)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + Long.hashCode(this.endTime)) * 31 + Long.hashCode(this.updateCount)) * 31 + Integer.hashCode(this.results);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LogInfo)) break block3;
                    LogInfo logInfo = (LogInfo)object;
                    if (!Intrinsics.areEqual((Object)this.id, (Object)logInfo.id) || this.startTime != logInfo.startTime || !Intrinsics.areEqual((Object)this.sessionId, (Object)logInfo.sessionId) || this.endTime != logInfo.endTime || this.updateCount != logInfo.updateCount || this.results != logInfo.results) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J(\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0006\u0010\u000e\u001a\u00020\nJ\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0002R#\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Counter;", "", "()V", "reference", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlin/Pair;", "", "getReference", "()Ljava/util/concurrent/atomic/AtomicReference;", "asIdString", "", "pair", "increment", "longs", "incrementAndGet", "nextValue", "long", "intellij.database.impl"})
    private static final class Counter {
        @NotNull
        private final AtomicReference<Pair<Long, Long>> reference;

        @NotNull
        public final AtomicReference<Pair<Long, Long>> getReference() {
            return this.reference;
        }

        @NotNull
        public final String incrementAndGet() {
            Pair<Long, Long> pair = this.reference.updateAndGet((UnaryOperator<Pair<Long, Long>>)new UnaryOperator<Pair<? extends Long, ? extends Long>>(this){
                final /* synthetic */ Counter this$0;

                @NotNull
                public final Pair<Long, Long> apply(Pair<Long, Long> it2) {
                    Pair<Long, Long> pair = it2;
                    Intrinsics.checkExpressionValueIsNotNull(pair, (String)"it");
                    return Counter.access$increment(this.this$0, pair);
                }
                {
                    this.this$0 = counter;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull(pair, (String)"reference.updateAndGet { increment(it) }");
            return this.asIdString(pair);
        }

        private final String asIdString(Pair<Long, Long> pair) {
            return (((Number)pair.getFirst()).longValue() == 0L ? "" : String.valueOf(((Number)pair.getFirst()).longValue())) + String.valueOf(((Number)pair.getSecond()).longValue());
        }

        private final Pair<Long, Long> increment(Pair<Long, Long> longs) {
            long second = ((Number)longs.getSecond()).longValue();
            long nextSecond = this.nextValue(second);
            long first2 = nextSecond == 0L ? this.nextValue(((Number)longs.getFirst()).longValue()) : ((Number)longs.getFirst()).longValue();
            return new Pair((Object)first2, (Object)nextSecond);
        }

        private final long nextValue(long l) {
            return l == Long.MAX_VALUE ? 0L : l + 1L;
        }

        public Counter() {
            long l = new Random().nextInt();
            Long l2 = 0L;
            Counter counter = this;
            boolean bl = false;
            long l3 = Math.abs(l);
            Pair pair = TuplesKt.to((Object)l2, (Object)l3);
            counter.reference = new AtomicReference<Pair>(pair);
        }

        public static final /* synthetic */ Pair access$increment(Counter $this, Pair longs) {
            return $this.increment((Pair<Long, Long>)longs);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eJ\u001b\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u0015H\u0086\u0002J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0%J\u0016\u0010&\u001a\u00020\u001b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Companion;", "", "()V", "MAX_CHARACTERS", "", "ORDER", "", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "[Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$BlockType;", "formatter", "Ljava/time/format/DateTimeFormatter;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "pending", "", "Lcom/intellij/database/dataSource/connection/statements/SmartStatementMark;", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$LogInfo;", "printers", "", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Printer;", "sessions", "Lcom/intellij/database/dataSource/DatabaseConnection;", "", "sessionsCounter", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Counter;", "statementsCounter", "attach", "", "printer", "disposable", "Lcom/intellij/openapi/Disposable;", "get", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService;", "project", "Lcom/intellij/openapi/project/Project;", "connection", "getPendingStatements", "", "print", "blocks", "", "Lcom/intellij/database/dataSource/connection/audit/DatabaseGlobalAuditService$Block;", "intellij.database.impl"})
    public static final class Companion {
        private static final int MAX_CHARACTERS = 10000;
        private static final BlockType[] ORDER;
        private static final Logger log;
        private static final Map<SmartStatementMark, LogInfo> pending;
        private static final Map<DatabaseConnection, String> sessions;
        private static final DateTimeFormatter formatter;
        private static final Counter statementsCounter;
        private static final Counter sessionsCounter;
        private static final List<Printer> printers;
        static final /* synthetic */ Companion $$INSTANCE;

        @NotNull
        public final DatabaseGlobalAuditService get(@Nullable Project project, @NotNull DatabaseConnection connection2) {
            Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
            return new Service(project, connection2);
        }

        @NotNull
        public final Set<SmartStatementMark> getPendingStatements() {
            return pending.keySet();
        }

        public final void attach(@NotNull Printer printer, @NotNull Disposable disposable2) {
            Intrinsics.checkParameterIsNotNull((Object)printer, (String)"printer");
            Intrinsics.checkParameterIsNotNull((Object)disposable2, (String)"disposable");
            Collection collection = printers;
            boolean bl = false;
            collection.add(printer);
            Disposer.register((Disposable)disposable2, (Disposable)new Disposable(this, printer){
                final /* synthetic */ Companion this$0;
                final /* synthetic */ Printer $printer;

                public final void dispose() {
                    Collection collection = com.intellij.database.dataSource.connection.audit.DatabaseGlobalAuditService$Companion.access$getPrinters$p(this.this$0);
                    Printer printer = this.$printer;
                    boolean bl = false;
                    collection.remove(printer);
                }
                {
                    this.this$0 = companion;
                    this.$printer = printer;
                }
            });
        }

        private final void print(List<? extends Block> blocks) {
            Iterable $this$forEach$iv = printers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Printer it2 = (Printer)element$iv;
                boolean bl = false;
                it2.print(blocks);
            }
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
            ORDER = new BlockType[]{BlockType.STATEMENT_PREFIX, BlockType.LINE_PREFIX, BlockType.TIMESTAMP, BlockType.PROJECT, BlockType.DATA_SOURCE, BlockType.SUBSYSTEM, BlockType.SESSION_ID, BlockType.STATEMENT_ID, BlockType.EVENT_TYPE, BlockType.STATEMENT, BlockType.MESSAGE, BlockType.WARNING, BlockType.ERROR, BlockType.UPDATE_COUNT, BlockType.EXECUTION_DURATION, BlockType.FETCHING_DURATION, BlockType.TOTAL_UPDATE_COUNT, BlockType.TOTAL_RESULT_SET_COUNT, BlockType.STATEMENT_SUFFIX};
            Logger logger = Logger.getInstance(DatabaseGlobalAuditService.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"com.intellij.openapi.dia\u2026Service::class.java\n    )");
            log = logger;
            ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakMap();
            Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.createConcurrentWeakMap()");
            pending = concurrentMap;
            ConcurrentMap concurrentMap2 = ContainerUtil.newConcurrentMap();
            Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap2, (String)"ContainerUtil.newConcurrentMap()");
            sessions = concurrentMap2;
            DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(" ").appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(":").appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(":").appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
            Intrinsics.checkExpressionValueIsNotNull((Object)dateTimeFormatter, (String)"DateTimeFormatterBuilder\u2026, 2)\n      .toFormatter()");
            formatter = dateTimeFormatter;
            statementsCounter = new Counter();
            sessionsCounter = new Counter();
            ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
            Intrinsics.checkExpressionValueIsNotNull((Object)concurrentList, (String)"ContainerUtil.createConcurrentList()");
            printers = (List)concurrentList;
            Collection collection = printers;
            Log4JPrinter log4JPrinter = Log4JPrinter.INSTANCE;
            boolean bl = false;
            collection.add(log4JPrinter);
        }

        public static final /* synthetic */ Counter access$getSessionsCounter$p(Companion $this) {
            Companion companion = $this;
            return sessionsCounter;
        }

        public static final /* synthetic */ Map access$getSessions$p(Companion $this) {
            Companion companion = $this;
            return sessions;
        }

        public static final /* synthetic */ Counter access$getStatementsCounter$p(Companion $this) {
            Companion companion = $this;
            return statementsCounter;
        }

        public static final /* synthetic */ Map access$getPending$p(Companion $this) {
            Companion companion = $this;
            return pending;
        }

        public static final /* synthetic */ Logger access$getLog$p(Companion $this) {
            Companion companion = $this;
            return log;
        }

        public static final /* synthetic */ DateTimeFormatter access$getFormatter$p(Companion $this) {
            Companion companion = $this;
            return formatter;
        }

        public static final /* synthetic */ BlockType[] access$getORDER$p(Companion $this) {
            Companion companion = $this;
            return ORDER;
        }

        public static final /* synthetic */ List access$getPrinters$p(Companion $this) {
            Companion companion = $this;
            return printers;
        }
    }
}

