/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.Dbms;
import com.intellij.database.actions.ImportAction;
import com.intellij.database.dbimport.ImportDatabaseModifier;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportSettings;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataImporter {
    private static final Set<DasTable> ourBusyTables = ContainerUtil.newConcurrentSet();
    private final Project myProject;
    private final DbElement myElement;
    private final ImportAction.InputType myInputType;
    private final ImportInfo myInfo;

    public DataImporter(@NotNull Project project, @NotNull DbElement element2, @NotNull ImportAction.InputType inputType, @Nullable ImportInfo info) {
        if (project == null) {
            DataImporter.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            DataImporter.$$$reportNull$$$0(1);
        }
        if (inputType == null) {
            DataImporter.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myElement = element2;
        this.myInputType = inputType;
        this.myInfo = info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importData() throws IOException {
        if (this.myInfo == null) {
            return;
        }
        DbDataSource dataSource2 = this.myElement.getDataSource();
        Dbms dbms = dataSource2.getDbms();
        ImportSettings.store(this.myInfo, dbms, dataSource2.getVersion());
        this.lockTable();
        boolean shouldUnlock = true;
        try {
            DasNamespace namespace = DbImplUtil.getSearchPathObjectForSwitch(this.myElement);
            ReaderTask.Input input = this.myInputType.createInput(this.myInfo);
            ImportDatabaseModifier modifier = new ImportDatabaseModifier(this.myProject, DbImplUtil.getLocalDataSource((DasDataSource)dataSource2), this.myInfo, dbms, input, ObjectPaths.searchPathOf((DasObject)namespace));
            modifier.getContext().include(this.myElement);
            modifier.getContext().setElementToFocus(this.myElement instanceof DbTable ? null : this.myInfo.getTable().getPath());
            modifier.runStatements(false).whenComplete(null, (r, e) -> this.unlockTable());
            shouldUnlock = false;
        }
        finally {
            if (shouldUnlock) {
                this.unlockTable();
            }
        }
    }

    private void lockTable() {
        if (!Objects.requireNonNull(this.myInfo).shouldLockTable()) {
            return;
        }
        if (this.myElement instanceof DasTable) {
            ourBusyTables.add((DasTable)this.myElement);
        }
    }

    private void unlockTable() {
        if (!Objects.requireNonNull(this.myInfo).shouldLockTable()) {
            return;
        }
        if (this.myElement instanceof DasTable) {
            ourBusyTables.remove((DasTable)this.myElement);
        }
    }

    public static boolean isBusy(@Nullable Object element2) {
        DasTable table = DataImporter.getElement(element2);
        return table != null && ourBusyTables.contains(table);
    }

    private static DasTable getElement(@Nullable Object element2) {
        return element2 instanceof DasTableChild ? ((DasTableChild)element2).getTable() : (element2 instanceof DasTable ? (DasTable)element2 : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "inputType";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dbimport/DataImporter";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

