/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseDriverManagerImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelRelationManager;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.SafeFileOutputStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

@Service
public final class ModelExternalData {
    private static final Logger LOG = Logger.getInstance(ModelExternalData.class);
    public static final ExtensionPointName<DatabaseDriverManagerImpl.ConfigUrlBean> CONFIG_EP = ExtensionPointName.create((String)"com.intellij.database.modelExternalData");
    public static final String EXTERNAL_DATA_PATH = "EXTERNAL_DATA_PATH";
    private final MultiMap<Dbms, Data> myDataByDbms = MultiMap.createLinkedSet();
    private final Map<String, Pair<Data, Long>> myDataByFile = ContainerUtil.createSoftValueMap();

    private static ModelExternalData getInstance() {
        return (ModelExternalData)ApplicationManager.getApplication().getService(ModelExternalData.class);
    }

    public ModelExternalData() {
        try {
            for (URL url : DatabaseDriverManagerImpl.ConfigUrlBean.getUrls(CONFIG_EP.getExtensionsIfPointIsRegistered())) {
                try {
                    InputStream stream = url.openStream();
                    Throwable throwable = null;
                    try {
                        this.loadConfig(stream);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (stream == null) continue;
                        if (throwable != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
                catch (IOException e) {
                    LOG.warn("Failed to load " + url.toExternalForm(), (Throwable)e);
                }
            }
        }
        catch (Throwable th) {
            LOG.error("Failed to load model external data", th);
        }
    }

    private void loadConfig(@NotNull InputStream stream) {
        if (stream == null) {
            ModelExternalData.$$$reportNull$$$0(0);
        }
        this.loadConfig(ModelExternalData.createReader(stream));
    }

    @NotNull
    private static HierarchicalStreamReader createReader(@NotNull InputStream stream) {
        if (stream == null) {
            ModelExternalData.$$$reportNull$$$0(1);
        }
        return new XppReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), (XmlPullParser)new MXParser());
    }

    private void loadConfig(@NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            ModelExternalData.$$$reportNull$$$0(2);
        }
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            this.loadData(reader);
            reader.moveUp();
        }
    }

    private void loadData(@NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            ModelExternalData.$$$reportNull$$$0(3);
        }
        if (!"data".equals(reader.getNodeName())) {
            return;
        }
        String dbms = reader.getAttribute("dbms");
        if (dbms == null) {
            return;
        }
        Data data = ModelExternalData.loadDataInner(reader);
        for (String s : StringUtil.tokenize((String)dbms, (String)",")) {
            Dbms d2 = Dbms.byName((String)s);
            if (d2 == null) {
                LOG.warn("No dbms " + s);
                continue;
            }
            this.myDataByDbms.putValue((Object)d2, (Object)data);
        }
    }

    @NotNull
    private static Data loadDataInner(@NotNull HierarchicalStreamReader reader) {
        if (reader == null) {
            ModelExternalData.$$$reportNull$$$0(4);
        }
        Data data = new Data();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if ("table-set".equals(reader.getNodeName())) {
                ModelExternalData.loadTableSet(data.tableSet, reader);
            }
            reader.moveUp();
        }
        Data data2 = data;
        if (data2 == null) {
            ModelExternalData.$$$reportNull$$$0(5);
        }
        return data2;
    }

    private static void loadTableSet(MultiMap<ObjectPath, FkDesc> tableSet, HierarchicalStreamReader reader) {
        if (!"table-set".equals(reader.getNodeName())) {
            return;
        }
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            ModelExternalData.loadTableFks(tableSet, reader);
            reader.moveUp();
        }
    }

    private static void loadTableFks(MultiMap<ObjectPath, FkDesc> tableSet, HierarchicalStreamReader reader) {
        ObjectPath tablePath = ModelExternalData.getPath(reader);
        if (tablePath == null) {
            return;
        }
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            FkDesc desc = ModelExternalData.loadFkDesc(reader);
            if (desc != null) {
                tableSet.putValue((Object)tablePath, (Object)desc);
            }
            reader.moveUp();
        }
    }

    private static FkDesc loadFkDesc(HierarchicalStreamReader reader) {
        ObjectPath ref = ModelExternalData.getPath(reader);
        if (ref == null) {
            return null;
        }
        String from = reader.getAttribute("from");
        if (from == null) {
            LOG.warn("Missing from attr");
            return null;
        }
        String to = reader.getAttribute("to");
        if (to == null) {
            LOG.warn("Missing to attr");
            return null;
        }
        return new FkDesc(StringUtil.split((String)from, (String)","), ref, StringUtil.split((String)to, (String)","));
    }

    @Nullable
    private static ObjectPath getPath(HierarchicalStreamReader reader) {
        ObjectKind kind = (ObjectKind)ObjectKind.ourKinds.get(reader.getNodeName());
        if (kind == null || !DbImplUtil.isDataTable(kind)) {
            LOG.warn("Invalid table kind " + reader.getNodeName());
            return null;
        }
        return ModelExternalData.loadPath(reader.getAttribute("path"), kind);
    }

    private static ObjectPath loadPath(@Nullable String path, @NotNull ObjectKind kind) {
        if (kind == null) {
            ModelExternalData.$$$reportNull$$$0(6);
        }
        if (path == null) {
            LOG.warn("Missing `path` attr");
            return null;
        }
        String[] split = path.split("\\.");
        if (split.length > 3) {
            LOG.warn("Path should be no longer than db.sc.tab, but it is " + path);
            return null;
        }
        ObjectPath p2 = null;
        for (int i2 = 0; i2 < split.length; ++i2) {
            int pd = split.length - i2 - 1;
            ObjectKind k = pd == 0 ? kind : (pd == 1 ? ObjectKind.SCHEMA : ObjectKind.DATABASE);
            p2 = ObjectPath.create((String)split[i2], (ObjectKind)k, (boolean)true, null, p2);
        }
        return p2;
    }

    @Nullable
    private static DasObject resolveSimilar(@Nullable DasObject anchor, @Nullable ObjectPath path) {
        if (path == null || anchor == null) {
            return anchor;
        }
        DasObject parent2 = anchor.getDasParent();
        DasObject resolvedParent = ModelExternalData.resolveSimilar(parent2, path.parent);
        Condition condition = DbSqlUtil.byName(path.name, path.isQuoted(), null, DbImplUtil.getCasingProvider(anchor));
        if (parent2 == resolvedParent && anchor.getKind() == path.kind && condition.value((Object)anchor)) {
            return anchor;
        }
        if (resolvedParent == null) {
            return null;
        }
        return (DasObject)resolvedParent.getDasChildren(path.kind).filter(condition).first();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Data getData(@NotNull String path) {
        String key;
        if (path == null) {
            ModelExternalData.$$$reportNull$$$0(7);
        }
        File file = new File(path);
        long modified = file.lastModified();
        try {
            key = file.getCanonicalPath();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return null;
        }
        Map<String, Pair<Data, Long>> e = this.myDataByFile;
        synchronized (e) {
            Pair<Data, Long> data = this.myDataByFile.get(key);
            if (data != null && (Long)data.second >= modified) {
                return (Data)data.first;
            }
        }
        Data res = null;
        try (FileInputStream stream = new FileInputStream(file);){
            res = ModelExternalData.loadDataInner(ModelExternalData.createReader(stream));
        }
        catch (Throwable e2) {
            String message2 = "Unable to load " + key;
            LOG.warn(message2, e2);
            DatabaseNotifications.GENERAL_BALLOON_GROUP.createNotification(message2, NotificationType.ERROR).notify(null);
        }
        Map<String, Pair<Data, Long>> map2 = this.myDataByFile;
        synchronized (map2) {
            Pair<Data, Long> data = this.myDataByFile.get(key);
            if (data != null && (Long)data.second >= modified) {
                return (Data)data.first;
            }
            this.myDataByFile.put(key, (Pair<Data, Long>)Pair.create((Object)res, (Object)modified));
            return res;
        }
    }

    public static void modify(@NotNull String path, @NotNull Consumer<? super Data> modifier) {
        Data data;
        if (path == null) {
            ModelExternalData.$$$reportNull$$$0(8);
        }
        if (modifier == null) {
            ModelExternalData.$$$reportNull$$$0(9);
        }
        if ((data = ModelExternalData.getInstance().getData(path)) == null) {
            data = new Data();
        }
        modifier.consume((Object)data);
        try {
            ModelExternalData.serialize(data, path);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static void serialize(Data data, String path) throws IOException {
        try (SafeFileOutputStream out = new SafeFileOutputStream(new File(path));){
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            PrettyPrintWriter writer = new PrettyPrintWriter((Writer)printWriter);
            ModelExternalData.serialize(data, (HierarchicalStreamWriter)writer);
            writer.close();
        }
    }

    private static void serialize(Data data, HierarchicalStreamWriter writer) {
        writer.startNode("data");
        ModelExternalData.serialize(data.tableSet, writer);
        writer.endNode();
    }

    private static void serialize(MultiMap<ObjectPath, FkDesc> tableSet, HierarchicalStreamWriter writer) {
        writer.startNode("table-set");
        for (Map.Entry entry : tableSet.entrySet()) {
            ModelExternalData.startPathNode(writer, (ObjectPath)entry.getKey());
            for (FkDesc desc : (Collection)entry.getValue()) {
                ModelExternalData.startPathNode(writer, desc.ref);
                writer.addAttribute("from", StringUtil.join((Collection)desc.columns, (String)","));
                writer.addAttribute("to", StringUtil.join((Collection)desc.refColumns, (String)","));
                writer.endNode();
            }
            writer.endNode();
        }
        writer.endNode();
    }

    private static void startPathNode(HierarchicalStreamWriter writer, ObjectPath path) {
        writer.startNode(path.kind.code());
        writer.addAttribute("path", path.getDisplayName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/ModelExternalData";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/ModelExternalData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDataInner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadConfig";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createReader";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadDataInner";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FakeColumn
    implements DasColumn {
        private final DasTable myTable;
        private final String myName;
        private final DataType myType;

        private FakeColumn(DasTable table, String name, DataType type) {
            this.myTable = table;
            this.myName = name;
            this.myType = type;
        }

        public short getPosition() {
            return 0;
        }

        @Nullable
        public DasTable getTable() {
            return this.myTable;
        }

        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myType;
            if (dataType == null) {
                FakeColumn.$$$reportNull$$$0(0);
            }
            return dataType;
        }

        public boolean isNotNull() {
            return false;
        }

        @Nullable
        public String getDefault() {
            return null;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            if (objectKind == null) {
                FakeColumn.$$$reportNull$$$0(1);
            }
            return objectKind;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                FakeColumn.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/model/ModelExternalData$FakeColumn";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class ExtraForeignKey
    extends ModelRelationManager.ExtraRelation {
        private final FkDesc myFk;

        private ExtraForeignKey(@NotNull DasTable table, @NotNull FkDesc fk, @NotNull DasTable refTable) {
            if (table == null) {
                ExtraForeignKey.$$$reportNull$$$0(0);
            }
            if (fk == null) {
                ExtraForeignKey.$$$reportNull$$$0(1);
            }
            if (refTable == null) {
                ExtraForeignKey.$$$reportNull$$$0(2);
            }
            super(table, refTable);
            this.myFk = fk;
        }

        @Override
        public String getProviderId() {
            return "External";
        }

        @Override
        public String getRefTableName() {
            return ((FkDesc)this.myFk).ref.name;
        }

        @Override
        public String getRefTableSchema() {
            ObjectPath parent2 = ((FkDesc)this.myFk).ref.parent;
            return parent2 == null ? null : parent2.name;
        }

        @Override
        public String getRefTableCatalog() {
            ObjectPath parent2 = ((FkDesc)this.myFk).ref.parent;
            parent2 = parent2 == null ? null : parent2.parent;
            return parent2 == null ? null : parent2.name;
        }

        @NotNull
        public MultiRef<? extends DasTypedObject> getRefColumns() {
            DasTable table = this.getRefTable();
            CasingProvider casingProvider = DbImplUtil.getCasingProvider((DasObject)table);
            MultiRef multiRef = DasUtil.asRef((Iterable)this.myFk.refColumns, (Function)Functions.id(), c2 -> this.resolveColumn(table, (String)c2, casingProvider));
            if (multiRef == null) {
                ExtraForeignKey.$$$reportNull$$$0(3);
            }
            return multiRef;
        }

        protected DasColumn resolveColumn(DasTable table, String c2, CasingProvider casingProvider) {
            if (table == null) {
                return null;
            }
            DasColumn res = (DasColumn)table.getDasChildren(ObjectKind.COLUMN).filter(DbSqlUtil.byName(c2, true, null, casingProvider)).filter(DasColumn.class).first();
            if (res != null) {
                return res;
            }
            return new FakeColumn(table, c2, DataTypeFactory.of("int"));
        }

        @NotNull
        public MultiRef<? extends DasTypedObject> getColumnsRef() {
            CasingProvider casingProvider = DbImplUtil.getCasingProvider((DasObject)this.getTable());
            MultiRef multiRef = DasUtil.asRef((Iterable)this.myFk.columns, (Function)Functions.id(), c2 -> this.resolveColumn(this.getTable(), (String)c2, casingProvider));
            if (multiRef == null) {
                ExtraForeignKey.$$$reportNull$$$0(4);
            }
            return multiRef;
        }

        @Override
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.FOREIGN_KEY;
            if (objectKind == null) {
                ExtraForeignKey.$$$reportNull$$$0(5);
            }
            return objectKind;
        }

        @Override
        @NotNull
        public String getName() {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                ExtraForeignKey.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fk";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refTable";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/ModelExternalData$ExtraForeignKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/ModelExternalData$ExtraForeignKey";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRefColumns";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnsRef";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ExternalRelations
    implements ModelRelationManager.ModelRelationProvider {
        public static final String ID = "External";

        @Override
        public String getId() {
            return ID;
        }

        @Override
        @NotNull
        public JBIterable<DasForeignKey> getForeignKeys(@Nullable Project project, @NotNull DasTable table, @Nullable DasTable target) {
            if (table == null) {
                ExternalRelations.$$$reportNull$$$0(0);
            }
            Dbms dbms = DbImplUtil.getDbms((DasObject)table);
            ObjectPath path = ObjectPaths.of((DasObject)table);
            JBIterable jBIterable = JBIterable.from((Iterable)ModelExternalData.getInstance().myDataByDbms.get((Object)dbms)).append(ExternalRelations.getDataSourceData(project, (DasObject)table)).flatten(d2 -> ExternalRelations.extract(d2.tableSet, path)).filter(fk -> ExternalRelations.isApplicable(fk, table, target)).filterMap(fk -> {
                DasTable refTable = target == null ? (DasTable)ObjectUtils.tryCast((Object)ModelExternalData.resolveSimilar((DasObject)table, ((FkDesc)fk).ref), DasTable.class) : target;
                return refTable == null ? null : new ExtraForeignKey(table, (FkDesc)fk, refTable);
            });
            if (jBIterable == null) {
                ExternalRelations.$$$reportNull$$$0(1);
            }
            return jBIterable;
        }

        private static Iterable<Data> getDataSourceData(@Nullable Project project, @NotNull DasObject object) {
            if (object == null) {
                ExternalRelations.$$$reportNull$$$0(2);
            }
            return project == null ? JBIterable.empty() : ExternalRelations.getDataSources(project, object).filterMap(ds -> ds.getAdditionalJdbcProperties().get(ModelExternalData.EXTERNAL_DATA_PATH)).filterMap(arg_0 -> ExternalRelations.lambda$getDataSourceData$4(ModelExternalData.getInstance(), arg_0));
        }

        private static boolean isApplicable(@NotNull FkDesc fk, @NotNull DasTable table, @Nullable DasTable target) {
            if (fk == null) {
                ExternalRelations.$$$reportNull$$$0(3);
            }
            if (table == null) {
                ExternalRelations.$$$reportNull$$$0(4);
            }
            return target == null || ExternalRelations.matches((DasObject)target, fk.ref);
        }

        private static boolean matches(@NotNull DasObject obj, @NotNull ObjectPath path) {
            if (obj == null) {
                ExternalRelations.$$$reportNull$$$0(5);
            }
            if (path == null) {
                ExternalRelations.$$$reportNull$$$0(6);
            }
            if (!path.name.equals(obj.getName()) || obj.getKind() != path.kind) {
                return false;
            }
            if (path.parent == null) {
                return true;
            }
            DasObject parent2 = obj.getDasParent();
            return parent2 != null && ExternalRelations.matches(parent2, path.parent);
        }

        @NotNull
        protected static JBIterable<FkDesc> extract(MultiMap<ObjectPath, FkDesc> ts, ObjectPath path) {
            JBIterable jBIterable = path == null ? JBIterable.empty() : JBIterable.from((Iterable)ts.get((Object)path)).append(ExternalRelations.extract(ts, ExternalRelations.trimStart(path)));
            if (jBIterable == null) {
                ExternalRelations.$$$reportNull$$$0(7);
            }
            return jBIterable;
        }

        private static ObjectPath trimStart(ObjectPath path) {
            if (path == null || path.parent == null) {
                return null;
            }
            return ObjectPath.create((String)path.name, (ObjectKind)path.kind, (boolean)path.isQuoted(), (String)path.getIdentity(), (ObjectPath)ExternalRelations.trimStart(path.parent));
        }

        @NotNull
        private static JBIterable<LocalDataSource> getDataSources(@NotNull Project project, @NotNull DasObject obj) {
            if (project == null) {
                ExternalRelations.$$$reportNull$$$0(8);
            }
            if (obj == null) {
                ExternalRelations.$$$reportNull$$$0(9);
            }
            if (obj instanceof DbElement) {
                JBIterable jBIterable = JBIterable.of((Object)DbImplUtil.getMaybeLocalDataSource((DasDataSource)((DbElement)obj).getDataSource()));
                if (jBIterable == null) {
                    ExternalRelations.$$$reportNull$$$0(10);
                }
                return jBIterable;
            }
            if (obj instanceof BasicElement) {
                JBIterable jBIterable = JBIterable.of((Object)DbImplUtil.getMaybeLocalDataSource((DasDataSource)DbPsiFacade.getInstance((Project)project).findDataSource(obj)));
                if (jBIterable == null) {
                    ExternalRelations.$$$reportNull$$$0(11);
                }
                return jBIterable;
            }
            if (obj instanceof PsiElement) {
                PsiFile file = ((PsiElement)obj).getContainingFile();
                JBIterable jBIterable = file == null ? JBIterable.empty() : DbSqlUtil.getAppropriateDataSources(file, false, true).filterMap(DbImplUtil::getMaybeLocalDataSource);
                if (jBIterable == null) {
                    ExternalRelations.$$$reportNull$$$0(12);
                }
                return jBIterable;
            }
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                ExternalRelations.$$$reportNull$$$0(13);
            }
            return jBIterable;
        }

        private static /* synthetic */ Data lambda$getDataSourceData$4(ModelExternalData rec$, String x$0) {
            return rec$.getData(x$0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 7: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 7: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: 
                case 7: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/ModelExternalData$ExternalRelations";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fk";
                    break;
                }
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/ModelExternalData$ExternalRelations";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getForeignKeys";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "extract";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataSources";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getForeignKeys";
                    break;
                }
                case 1: 
                case 7: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDataSourceData";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicable";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getDataSources";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 7: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class Data {
        public MultiMap<ObjectPath, FkDesc> tableSet = MultiMap.createSet(ObjectPaths.INSENSITIVE_STRATEGY);
    }

    public static final class FkDesc {
        private final List<String> columns;
        private final ObjectPath ref;
        private final List<String> refColumns;

        public FkDesc(List<String> columns, ObjectPath ref, List<String> refColumns) {
            this.columns = columns;
            this.ref = ref;
            this.refColumns = refColumns;
        }
    }
}

