/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.meta;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.WeakInterner;
import gnu.trove.TObjectHashingStrategy;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicMetaProperty<T> {
    private static final Interner<BasicMetaProperty<?>> ourInterner = new WeakInterner(new TObjectHashingStrategy<BasicMetaProperty<?>>(){

        public int computeHashCode(BasicMetaProperty<?> o) {
            return Objects.hash(o.name, o.def, o.type, o.internal, ((BasicMetaProperty)o).slowGetter, ((BasicMetaProperty)o).slowSetter);
        }

        public boolean equals(BasicMetaProperty<?> o1, BasicMetaProperty<?> o2) {
            if (o1 == o2) {
                return true;
            }
            if (o2 == null || o1.getClass() != o2.getClass()) {
                return false;
            }
            return Objects.equals(o1.name, o2.name) && Objects.equals(o1.def, o2.def) && Objects.equals(o1.type, o2.type) && Objects.equals(o1.internal, o2.internal) && Objects.equals(((BasicMetaProperty)o1).slowGetter, ((BasicMetaProperty)o2).slowGetter) && Objects.equals(((BasicMetaProperty)o1).slowSetter, ((BasicMetaProperty)o2).slowSetter);
        }
    });
    public final String name;
    public final T def;
    public final BasicMetaType<T> type;
    public final MethodHandle getter;
    public final MethodHandle setter;
    public final boolean internal;
    private final Method slowSetter;
    private final Method slowGetter;

    private BasicMetaProperty(String name, T def, BasicMetaType<T> type, Method getter, Method setter, boolean internal) {
        this.name = name;
        this.def = def;
        this.type = type;
        this.internal = internal;
        this.slowGetter = getter;
        this.slowSetter = setter;
        try {
            this.getter = MethodHandles.publicLookup().unreflect(getter);
            this.setter = MethodHandles.publicLookup().unreflect(setter);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    public Class<T> getValueClass() {
        Class clazz = ReflectionUtil.boxType(this.type.valueClass);
        if (clazz == null) {
            BasicMetaProperty.$$$reportNull$$$0(0);
        }
        return clazz;
    }

    @Nullable
    public <U> BasicMetaProperty<U> tryCast(@NotNull Class<U> clazz) {
        if (clazz == null) {
            BasicMetaProperty.$$$reportNull$$$0(1);
        }
        if (clazz.isAssignableFrom(this.getValueClass())) {
            return this;
        }
        return null;
    }

    public void set(@NotNull BasicModElement e, @Nullable T val) {
        if (e == null) {
            BasicMetaProperty.$$$reportNull$$$0(2);
        }
        try {
            this.setter.invoke(e, val);
        }
        catch (Throwable th) {
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)th);
        }
    }

    @Nullable
    public T get(@NotNull BasicElement e) {
        if (e == null) {
            BasicMetaProperty.$$$reportNull$$$0(3);
        }
        try {
            return (T)this.getter.invoke(e);
        }
        catch (Throwable th) {
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)th);
            return null;
        }
    }

    private static <T> BasicMetaProperty<T> intern(BasicMetaProperty<T> prop) {
        return (BasicMetaProperty)ourInterner.intern(prop);
    }

    public static <T> BasicMetaProperty<T> create(@NonNls String name, BasicMetaType<T> type, T def, Class<?> modApi, boolean internal) {
        String getterName = (type.valueClass == Boolean.TYPE ? "is" : "get") + name;
        String setterName = "set" + name;
        return BasicMetaProperty.createImpl(name, type, def, modApi, getterName, setterName, internal);
    }

    @NotNull
    private static <T> BasicMetaProperty<T> createImpl(@NonNls String name, BasicMetaType<T> type, T def, Class<?> modApi, String getterName, String setterName, boolean internal) {
        BasicMetaProperty<T> basicMetaProperty;
        try {
            Method getter = BasicMetaProperty.getBaseMethod(modApi, getterName, new Class[0]);
            Method setter = BasicMetaProperty.getBaseMethod(modApi, setterName, type.valueClass);
            basicMetaProperty = BasicMetaProperty.intern(new BasicMetaProperty<T>(name, def, type, getter, setter, internal));
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError("model error", e);
        }
        if (basicMetaProperty == null) {
            BasicMetaProperty.$$$reportNull$$$0(4);
        }
        return basicMetaProperty;
    }

    @NotNull
    public static BasicMetaProperty<?> fake(@NonNls String name) {
        return BasicMetaProperty.createImpl(name, BasicMetaType.Types.BOOLEAN, false, BasicModElement.class, "isOutdated", "setOutdated", true);
    }

    @NotNull
    protected static <T> Method getBaseMethod(Class<?> modApi, String methodName, Class<T> ... parameterTypes) throws NoSuchMethodException {
        Method method = modApi.getMethod(methodName, parameterTypes);
        Class<?> decl = method.getDeclaringClass();
        for (Class<?> face : decl.getInterfaces()) {
            try {
                return BasicMetaProperty.getBaseMethod(face, methodName, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        Method method2 = method;
        if (method2 == null) {
            BasicMetaProperty.$$$reportNull$$$0(5);
        }
        return method2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/meta/BasicMetaProperty";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/meta/BasicMetaProperty";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseMethod";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "tryCast";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

