/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.ui;

import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.ui.PlanRenderers;
import com.intellij.database.plan.ui.PlanTreeNode;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBTabsPaneImpl;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TabbedPane;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlanView
implements Disposable {
    public static final ColumnInfo<?, ?> OPERATION_COLUMN = new TreeColumnInfo("Operation");
    public static final MyColumnInfo<?> PARAMS_COLUMN = PlanView.col("Params", PlanModel.GenericNode::getExtraInfo);
    public static final MyColumnInfo<?> NUM_ROWS_COLUMN = PlanView.col("Rows", PlanModel.GenericNode::getPlanNumRows);
    public static final MyColumnInfo<? extends Number> ACTUAL_NUM_ROWS_COLUMN = PlanView.col("Actual Rows", PlanModel.GenericNode::getActualNumRows);
    public static final MyColumnInfo<? extends Number> TOTAL_COST_COLUMN = PlanView.col("Total Cost", PlanModel.GenericNode::getTotalCost);
    public static final MyColumnInfo<? extends Number> ACTUAL_TOTAL_TIME_COLUMN = PlanView.col("Actual Total Time", PlanModel.GenericNode::getActualTotalTime);
    public static final MyColumnInfo<? extends Number> STARTUP_COST_COLUMN = PlanView.col("Startup Cost", PlanModel.GenericNode::getStartupCost);
    public static final MyColumnInfo<? extends Number> ACTUAL_STARTUP_TIME_COLUMN = PlanView.col("Actual Startup Time", PlanModel.GenericNode::getActualStartupTime);
    public static final ColumnInfo<?, ?> RAW_DESC_COLUMN = new ColumnInfo<PlanTreeNode, String>("Raw desc"){

        @NotNull
        public String valueOf(PlanTreeNode node) {
            String string = node.getNode().getRawDescription();
            if (string == null) {
                1.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean isCellEditable(PlanTreeNode node) {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/ui/PlanView$1", "valueOf"));
        }
    };
    private final JScrollPane myScrollPane;
    private final TabbedPane myTabs;
    private final JComponent myPanel;
    private final Map<MyColumnInfo<? extends Number>, Pair<Component, Consumer<PlanModel>>> myCharts;
    private final Project myProject;
    private final PlanRenderers.ActionRenderer myTreeRenderer;
    private final ActionToolbarImpl myToolbar;

    private static <T> MyColumnInfo<T> col(@NotNull String title, @NotNull Function<PlanModel.GenericNode, T> value2) {
        if (title == null) {
            PlanView.$$$reportNull$$$0(0);
        }
        if (value2 == null) {
            PlanView.$$$reportNull$$$0(1);
        }
        return new MyColumnInfo(title, value2);
    }

    static ColumnInfo<?, ?>[] columnsFor(@NotNull PlanModel model) {
        if (model == null) {
            PlanView.$$$reportNull$$$0(2);
        }
        ArrayList<Object> res = new ArrayList<Object>();
        res.add(OPERATION_COLUMN);
        res.add(PARAMS_COLUMN);
        if (!model.getUnsupported().contains((Object)PlanModel.Feature.NUM_ROWS)) {
            res.add(NUM_ROWS_COLUMN);
            if (model.isActual()) {
                res.add(ACTUAL_NUM_ROWS_COLUMN);
            }
        }
        if (!model.getUnsupported().contains((Object)PlanModel.Feature.TOTAL_COST)) {
            res.add(TOTAL_COST_COLUMN);
            if (model.isActual()) {
                res.add(ACTUAL_TOTAL_TIME_COLUMN);
            }
        }
        if (!model.getUnsupported().contains((Object)PlanModel.Feature.STARTUP_COST)) {
            res.add(STARTUP_COST_COLUMN);
            if (model.isActual()) {
                res.add(ACTUAL_STARTUP_TIME_COLUMN);
            }
        }
        res.add(RAW_DESC_COLUMN);
        return res.toArray(ColumnInfo.EMPTY_ARRAY);
    }

    private PlanView(@NotNull Project project) {
        if (project == null) {
            PlanView.$$$reportNull$$$0(3);
        }
        this.myCharts = new HashMap<MyColumnInfo<? extends Number>, Pair<Component, Consumer<PlanModel>>>();
        this.myTreeRenderer = new PlanRenderers.ActionRenderer();
        this.myProject = project;
        this.myScrollPane = ScrollPaneFactory.createScrollPane();
        this.myTabs = new JBTabsPaneImpl(project, 3, (Disposable)this);
        ActionGroup group = (ActionGroup)ActionManagerEx.getInstanceEx().getAction("PlanViewGroup");
        this.myToolbar = new ActionToolbarImpl("unknown", group, false);
        BorderLayoutPanel panel2 = new BorderLayoutPanel().addToCenter((Component)this.myTabs.getComponent());
        this.myTabs.insertTab("Operations tree", null, (Component)this.myScrollPane, null, 0);
        panel2.addToLeft((Component)this.myToolbar);
        this.myToolbar.setBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)0, (int)0, (int)1));
        this.myPanel = panel2;
    }

    public void dispose() {
    }

    private static double getRendererWidth(JTable table, boolean header, int i2, int j) {
        TableCellRenderer renderer;
        TableCellRenderer tableCellRenderer = renderer = header ? table.getColumnModel().getColumn(j).getHeaderRenderer() : table.getCellRenderer(i2, j);
        if (renderer == null && header) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        if (renderer == null) {
            return 0.0;
        }
        Object value2 = header ? table.getColumnModel().getColumn(j).getHeaderValue() : table.getModel().getValueAt(i2, j);
        return renderer.getTableCellRendererComponent(table, value2, false, false, i2, j).getPreferredSize().getWidth();
    }

    public void setModel(@Nullable PlanModel model) {
        if (model != null) {
            Object[] columns = PlanView.columnsFor(model);
            final TreeTableView table = new TreeTableView(new ListTreeTableModelOnColumns((TreeNode)PlanTreeNode.create(model.getRoot()), columns));
            table.putClientProperty(PlanView.class, (Object)this);
            table.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 3) {
                        int row = table.rowAtPoint(e.getPoint());
                        int col = table.columnAtPoint(e.getPoint());
                        if (row >= 0 && col >= 0) {
                            table.changeSelection(row, col, false, false);
                        }
                    }
                }
            });
            table.setTreeCellRenderer((TreeCellRenderer)this.myTreeRenderer);
            table.setRootVisible(false);
            this.myScrollPane.setViewportView((Component)table);
            this.myToolbar.setTargetComponent(this.myTabs.getComponent());
            TreeUtil.expandAll((JTree)table.getTree());
            FontMetrics metrics = table.getFontMetrics(table.getFont());
            int minWidth = metrics.stringWidth("XXXX");
            int spacing = metrics.stringWidth("X");
            for (int i2 = 0; i2 < columns.length; ++i2) {
                double size;
                if (columns[i2] == RAW_DESC_COLUMN) {
                    size = metrics.stringWidth("XXXXXXXXXXXX");
                } else {
                    size = table.getColumnModel().getColumn(i2).getMinWidth();
                    int count2 = table.getRowCount();
                    for (int j = 0; j != count2; ++j) {
                        size = Math.max(size, PlanView.getRendererWidth((JTable)table, false, j, i2));
                    }
                    size = Math.max(size, PlanView.getRendererWidth((JTable)table, true, -1, i2) + (double)spacing);
                }
                table.getColumnModel().getColumn(i2).setPreferredWidth((int)size);
                table.getColumnModel().getColumn(i2).setMinWidth(minWidth);
            }
            table.revalidate();
            ActionManager actionManager = ActionManager.getInstance();
            ShowFullAction.INSTANCE.registerCustomShortcutSet(actionManager.getAction("ViewSource").getShortcutSet(), (JComponent)table);
            PopupHandler.installPopupHandler((JComponent)table, (ActionGroup)new DefaultActionGroup(new AnAction[]{ShowFullAction.INSTANCE}), (String)"unknown", (ActionManager)actionManager);
            DataManager.registerDataProvider((JComponent)table, dataId -> {
                if (CommonDataKeys.PROJECT.getName().equals(dataId)) {
                    return this.myProject;
                }
                return null;
            });
            Iterator<Map.Entry<MyColumnInfo<? extends Number>, Pair<Component, Consumer<PlanModel>>>> it2 = this.myCharts.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry<MyColumnInfo<? extends Number>, Pair<Component, Consumer<PlanModel>>> e = it2.next();
                if (ArrayUtil.contains(e.getKey(), (Object[])columns)) {
                    ((Consumer)e.getValue().second).consume((Object)model);
                    continue;
                }
                this.removeTab((Component)e.getValue().first);
                it2.remove();
            }
        } else {
            this.myScrollPane.setViewportView(null);
            this.myToolbar.setTargetComponent(null);
            for (int i3 = this.myTabs.getTabCount(); i3 > 0; --i3) {
                this.myTabs.removeTabAt(i3);
            }
            this.myCharts.clear();
        }
    }

    public void registerChart(MyColumnInfo<? extends Number> column, Component comp, Consumer<PlanModel> updater) {
        this.myTabs.insertTab("Flame chart: " + column.getName(), null, comp, null, -1);
        this.myCharts.put(column, (Pair<Component, Consumer<PlanModel>>)Pair.create((Object)comp, updater));
    }

    public void removeChart(MyColumnInfo<? extends Number> column) {
        Pair<Component, Consumer<PlanModel>> pair = this.myCharts.remove(column);
        this.removeTab(pair == null ? null : (Component)pair.first);
    }

    public boolean hasChart(MyColumnInfo<? extends Number> column) {
        return this.myCharts.containsKey(column);
    }

    private void removeTab(@Nullable Component component) {
        if (component == null) {
            return;
        }
        int c2 = this.myTabs.getTabCount();
        for (int i2 = 0; i2 < c2; ++i2) {
            if (this.myTabs.getComponentAt(i2) != component) continue;
            this.myTabs.removeTabAt(i2);
            break;
        }
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myPanel;
        if (jComponent == null) {
            PlanView.$$$reportNull$$$0(4);
        }
        return jComponent;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myPanel;
        if (jComponent == null) {
            PlanView.$$$reportNull$$$0(5);
        }
        return jComponent;
    }

    @NotNull
    public static PlanView createView(@NotNull Project project) {
        if (project == null) {
            PlanView.$$$reportNull$$$0(6);
        }
        return new PlanView(project);
    }

    @Nullable
    public static PlanView getPlanView(@NotNull DataContext context) {
        if (context == null) {
            PlanView.$$$reportNull$$$0(7);
        }
        TreeTableView table = PlanView.getTreeTable(context);
        return (PlanView)UIUtil.getClientProperty((Object)table, PlanView.class);
    }

    @Nullable
    public static PlanModel.GenericNode contextPlanNode(@NotNull DataContext context) {
        PlanTreeNode node;
        TreeTableView c2;
        if (context == null) {
            PlanView.$$$reportNull$$$0(8);
        }
        Object item = ContainerUtil.getFirstItem((List)((c2 = PlanView.getTreeTable(context)) == null ? null : c2.getSelection()));
        if (c2 != null && item == null) {
            TreeTableTree tree = c2.getTree();
            item = tree.getRowCount() > 0 ? tree.getPathForRow(0).getLastPathComponent() : null;
        }
        return (node = (PlanTreeNode)ObjectUtils.tryCast((Object)item, PlanTreeNode.class)) == null ? null : node.getNode();
    }

    @Nullable
    private static TreeTableView getTreeTable(@NotNull DataContext context) {
        Component data;
        JBTabs pane;
        if (context == null) {
            PlanView.$$$reportNull$$$0(9);
        }
        if ((pane = (JBTabs)ObjectUtils.tryCast((Object)(data = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context)), JBTabs.class)) == null || pane.getTabCount() == 0) {
            return null;
        }
        return (TreeTableView)UIUtil.findComponentOfType((JComponent)pane.getTabAt(0).getComponent(), TreeTableView.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/plan/ui/PlanView";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/plan/ui/PlanView";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "col";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "columnsFor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createView";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPlanView";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "contextPlanNode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTreeTable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyColumnInfo<T>
    extends ColumnInfo<PlanTreeNode, T> {
        private final Function<PlanModel.GenericNode, T> myValue;

        private MyColumnInfo(@NotNull String title, @NotNull Function<PlanModel.GenericNode, T> value2) {
            if (title == null) {
                MyColumnInfo.$$$reportNull$$$0(0);
            }
            if (value2 == null) {
                MyColumnInfo.$$$reportNull$$$0(1);
            }
            super(title);
            this.myValue = value2;
        }

        @Nullable
        public T valueOf(PlanTreeNode node) {
            return (T)this.myValue.fun((Object)node.getNode());
        }

        @Nullable
        public Double doubleValueOf(PlanModel.GenericNode node) {
            Number res = (Number)ObjectUtils.tryCast((Object)this.myValue.fun((Object)node), Number.class);
            return res == null ? null : Double.valueOf(res.doubleValue());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/plan/ui/PlanView$MyColumnInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ShowFullAction
    extends DumbAwareAction {
        private static final AnAction INSTANCE = new ShowFullAction();

        ShowFullAction() {
            super("Show Full");
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            TreeTableView component;
            if (e == null) {
                ShowFullAction.$$$reportNull$$$0(0);
            }
            if ((component = PlanView.getTreeTable(e.getDataContext())) == null) {
                return;
            }
            int col = component.getSelectedColumn();
            int row = component.getSelectedRow();
            if (col < 0 || col >= component.getColumnCount() || row < 0 || row >= component.getRowCount()) {
                return;
            }
            String val = String.valueOf(component.getModel().getValueAt(row, col));
            if (StringUtil.isEmpty((String)val)) {
                return;
            }
            String title = String.valueOf(component.getColumnModel().getColumn(col).getHeaderValue());
            JTextArea text2 = new JTextArea(val);
            text2.setLineWrap(true);
            text2.setEditable(false);
            text2.setSize(new Dimension(200, 200));
            JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)ScrollPaneFactory.createScrollPane((Component)text2, (boolean)true), (JComponent)text2).setShowBorder(true).setResizable(true).setMovable(true).setTitle(title).setRequestFocus(true).setDimensionServiceKey(e.getProject(), "PlanView.ShowFull", false).createPopup();
            popup.showInBestPositionFor(e.getDataContext());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/plan/ui/PlanView$ShowFullAction", "actionPerformed"));
        }
    }
}

