/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.PathsList;
import com.intellij.util.SystemProperties;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleRunConfiguration
extends RunConfigurationBase<Element>
implements RunProfile {
    private static final String PREFER_IPV4 = "java.net.preferIPv4Stack";
    public static final ExtensionPointName<ParamProvider> ADJUSTERS = ExtensionPointName.create((String)"com.intellij.database.processParamProvider");
    public String VM_PARAMETERS;
    public Map<String, String> VM_ENV;
    public DatabaseCredentials CREDENTIALS = DatabaseCredentials.getInstance();

    public void setOptionsFromDataSource(LocalDataSource dataSource2) {
        ParametersList params = new ParametersList();
        params.addParametersString(dataSource2.getVmOptions());
        for (ParamProvider adjuster : (ParamProvider[])ADJUSTERS.getExtensions()) {
            adjuster.populate(params, dataSource2);
        }
        this.VM_PARAMETERS = params.getParametersString();
        this.VM_ENV = new LinkedHashMap<String, String>(dataSource2.getVmEnv());
    }

    @NotNull
    public static ConsoleRunConfiguration newConfiguration(@NotNull Project project) {
        if (project == null) {
            ConsoleRunConfiguration.$$$reportNull$$$0(0);
        }
        return new ConsoleRunConfiguration(project, "Default");
    }

    public ConsoleRunConfiguration(Project project, String name) {
        super(project, null, name);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        throw new UnsupportedOperationException();
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            ConsoleRunConfiguration.$$$reportNull$$$0(1);
        }
        if (env == null) {
            ConsoleRunConfiguration.$$$reportNull$$$0(2);
        }
        if (!(env.getRunnerSettings() instanceof RunContext)) {
            throw new ExecutionException(DatabaseBundle.message((String)"console.run.configuration.no.context.specified", (Object[])new Object[0]));
        }
        return new CommandLineState(env){

            private SimpleJavaParameters createJavaParameters() throws ExecutionException {
                RunContext runContext = (RunContext)Objects.requireNonNull(this.getEnvironment().getRunnerSettings());
                Project project = ConsoleRunConfiguration.this.getProject();
                if (!project.isOpen()) {
                    throw new ExecutionException("Execution cancelled");
                }
                SimpleJavaParameters params = new SimpleJavaParameters();
                params.setCharset(EncodingProjectManager.getInstance((Project)project).getDefaultCharset());
                ParametersList vm = params.getVMParametersList();
                vm.addParametersString(ConsoleRunConfiguration.this.VM_PARAMETERS);
                boolean idePreferIPv4 = Boolean.TRUE.equals(Boolean.valueOf(System.getProperty(ConsoleRunConfiguration.PREFER_IPV4, "false")));
                boolean forced = vm.hasProperty(ConsoleRunConfiguration.PREFER_IPV4);
                if (idePreferIPv4 && !forced) {
                    vm.addProperty(ConsoleRunConfiguration.PREFER_IPV4, "true");
                }
                String hostName = System.getProperty("java.rmi.server.hostname");
                if (!vm.hasProperty("java.rmi.server.hostname") && hostName != null) {
                    vm.addProperty("java.rmi.server.hostname", hostName);
                }
                if (ConsoleRunConfiguration.this.VM_ENV != null) {
                    for (Map.Entry<String, String> entry : ConsoleRunConfiguration.this.VM_ENV.entrySet()) {
                        params.addEnv(entry.getKey(), entry.getValue());
                    }
                }
                runContext.collectClassPath(params.getClassPath());
                Sdk sdk = runContext.getSdk();
                if (sdk != null) {
                    params.setJdk(sdk);
                } else {
                    params.setJdk(new SimpleJavaSdkType().createJdk("tmp", SystemProperties.getJavaHome()));
                }
                params.setWorkingDirectory(PathManager.getBinPath());
                params.setMainClass(runContext.getMainClassName());
                runContext.tuneParams(params);
                params.setUseDynamicClasspath(project);
                return params;
            }

            @NotNull
            public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
                if (executor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (runner == null) {
                    1.$$$reportNull$$$0(1);
                }
                OSProcessHandler processHandler = this.startProcess();
                return new DefaultExecutionResult((ProcessHandler)processHandler);
            }

            @NotNull
            protected OSProcessHandler startProcess() throws ExecutionException {
                SimpleJavaParameters parameters = (SimpleJavaParameters)ReadAction.compute(() -> this.createJavaParameters());
                OSProcessHandler processHandler = new OSProcessHandler(parameters.toCommandLine());
                processHandler.setHasPty(true);
                ProcessTerminatedListener.attach((ProcessHandler)processHandler);
                OSProcessHandler oSProcessHandler = processHandler;
                if (oSProcessHandler == null) {
                    1.$$$reportNull$$$0(2);
                }
                return oSProcessHandler;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "runner";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/ConsoleRunConfiguration$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/ConsoleRunConfiguration$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "startProcess";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "execute";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public ConsoleRunConfiguration clone() {
        ConsoleRunConfiguration result = (ConsoleRunConfiguration)super.clone();
        result.VM_PARAMETERS = this.VM_PARAMETERS;
        result.VM_ENV = this.VM_ENV == null ? null : new LinkedHashMap<String, String>(this.VM_ENV);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/run/ConsoleRunConfiguration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "newConfiguration";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface RunContext
    extends RunnerSettings {
        public String getMainClassName();

        @Nullable
        default public Sdk getSdk() {
            return null;
        }

        public void collectClassPath(PathsList var1) throws ExecutionException;

        default public void tuneParams(@NotNull SimpleJavaParameters params) throws ExecutionException {
            if (params == null) {
                RunContext.$$$reportNull$$$0(0);
            }
        }

        default public void readExternal(Element element2) throws InvalidDataException {
        }

        default public void writeExternal(Element element2) throws WriteExternalException {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/database/run/ConsoleRunConfiguration$RunContext", "tuneParams"));
        }
    }

    public static interface ParamProvider {
        public void populate(@NotNull ParametersList var1, @NotNull LocalDataSource var2);
    }
}

