/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.extensions.ExtractorScripts;
import com.intellij.database.extractors.DataExtractorFactories;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.run.actions.AlignedIconWithTextAction;
import com.intellij.database.run.actions.GridAction;
import com.intellij.database.run.actions.ShowCsvFormatsAction;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseExtractorAction
extends AlignedIconWithTextAction.Group
implements GridAction,
DumbAware {
    public void update(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            ChooseExtractorAction.$$$reportNull$$$0(0);
        }
        boolean enabled = (dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null;
        e.getPresentation().setEnabledAndVisible(enabled);
        if (enabled) {
            ChooseExtractorAction.updateText(ChooseExtractorAction.getCurrentExtractorName(dataGrid), e.getPresentation(), "");
        }
    }

    @NotNull
    private static String getCurrentExtractorName(@NotNull DataGrid grid) {
        if (grid == null) {
            ChooseExtractorAction.$$$reportNull$$$0(1);
        }
        String string = DataExtractorFactories.getBeautifulExtractorName(grid.getExtractorFactory());
        if (string == null) {
            ChooseExtractorAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static void updateText(@NotNull String name, @NotNull Presentation presentation, @NotNull String prefix) {
        if (name == null) {
            ChooseExtractorAction.$$$reportNull$$$0(3);
        }
        if (presentation == null) {
            ChooseExtractorAction.$$$reportNull$$$0(4);
        }
        if (prefix == null) {
            ChooseExtractorAction.$$$reportNull$$$0(5);
        }
        String newText = prefix + StringUtil.escapeMnemonics((String)StringUtil.firstLast((String)name, (int)12));
        presentation.setText(newText);
        JComponent c2 = (JComponent)presentation.getClientProperty(COMPONENT_KEY);
        if (c2 != null) {
            c2.setToolTipText(name);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ChooseExtractorAction.$$$reportNull$$$0(6);
        }
        if ((project = ChooseExtractorAction.getEventProject((AnActionEvent)e)) == null) {
            return;
        }
        DataGrid dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        final Presentation presentation = e.getPresentation();
        JComponent button = (JComponent)presentation.getClientProperty(COMPONENT_KEY);
        if (dataGrid == null) {
            return;
        }
        ChooserGroup actionGroup = new ChooserGroup(){

            @Override
            protected void extractorSelected(@NotNull DataGrid grid, @NotNull DataExtractorFactory.Text factory) {
                if (grid == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (factory == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.extractorSelected(grid, factory);
                ChooseExtractorAction.updateText(DataExtractorFactories.getBeautifulExtractorName(factory), presentation, "");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "grid";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "factory";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/run/actions/ChooseExtractorAction$1";
                objectArray[2] = "extractorSelected";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(DatabaseBundle.message((String)"settings.ChooseExtractorAction.title", (Object[])new Object[0]), (ActionGroup)actionGroup, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
        popup.setAdText(this.toHtml(DatabaseBundle.message((String)"settings.extractors.PopupAd", (Object[])new Object[0])), 2);
        if (button != null) {
            popup.showUnderneathOf((Component)button);
        } else {
            popup.showInBestPositionFor(e.getDataContext());
        }
    }

    @NotNull
    protected String toHtml(@NotNull String text2) {
        if (text2 == null) {
            ChooseExtractorAction.$$$reportNull$$$0(7);
        }
        String string = "<html>" + text2.replaceAll("\n", "<br>") + "</html>";
        if (string == null) {
            ChooseExtractorAction.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ChooseExtractorAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ChooseExtractorAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentExtractorName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toHtml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentExtractorName";
                break;
            }
            case 2: 
            case 8: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toHtml";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ChooserGroup
    extends ActionGroup
    implements DumbAware {
        public void update(@NotNull AnActionEvent e) {
            DataGrid dataGrid;
            if (e == null) {
                ChooserGroup.$$$reportNull$$$0(0);
            }
            if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
                return;
            }
            ChooseExtractorAction.updateText(ChooseExtractorAction.getCurrentExtractorName(dataGrid), e.getPresentation(), this.getTemplatePresentation().getText() + ": ");
        }

        public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
            DataGrid dataGrid;
            DataGrid dataGrid2 = dataGrid = e == null ? null : (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
            if (dataGrid == null) {
                if (EMPTY_ARRAY == null) {
                    ChooserGroup.$$$reportNull$$$0(1);
                }
                return EMPTY_ARRAY;
            }
            return ChooserGroup.getActions((Function<DataExtractorFactory.Text, ? extends AnAction>)new Function<DataExtractorFactory.Text, AnAction>(){
                private final String mySelectedFactoryId;
                private boolean mySelectionIsSet;
                {
                    this.mySelectedFactoryId = dataGrid.getExtractorFactory().getId();
                }

                public AnAction fun(DataExtractorFactory.Text factory) {
                    String id = factory.getId();
                    boolean selected = !this.mySelectionIsSet && id.equals(this.mySelectedFactoryId);
                    this.mySelectionIsSet |= selected;
                    return new SelectExtractorFactoryAction(factory, selected);
                }
            });
        }

        protected void extractorSelected(@NotNull DataGrid grid, @NotNull DataExtractorFactory.Text factory) {
            if (grid == null) {
                ChooserGroup.$$$reportNull$$$0(2);
            }
            if (factory == null) {
                ChooserGroup.$$$reportNull$$$0(3);
            }
            grid.setExtractorFactory(factory);
        }

        public static AnAction @NotNull [] getActions(@NotNull Function<DataExtractorFactory.Text, ? extends AnAction> wrapExtractorToAction) {
            if (wrapExtractorToAction == null) {
                ChooserGroup.$$$reportNull$$$0(4);
            }
            ArrayList<Object> actions = new ArrayList<Object>();
            actions.add(Separator.create((String)DatabaseBundle.message((String)"settings.extractors.BuiltIn", (Object[])new Object[0])));
            actions.addAll(ContainerUtil.mapNotNull((Collection)ContainerUtil.filterIsInstance(DataExtractorFactories.getLegacy(), DataExtractorFactory.Text.class), wrapExtractorToAction));
            actions.add(Separator.create((String)DatabaseBundle.message((String)"settings.extractors.CSV", (Object[])new Object[0])));
            actions.addAll(ContainerUtil.mapNotNull(DataExtractorFactories.getCsvFormats(), wrapExtractorToAction));
            actions.add(Separator.create((String)DatabaseBundle.message((String)"settings.extractors.ScriptExtractors", (Object[])new Object[0])));
            List scripts = DataExtractorFactories.getScripts();
            scripts = ContainerUtil.sorted(scripts, Comparator.comparing(s -> StringUtil.toLowerCase((String)s.getName())));
            actions.addAll(ContainerUtil.mapNotNull((Collection)scripts, wrapExtractorToAction));
            actions.add(Separator.getInstance());
            actions.add((Object)new ShowCsvFormatsAction.ForExport());
            actions.add((Object)new GoToScriptsDirectoryAction());
            AnAction[] anActionArray = actions.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                ChooserGroup.$$$reportNull$$$0(5);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/ChooseExtractorAction$ChooserGroup";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrapExtractorToAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/ChooseExtractorAction$ChooserGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: 
                case 5: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "extractorSelected";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getActions";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class GoToScriptsDirectoryAction
        extends DumbAwareAction {
            GoToScriptsDirectoryAction() {
                super(DatabaseBundle.message((String)"action.GoToScriptsDirectory.text", (Object[])new Object[0]));
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    GoToScriptsDirectoryAction.$$$reportNull$$$0(0);
                }
                Project project = e.getProject();
                e.getPresentation().setEnabledAndVisible(project != null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    GoToScriptsDirectoryAction.$$$reportNull$$$0(1);
                }
                Project project = e.getProject();
                File scriptsDir = ExtractorScripts.getScriptsDirectory();
                if (project == null || scriptsDir == null) {
                    return;
                }
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(scriptsDir);
                if (virtualFile == null) {
                    return;
                }
                PsiNavigationSupport.getInstance().createNavigatable(project, virtualFile, -1).navigate(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/database/run/actions/ChooseExtractorAction$ChooserGroup$GoToScriptsDirectoryAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class SelectExtractorFactoryAction
        extends ToggleAction
        implements DumbAware {
            private final DataExtractorFactory.Text myExtractorFactory;
            private final boolean mySelected;

            private SelectExtractorFactoryAction(DataExtractorFactory.Text factory, boolean selected) {
                if (factory == null) {
                    SelectExtractorFactoryAction.$$$reportNull$$$0(0);
                }
                super(DataExtractorFactories.getBeautifulExtractorName(factory));
                this.myExtractorFactory = factory;
                this.mySelected = selected;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    SelectExtractorFactoryAction.$$$reportNull$$$0(1);
                }
                return this.mySelected;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                DataGrid dataGrid;
                if (e == null) {
                    SelectExtractorFactoryAction.$$$reportNull$$$0(2);
                }
                if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null) {
                    ChooserGroup.this.extractorSelected(dataGrid, this.myExtractorFactory);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "factory";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/run/actions/ChooseExtractorAction$ChooserGroup$SelectExtractorFactoryAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

