/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.actions.QueryActionBase;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.dump.DumpHandler;
import com.intellij.database.dump.ExtractionHelper;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtil;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DumpAction {
    private final ExtractionConfig myConfig;

    public DumpAction(@NotNull ExtractionConfig config) {
        if (config == null) {
            DumpAction.$$$reportNull$$$0(0);
        }
        this.myConfig = config;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DumpHandler<?> handler;
        if (e == null) {
            DumpAction.$$$reportNull$$$0(1);
        }
        if ((handler = DumpAction.createHandler(e, this.createHelper(), this.myConfig)) == null) {
            return;
        }
        handler.performDump(e.getDataContext());
    }

    @Nullable
    public static DumpHandler<?> createHandler(@NotNull AnActionEvent e, ExtractionHelper manager, @NotNull ExtractionConfig config) {
        if (e == null) {
            DumpAction.$$$reportNull$$$0(2);
        }
        if (config == null) {
            DumpAction.$$$reportNull$$$0(3);
        }
        Project project = e.getProject();
        Object source = DumpAction.getDumpSource(e);
        if (project == null || source == null) {
            return null;
        }
        return source instanceof ConsoleSource ? DumpAction.createConsoleHandler((ConsoleSource)source, manager, config) : (source instanceof DataGrid ? new DumpHandler.GridHandler(project, (DataGrid)source, manager, config) : new DumpHandler.DatabaseViewHandler(project, (JBIterable<DbTable>)((JBIterable)source), manager, config));
    }

    @Nullable
    private static DumpHandler<?> createConsoleHandler(@NotNull ConsoleSource source, @NotNull ExtractionHelper manager, @NotNull ExtractionConfig config) {
        if (source == null) {
            DumpAction.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            DumpAction.$$$reportNull$$$0(5);
        }
        if (config == null) {
            DumpAction.$$$reportNull$$$0(6);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        if (!source.console.beforeExecuteQueries(source.model)) {
            return null;
        }
        List<String> queries = DumpAction.getQueries(source);
        Project project = source.console.getProject();
        return queries.isEmpty() ? null : new DumpHandler.ConsoleHandler(project, (JBIterable<String>)JBIterable.from(queries), source.console, manager, config);
    }

    @NotNull
    public static List<String> getQueries(@NotNull ConsoleSource source) {
        if (source == null) {
            DumpAction.$$$reportNull$$$0(7);
        }
        List list = source.model.statements().transform(it2 -> it2.text(source.console.getPStorage(), Conditions.alwaysFalse())).toList();
        if (list == null) {
            DumpAction.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    public static Object getDumpSource(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            DumpAction.$$$reportNull$$$0(9);
        }
        if ((dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null) {
            return dataGrid.isReady() && !dataGrid.isEmpty() && !dataGrid.isEditing() ? dataGrid : null;
        }
        JdbcConsole console = JdbcConsole.findConsole(e);
        JdbcConsoleProvider.Info info = QueryActionBase.getInfoClassic(e, DatabaseSettings.getDefaultExecOption());
        if (console != null && info != null) {
            return new ConsoleSource(console, DumpAction.getAdjustedScriptModel(info));
        }
        JBIterable<DbElement> elements = DatabaseView.getSelectedElements(e.getDataContext(), (Condition<? super DatabaseStructure.Group>)((Condition)o -> o instanceof DatabaseStructure.FamilyGroup && DbImplUtil.isDataTable(((DatabaseStructure.FamilyGroup)((Object)o)).getChildrenKind())));
        JBIterable<DbTable> tables = DumpAction.getTables(elements);
        return tables.isEmpty() ? null : tables;
    }

    @NotNull
    private static ScriptModel<?> getAdjustedScriptModel(@NotNull JdbcConsoleProvider.Info info) {
        if (info == null) {
            DumpAction.$$$reportNull$$$0(10);
        }
        TextRange range = ScriptModelUtil.getSelectionForConsole((Editor)info.editor, info.execOption);
        TextRange adjusted = ScriptModelUtil.adjustSelectionRange(info.model, (Document)info.editor.getDocument(), range, info.execOption);
        ScriptModel scriptModel = info.model.subModel(adjusted);
        if (scriptModel == null) {
            DumpAction.$$$reportNull$$$0(11);
        }
        return scriptModel;
    }

    @NotNull
    private static JBIterable<DbTable> getTables(@NotNull JBIterable<DbElement> elements) {
        Set sources;
        List canConnectSources;
        if (elements == null) {
            DumpAction.$$$reportNull$$$0(12);
        }
        JBIterable jBIterable = (canConnectSources = ContainerUtil.filter((Collection)(sources = elements.map(e -> e.getDataSource()).toSet()), DbImplUtil::canConnectTo)).isEmpty() ? JBIterable.empty() : ((JBTreeTraverser)((JBTreeTraverser)DasUtil.dasTraverser().withRoots(elements)).expand(Conditions.not((Condition)DasUtil.byClass(DasSchemaChild.class)))).filter(DbTable.class).filter(e -> canConnectSources.contains(e.getDataSource()));
        if (jBIterable == null) {
            DumpAction.$$$reportNull$$$0(13);
        }
        return jBIterable;
    }

    @NotNull
    public abstract ExtractionHelper createHelper();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/DumpAction";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/DumpAction";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueries";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdjustedScriptModel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleHandler";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getQueries";
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDumpSource";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAdjustedScriptModel";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTables";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ConsoleSource {
        final JdbcConsole console;
        final ScriptModel<?> model;

        public ConsoleSource(@NotNull JdbcConsole console, @NotNull ScriptModel<?> model) {
            if (console == null) {
                ConsoleSource.$$$reportNull$$$0(0);
            }
            if (model == null) {
                ConsoleSource.$$$reportNull$$$0(1);
            }
            this.console = console;
            this.model = model;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "console";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/DumpAction$ConsoleSource";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ToFile
    extends DumpAction {
        private final File myFile;

        public ToFile(@NotNull ExtractionConfig config, @NotNull File file) {
            if (config == null) {
                ToFile.$$$reportNull$$$0(0);
            }
            if (file == null) {
                ToFile.$$$reportNull$$$0(1);
            }
            super(config);
            this.myFile = file;
        }

        @Override
        @NotNull
        public ExtractionHelper createHelper() {
            return new ExtractionHelper.FileExtractionHelper(this.myFile);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "config";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/actions/DumpAction$ToFile";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ToClipboard
    extends DumpAction {
        public ToClipboard(@NotNull ExtractionConfig config) {
            if (config == null) {
                ToClipboard.$$$reportNull$$$0(0);
            }
            super(config);
        }

        @Override
        @NotNull
        public ExtractionHelper createHelper() {
            return new ExtractionHelper.ClipboardExtractionHelper();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/database/run/actions/DumpAction$ToClipboard", "<init>"));
        }
    }
}

