/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.ResultView;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public interface GridScrollPositionManager {
    public static final String SCROLL_POSITION_MANAGER_KEY = "GridScrollPositionManager";

    public void scrollSelectionToVisible();

    @NotNull
    public static GridScrollPositionManager get(@NotNull ResultView resultView, @NotNull DataGrid grid) {
        GridScrollPositionManager manager;
        if (resultView == null) {
            GridScrollPositionManager.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            GridScrollPositionManager.$$$reportNull$$$0(1);
        }
        return (manager = (GridScrollPositionManager)ObjectUtils.tryCast((Object)resultView.getComponent().getClientProperty(SCROLL_POSITION_MANAGER_KEY), GridScrollPositionManager.class)) != null ? manager : new DummyScrollPositionManager(grid);
    }

    public GridScrollPosition store();

    public void restore(@NotNull GridScrollPosition var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "resultView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "grid";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/run/ui/grid/GridScrollPositionManager";
        objectArray[2] = "get";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DummyScrollPositionManager
    implements GridScrollPositionManager {
        private final DataGrid myGrid;

        DummyScrollPositionManager(@NotNull DataGrid grid) {
            if (grid == null) {
                DummyScrollPositionManager.$$$reportNull$$$0(0);
            }
            this.myGrid = grid;
        }

        @Override
        public void scrollSelectionToVisible() {
        }

        @Override
        public GridScrollPosition store() {
            return new GridScrollPosition(ModelIndex.forRow(this.myGrid, -1), ModelIndex.forColumn(this.myGrid, -1));
        }

        @Override
        public void restore(@NotNull GridScrollPosition position) {
            if (position == null) {
                DummyScrollPositionManager.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/grid/GridScrollPositionManager$DummyScrollPositionManager";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "restore";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class GridScrollPosition {
        public final ModelIndex<DataConsumer.Row> myTopRowIdx;
        public final ModelIndex<DataConsumer.Column> myLeftColumnIdx;

        public GridScrollPosition(@NotNull ModelIndex<DataConsumer.Row> topRowIdx, @NotNull ModelIndex<DataConsumer.Column> leftColumnIdx) {
            if (topRowIdx == null) {
                GridScrollPosition.$$$reportNull$$$0(0);
            }
            if (leftColumnIdx == null) {
                GridScrollPosition.$$$reportNull$$$0(1);
            }
            this.myTopRowIdx = topRowIdx;
            this.myLeftColumnIdx = leftColumnIdx;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "topRowIdx";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "leftColumnIdx";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/ui/grid/GridScrollPositionManager$GridScrollPosition";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

