/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.model.DasColumn;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditor;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.textCompletion.TextCompletionProvider;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FormatBasedGridCellEditorFactory
implements GridCellEditorFactory {
    @Override
    @NotNull
    public GridCellEditor createEditor(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column, @Nullable Object object, EventObject initiator) {
        if (grid == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(0);
        }
        if (row == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(1);
        }
        if (column == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(2);
        }
        Project project = DataGridUtil.getProject(grid);
        Formatter baseFormatter = this.getFormat(grid, row, column);
        Formatter formatter = this.makeFormatterLenient(grid) ? new LenientFormatter(baseFormatter) : baseFormatter;
        TextCompletionProvider provider = GridCellEditorsUtil.createCompletionProvider(grid, column);
        ReservedCellValue nullValue = DataGridUtil.getDefaultNullValue(grid, column);
        DasColumn dasColumn = DataGridUtil.getDatabaseColumn(grid, column);
        NullCompletionProvider resultProvider = new NullCompletionProvider(dasColumn, provider);
        FormatBasedGridCellEditor formatBasedGridCellEditor = this.createEditorImpl(project, grid, formatter, object, nullValue, initiator, resultProvider, column);
        if (formatBasedGridCellEditor == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(3);
        }
        return formatBasedGridCellEditor;
    }

    @NotNull
    protected abstract Formatter getFormat(@NotNull DataGrid var1, @NotNull ModelIndex<DataConsumer.Row> var2, @NotNull ModelIndex<DataConsumer.Column> var3);

    protected boolean makeFormatterLenient(@NotNull DataGrid grid) {
        if (grid == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(4);
        }
        Dbms dbms = DataGridUtil.getDbms(grid);
        return dbms.isSqlite();
    }

    @NotNull
    protected FormatBasedGridCellEditor createEditorImpl(@NotNull Project project, @NotNull DataGrid grid, @NotNull Formatter format, @Nullable Object value2, @Nullable ReservedCellValue nullValue, EventObject initiator, @Nullable TextCompletionProvider provider, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (project == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(5);
        }
        if (grid == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(6);
        }
        if (format == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(7);
        }
        if (column == null) {
            FormatBasedGridCellEditorFactory.$$$reportNull$$$0(8);
        }
        return new FormatBasedGridCellEditor(project, grid, format, column, value2, nullValue, initiator, provider);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "makeFormatterLenient";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createEditorImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NullCompletionProvider
    implements TextCompletionProvider {
        private final DasColumn myColumn;
        private final TextCompletionProvider myDelegate;

        NullCompletionProvider(@Nullable DasColumn column, @Nullable TextCompletionProvider delegate) {
            this.myColumn = column;
            this.myDelegate = delegate;
        }

        @Nullable
        public String getAdvertisement() {
            return this.myDelegate == null ? null : this.myDelegate.getAdvertisement();
        }

        @Nullable
        public String getPrefix(@NotNull String text2, int offset) {
            if (text2 == null) {
                NullCompletionProvider.$$$reportNull$$$0(0);
            }
            return this.myDelegate == null ? null : this.myDelegate.getPrefix(text2, offset);
        }

        @NotNull
        public CompletionResultSet applyPrefixMatcher(@NotNull CompletionResultSet result, @NotNull String prefix) {
            if (result == null) {
                NullCompletionProvider.$$$reportNull$$$0(1);
            }
            if (prefix == null) {
                NullCompletionProvider.$$$reportNull$$$0(2);
            }
            CompletionResultSet completionResultSet = this.myDelegate == null ? result : this.myDelegate.applyPrefixMatcher(result, prefix);
            if (completionResultSet == null) {
                NullCompletionProvider.$$$reportNull$$$0(3);
            }
            return completionResultSet;
        }

        @Nullable
        public CharFilter.Result acceptChar(char c2) {
            return this.myDelegate == null ? null : this.myDelegate.acceptChar(c2);
        }

        public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull String prefix, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                NullCompletionProvider.$$$reportNull$$$0(4);
            }
            if (prefix == null) {
                NullCompletionProvider.$$$reportNull$$$0(5);
            }
            if (result == null) {
                NullCompletionProvider.$$$reportNull$$$0(6);
            }
            if (parameters.getInvocationCount() == 0 && !NullCompletionProvider.isNullPrefix(prefix)) {
                return;
            }
            if (this.myDelegate != null) {
                this.myDelegate.fillCompletionVariants(parameters, prefix, result);
            }
            if (this.myColumn == null || this.myColumn.isNotNull()) {
                return;
            }
            String fileText = parameters.getOriginalFile().getText();
            if (fileText == null || !NullCompletionProvider.isNullPrefix(StringUtil.trim((String)fileText))) {
                return;
            }
            result.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)"null").withCaseSensitivity(false).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE), (double)1.0));
        }

        private static boolean isNullPrefix(@NotNull String trim) {
            if (trim == null) {
                NullCompletionProvider.$$$reportNull$$$0(7);
            }
            return StringUtil.startsWithIgnoreCase((String)"nul", (String)trim);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory$NullCompletionProvider";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trim";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory$NullCompletionProvider";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "applyPrefixMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPrefix";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyPrefixMatcher";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "fillCompletionVariants";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isNullPrefix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class LenientFormatter
    extends Formatter.Wrapper {
        LenientFormatter(@NotNull Formatter formatter) {
            if (formatter == null) {
                LenientFormatter.$$$reportNull$$$0(0);
            }
            super(formatter);
        }

        @Override
        public Object parse(String value2) {
            try {
                return super.parse(value2);
            }
            catch (ParseException parseException) {
                return value2;
            }
        }

        @Override
        public Object parse(String value2, ParsePosition position) {
            Object parsed = super.parse(value2, position);
            if (parsed == null || position.getErrorIndex() != -1) {
                position.setErrorIndex(-1);
                return value2;
            }
            return parsed;
        }

        @Override
        public String format(Object value2) {
            try {
                return super.format(value2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return value2 == null ? null : value2.toString();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formatter", "com/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory$LenientFormatter", "<init>"));
        }
    }
}

