/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlAsteriskSymbol;
import com.intellij.sql.psi.impl.SqlElementDescriptionProvider;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDocumentationProvider
implements DocumentationProvider {
    public String getQuickNavigateInfo(PsiElement element2, PsiElement originalElement) {
        if (element2 instanceof SqlDefinition) {
            SqlDefinition definition = (SqlDefinition)element2;
            String kindName = SqlElementDescriptionProvider.getKindName(definition);
            return kindName + " " + QNameUtil.getQualifiedName((DasObject)definition);
        }
        if (SqlImplUtil.getPomTarget(element2) instanceof BuiltinFunction) {
            return ((BuiltinFunction)Objects.requireNonNull(SqlImplUtil.getPomTarget(element2))).getName();
        }
        return null;
    }

    public String generateDoc(PsiElement element2, PsiElement originalElement) {
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe(element2);
        if (element2 instanceof SqlDefinition) {
            PsiElement textElement = element2.getParent() instanceof SqlAlterInstruction ? element2.getParent() : element2;
            SqlDefinition definition = (SqlDefinition)element2;
            String kindName = SqlElementDescriptionProvider.getKindName(definition);
            return kindName + " <b>" + QNameUtil.getQualifiedName((DasObject)definition) + "</b><br><pre><code>" + DbSqlUtil.sql2Html(element2.getProject(), (Language)dialect, (CharSequence)ObjectUtils.notNull((Object)textElement.getText(), (Object)"")) + "</code></pre>";
        }
        if (SqlImplUtil.getPomTarget(element2) instanceof SqlFunctionDefinition && originalElement != null) {
            Class<?> dialectClass = originalElement.getContainingFile().getLanguage().getClass();
            SqlFunctionCallExpression call = (SqlFunctionCallExpression)PsiTreeUtil.getParentOfType((PsiElement)originalElement, SqlFunctionCallExpression.class);
            SqlFunctionDefinition.Prototype prototype = call == null ? null : SqlFunctionsUtil.chooseTheBestPrototype(call, false);
            return SqlDocumentationProvider.getDocumentation((SqlFunctionDefinition)Objects.requireNonNull(SqlImplUtil.getPomTarget(element2)), prototype, dialectClass);
        }
        if (SqlImplUtil.isAsteriskRef(element2)) {
            return SqlDocumentationProvider.generateAsteriskDocumentation(element2, dialect);
        }
        return null;
    }

    @Nullable
    private static String generateAsteriskDocumentation(PsiElement element2, SqlLanguageDialectEx dialect) {
        ResolveResult result = ((SqlReferenceExpression)element2).resolveSingle();
        PomTarget target = SqlImplUtil.getPomTarget(SqlImplUtil.getImmediateTarget(result));
        if (!(target instanceof SqlAsteriskSymbol)) {
            return null;
        }
        SqlTableType type = ((SqlAsteriskSymbol)target).getTableType();
        int columnCount = type.getColumnCount();
        NamingService namingService = NamingServices.getNamingService(dialect.getDbms());
        StringBuilder builder = new StringBuilder();
        builder.append("<pre><code>");
        for (int i2 = 0; i2 < columnCount; ++i2) {
            String columnName = type.getColumnName(i2);
            if (type.isColumnQuoted(i2)) {
                columnName = namingService.enquoteName(columnName);
            }
            String columnText = columnName + " " + type.getColumnType(i2).getDataType().getSpecification();
            if (i2 > 0) {
                builder.append(",\n");
            }
            builder.append(DbSqlUtil.sql2Html(element2.getProject(), (Language)dialect, columnText));
        }
        builder.append("</code></pre>");
        return builder.toString();
    }

    @Nullable
    public static String getDocumentation(@NotNull SqlFunctionDefinition definition, @Nullable SqlFunctionDefinition.Prototype prototype, @NotNull Class<? extends Language> dialectClass) {
        if (definition == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (dialectClass == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(1);
        }
        int prototypeId = prototype == null ? 0 : prototype.getPrototypeId();
        String name = definition.getAliasedFunction();
        String basePath = "functions/" + name.replace('@', '_');
        if (prototypeId > 0) {
            try {
                return SqlDialectImplUtil.getDialectHelpResource(dialectClass, basePath + "-" + prototypeId + ".html");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            return SqlDialectImplUtil.getDialectHelpResource(dialectClass, basePath + ".html");
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element2) {
        if (object instanceof SqlFunctionDefinition.Prototype) {
            return PomService.convertToPsi((Project)psiManager.getProject(), (PomTarget)((SqlFunctionDefinition.Prototype)object).getFunction());
        }
        return null;
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement, int targetOffset) {
        if (editor == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(3);
        }
        PsiReference ref = TargetElementUtil.findReference((Editor)editor, (int)(contextElement == null ? targetOffset : contextElement.getTextOffset()));
        return (PsiElement)SqlDocumentationProvider.findRelatedDbElements(ref, null).filter(DbImplUtil.CAN_CONNECT_TO).first();
    }

    @NotNull
    public static JBIterable<DbElement> findRelatedDbElements(@Nullable PsiElement o, boolean strict) {
        if (o == null || !o.isValid()) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlDocumentationProvider.$$$reportNull$$$0(4);
            }
            return jBIterable;
        }
        if (o instanceof DbElement) {
            JBIterable jBIterable = JBIterable.of((Object)((DbElement)o));
            if (jBIterable == null) {
                SqlDocumentationProvider.$$$reportNull$$$0(5);
            }
            return jBIterable;
        }
        JBIterable parents2 = strict ? JBIterable.of((Object)o) : SyntaxTraverser.psiApi().parents((Object)o);
        SqlReferenceExpression ref = (SqlReferenceExpression)parents2.filter(SqlReferenceExpression.class).first();
        DbDataSource dataSource2 = null;
        DbElement element2 = null;
        if (!strict) {
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)o);
            dataSource2 = DbImplUtil.findDataSource(o.getProject(), file);
            element2 = DbImplUtil.findElement(o.getProject(), file);
        }
        JBIterable<DbElement> result1 = ref != null ? SqlDocumentationProvider.findRelatedDbElements((PsiReference)ref.getReference(), null) : JBIterable.empty();
        JBIterable result2 = parents2.filter(SqlDefinition.class).filter(SqlDefinition.class).flatMap(parentDef -> SqlDocumentationProvider.findRelatedDbElements(null, parentDef));
        JBIterable jBIterable = result1.append((Iterable)result2).append((Object)element2).append((Object)dataSource2).unique();
        if (jBIterable == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<DbElement> findRelatedDbElements(@Nullable PsiReference refAt, @Nullable SqlDefinition definition) {
        if (!(refAt instanceof PsiPolyVariantReference) && definition == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlDocumentationProvider.$$$reportNull$$$0(7);
            }
            return jBIterable;
        }
        JBIterable result = (JBIterable)RecursionManager.doPreventingRecursion((Object)ObjectUtils.coalesce((Object)refAt, (Object)definition), (boolean)false, () -> {
            if (refAt instanceof PsiPolyVariantReference) {
                return SqlDocumentationProvider.findRelatedDbElementsImpl((PsiPolyVariantReference)refAt);
            }
            return SqlDocumentationProvider.findRelatedDbElementsImpl(definition);
        });
        JBIterable jBIterable = result != null ? result : JBIterable.empty();
        if (jBIterable == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<DbElement> findRelatedDbElementsImpl(@NotNull PsiPolyVariantReference refAt) {
        if (refAt == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(9);
        }
        JBIterable jBIterable = JBIterable.of((Object[])refAt.multiResolve(false)).flatMap(rr -> {
            PsiElement element2 = rr.getElement();
            if (element2 instanceof DbElement) {
                return JBIterable.of((Object)element2);
            }
            if (!(element2 instanceof SqlDefinition)) {
                return JBIterable.empty();
            }
            return SqlDocumentationProvider.findRelatedDbElementsImpl((SqlDefinition)element2);
        }).filter(DbElement.class);
        if (jBIterable == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(10);
        }
        return jBIterable;
    }

    @NotNull
    private static JBIterable<DbElement> findRelatedDbElementsImpl(@NotNull SqlDefinition definition) {
        if (definition == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(11);
        }
        ObjectKind kind = definition.getKind();
        SqlNameElement element2 = definition.getNameElement();
        if (element2 == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlDocumentationProvider.$$$reportNull$$$0(12);
            }
            return jBIterable;
        }
        SqlReferenceElementType refType = element2 instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element2).getReferenceElementType() : (kind == ObjectKind.COLUMN ? SqlCompositeElementTypes.SQL_COLUMN_REFERENCE : SqlCompositeElementTypes.SQL_REFERENCE);
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)element2);
        String refText = InjectedLanguageManager.getInstance((Project)definition.getProject()).getUnescapedText((PsiElement)element2);
        SqlReferenceExpression newRef = SqlPsiElementFactory.createReferenceFromText(refText, dialect, refType, (PsiElement)element2);
        if (newRef == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlDocumentationProvider.$$$reportNull$$$0(13);
            }
            return jBIterable;
        }
        JBIterable result = JBIterable.of((Object[])newRef.multiResolve(false)).transform(rr -> rr.getElement()).filter(DbElement.class);
        if (result.isNotEmpty()) {
            JBIterable jBIterable = result;
            if (jBIterable == null) {
                SqlDocumentationProvider.$$$reportNull$$$0(14);
            }
            return jBIterable;
        }
        DasObject parent2 = definition.getDasParent();
        JBIterable parentDefinitions = parent2 instanceof SqlFileImpl.FakeDefinition ? ((SqlFileImpl.FakeDefinition)parent2).delegates() : JBIterable.of((Object)ObjectUtils.tryCast((Object)parent2, SqlDefinition.class));
        JBIterable jBIterable = parentDefinitions.flatten(parentDef -> SqlDocumentationProvider.findRelatedDbElementsImpl(parentDef).flatMap(db -> {
            SqlReferenceExpression ref = SqlPsiElementFactory.createReferenceFromText(refText, dialect, refType, (PsiElement)db);
            return SqlDocumentationProvider.findRelatedDbElementsImpl((PsiPolyVariantReference)Objects.requireNonNull(ref).getReference());
        }));
        if (jBIterable == null) {
            SqlDocumentationProvider.$$$reportNull$$$0(15);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/SqlDocumentationProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/SqlDocumentationProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findRelatedDbElements";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findRelatedDbElementsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCustomDocumentationElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findRelatedDbElementsImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

