/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.TrigTurn;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.SqlWhenClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlTriggerStub;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCreateTriggerStatementImpl
extends SqlStubbedDefinitionImpl<SqlTriggerStub>
implements SqlCreateTriggerStatement {
    public SqlCreateTriggerStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            SqlCreateTriggerStatementImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public SqlCreateTriggerStatementImpl(SqlTriggerStub stub) {
        super(stub, SqlCompositeElementTypes.SQL_CREATE_TRIGGER_STATEMENT);
    }

    @Override
    public void accept(SqlVisitor visitor2) {
        visitor2.visitSqlCreateTriggerStatement((SqlCreateTriggerStatement)this);
    }

    public SqlReferenceExpression getTargetContextExpression() {
        SqlTriggerStub stub = (SqlTriggerStub)this.getStub();
        if (stub != null) {
            return stub.getTableReference();
        }
        SqlOnTargetClauseImpl target = (SqlOnTargetClauseImpl)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_ON_TARGET_CLAUSE);
        return target == null ? null : (SqlReferenceExpression)ObjectUtils.tryCast((Object)target.getTargetExpression(), SqlReferenceExpression.class);
    }

    @Override
    public boolean processImplicitContextDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        if (!SqlImplUtil.isProcessingOneOf(processor, ObjectKind.TABLE, ObjectKind.COLUMN)) {
            return true;
        }
        SqlReferenceExpression expression = this.getTargetContextExpression();
        if (lastParent.getParent() == this && expression != null && expression != lastParent) {
            if (!this.processFakeDefinitions(processor, state, lastParent, place)) {
                return false;
            }
            if (lastParent instanceof SqlAsExpression) {
                return false;
            }
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    public DasTable getTable() {
        SqlReferenceExpression ref = this.getTargetContextExpression();
        PsiElement resolve = ref == null ? null : ref.resolve();
        return resolve instanceof DasTable ? (DasTable)resolve : null;
    }

    @Nullable
    public SqlExpression getTriggerProcedure() {
        return null;
    }

    protected boolean processFakeDefinitions(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        return true;
    }

    @NotNull
    public Set<TrigEvent> getEvents() {
        SqlTriggerStub stub = (SqlTriggerStub)this.getStub();
        if (stub != null) {
            Set<TrigEvent> set = Collections.emptySet();
            if (set == null) {
                SqlCreateTriggerStatementImpl.$$$reportNull$$$0(1);
            }
            return set;
        }
        Set<TrigEvent> set = SqlImplUtil.getTriggerEvents((SqlElement)this);
        if (set == null) {
            SqlCreateTriggerStatementImpl.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Nullable
    public TrigTurn getTurn() {
        SqlTriggerStub stub = (SqlTriggerStub)this.getStub();
        if (stub != null) {
            return null;
        }
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        PsiElement gran = (PsiElement)api.children((Object)this).filter(e -> api.typeOf(e) == SqlCompositeElementTypes.SQL_TRIGGER_GRANULARITY_CLAUSE).first();
        boolean forRow = gran != null && !api.children((Object)gran).filter(e -> api.typeOf(e) == SqlCommonKeywords.SQL_ROW).isEmpty();
        PsiElement timeClause = (PsiElement)api.children((Object)this).filter(e -> api.typeOf(e) == SqlCompositeElementTypes.SQL_TRIGGER_TIME_CLAUSE).first();
        if (timeClause == null) {
            return null;
        }
        return (TrigTurn)api.children((Object)timeClause).transform(api.TO_TYPE).transform(e -> SqlCreateTriggerStatementImpl.getTurn(e, forRow)).filter(Conditions.notNull()).first();
    }

    @Nullable
    private static TrigTurn getTurn(IElementType e, boolean row) {
        if (e == SqlCommonKeywords.SQL_INSTEAD) {
            return TrigTurn.INSTEAD_OF;
        }
        if (e == SqlCommonKeywords.SQL_BEFORE) {
            return row ? TrigTurn.BEFORE_ROW : TrigTurn.BEFORE_STMT;
        }
        if (e == SqlCommonKeywords.SQL_AFTER) {
            return row ? TrigTurn.AFTER_ROW : TrigTurn.AFTER_STMT;
        }
        if (e == SqlCommonKeywords.SQL_FOR) {
            return row ? TrigTurn.AFTER_ROW : TrigTurn.AFTER_STMT;
        }
        return null;
    }

    @Nullable
    public String getCondition() {
        SqlTriggerStub stub = (SqlTriggerStub)this.getStub();
        if (stub != null) {
            return null;
        }
        SqlWhenClause whenClause = (SqlWhenClause)PsiTreeUtil.getChildOfType((PsiElement)this, SqlWhenClause.class);
        SqlExpression expr = whenClause != null ? whenClause.getExpression() : null;
        return expr == null ? null : expr.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlCreateTriggerStatementImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

