/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataSourceSnapshotManager;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.ModelNameIndex;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.NameChecker;
import com.intellij.database.util.Version;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.completion.SqlCompletionScopeProcessor;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.psi.JdbcProcedureCall;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlInfoElementType;
import com.intellij.sql.psi.SqlLabelHolder;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlParameterDefinition;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResolveCache;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.psi.impl.SqlAsteriskSymbol;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlLabelDefinitionImpl;
import com.intellij.sql.psi.impl.SqlPositionalReference;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiMiscUtil;
import com.intellij.sql.psi.impl.SqlResolveResultImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.OrderedSet;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlReferenceImpl
implements SqlReference {
    public static final Key<Boolean> IGNORE_DATA_SOURCES = Key.create((String)"IGNORE_DATA_SOURCES");
    @NotNull
    private static final ResolveCache.PolyVariantResolver<SqlReferenceImpl> MY_RESOLVER = (reference, incompleteCode) -> {
        PsiFile file = reference.getElement().getContainingFile();
        if (file instanceof SqlFileImpl && reference.getQualifier() == null) {
            SqlResolveCache cache = ((SqlFileImpl)file).getResolveCache();
            ResolveResult[] result = cache.getResult((PsiReference)reference);
            if (result != null) {
                return result;
            }
            ResolveResult[] computed = reference.resolveInner();
            cache.cacheResult((PsiReference)reference, computed);
            return computed;
        }
        return reference.resolveInner();
    };
    @NotNull
    private static final ResolveCache.AbstractResolver<SqlReferenceImpl, SqlType> MY_TYPE_RESOLVER = (reference, incompleteCode) -> reference.getSqlTypeInner();
    private final SqlElement myElement;

    public SqlReferenceImpl(@NotNull SqlElement element2) {
        if (element2 == null) {
            SqlReferenceImpl.$$$reportNull$$$0(0);
        }
        this.myElement = element2;
    }

    @Nullable
    public SqlExpression getQualifier() {
        return this.getQualifierExpression();
    }

    @Nullable
    public abstract SqlExpression getQualifierExpression();

    @NotNull
    public abstract String getReferenceName();

    @NotNull
    public SqlType getSqlType() {
        SqlType type = (SqlType)ResolveCache.getInstance((Project)this.getElement().getProject()).resolveWithCaching((PsiReference)this, MY_TYPE_RESOLVER, true, false);
        Object object = type == null ? SqlType.UNKNOWN : type;
        if (object == null) {
            SqlReferenceImpl.$$$reportNull$$$0(1);
        }
        return object;
    }

    public boolean resolveStrict() {
        if (SqlPsiMiscUtil.isDropTarget((PsiElement)this.myElement) || SqlPsiMiscUtil.isJoinUsingColumn((PsiElement)this.myElement)) {
            return true;
        }
        SqlSetAssignment assignment = (SqlSetAssignment)ObjectUtils.tryCast((Object)this.myElement.getParent(), SqlSetAssignment.class);
        return PsiTreeUtil.getParentOfType((PsiElement)assignment, SqlUpdateStatement.class) != null && assignment.getLValue() == this.myElement;
    }

    @NotNull
    private SqlType getSqlTypeInner() {
        SqlLanguageDialectEx dialect = this.getSqlDialect();
        PsiElement element2 = this.resolve();
        SqlType sqlType = dialect.getTypeSystem().getSqlType(this, element2);
        if (sqlType == null) {
            SqlReferenceImpl.$$$reportNull$$$0(2);
        }
        return sqlType;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        SqlExpression qual = this.getQualifier();
        if (SqlImplUtil.isAsteriskRef((PsiElement)this.myElement)) {
            PsiElement qualifier = qual instanceof SqlReferenceExpression ? ((SqlReferenceExpression)qual).resolve() : null;
            SqlType sqlType = this.getSqlDialect().getTypeSystem().getSqlType(this, (PsiElement)this.myElement);
            SqlElement immediateTarget = this.myElement;
            if (sqlType instanceof SqlTableType) {
                PsiElement context = ((SqlTableType)sqlType).getTypeElement();
                if (context == null) {
                    context = this.myElement;
                }
                immediateTarget = PomService.convertToPsi((Project)context.getProject(), (PomTarget)new SqlAsteriskSymbol(context, (SqlTableType)sqlType));
            }
            SqlResolveResult[] sqlResolveResultArray = SqlResolveResultImpl.createSingleSqlResults(qualifier, (PsiElement)immediateTarget, (PsiElement)this.myElement);
            if (sqlResolveResultArray == null) {
                SqlReferenceImpl.$$$reportNull$$$0(3);
            }
            return sqlResolveResultArray;
        }
        PsiElement parent2 = this.myElement.getParent();
        if (SqlPsiElementFactory.isROFile(parent2)) {
            parent2 = parent2.getContext();
        }
        if (parent2 instanceof SqlDefinition && ((SqlDefinition)parent2).getNameElement() == this.myElement) {
            SqlResolveResult[] sqlResolveResultArray = SqlResolveResultImpl.createSingleSqlResults(null, parent2, parent2);
            if (sqlResolveResultArray == null) {
                SqlReferenceImpl.$$$reportNull$$$0(4);
            }
            return sqlResolveResultArray;
        }
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)this.getElement().getProject()).resolveWithCaching((PsiPolyVariantReference)this, MY_RESOLVER, true, incompleteCode);
        if (resolveResultArray == null) {
            SqlReferenceImpl.$$$reportNull$$$0(5);
        }
        return resolveResultArray;
    }

    public ResolveResult resolveSingle() {
        ResolveResult[] results2;
        for (ResolveResult result : results2 = this.multiResolve(false)) {
            if (SqlReferenceImpl.isFakeGroup(result)) continue;
            return result;
        }
        return results2.length == 0 ? null : results2[0];
    }

    @Nullable
    public PsiElement resolveImmediate() {
        ResolveResult result = this.resolveSingle();
        PsiElement immediateTarget = result instanceof SqlResolveResult ? ((SqlResolveResult)result).getImmediateTarget() : null;
        return immediateTarget != null ? immediateTarget : this.resolve();
    }

    private static boolean isFakeGroup(ResolveResult res) {
        return SqlFileImpl.isFakeGroup(res.getElement());
    }

    public PsiElement resolve() {
        ResolveResult result = this.resolveSingle();
        return result == null ? null : result.getElement();
    }

    @NotNull
    public PsiElement getElement() {
        SqlElement sqlElement = this.myElement;
        if (sqlElement == null) {
            SqlReferenceImpl.$$$reportNull$$$0(6);
        }
        return sqlElement;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myElement.getText();
        if (string == null) {
            SqlReferenceImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
        if (element2 == null) {
            SqlReferenceImpl.$$$reportNull$$$0(8);
        }
        if (this.isReferenceTo(element2)) {
            return this.myElement;
        }
        if (element2 instanceof PsiNamedElement) {
            return this.handleElementRename(((PsiNamedElement)element2).getName());
        }
        return this.myElement;
    }

    public boolean isReferenceTo(@NotNull PsiElement e1) {
        if (e1 == null) {
            SqlReferenceImpl.$$$reportNull$$$0(9);
        }
        if (SqlReferenceImpl.isEmptyReferenceTo((PsiElement)this.myElement, e1)) {
            return true;
        }
        SqlReferenceElementType refType = this.getReferenceElementType();
        for (ResolveResult result : this.multiResolve(false)) {
            SqlNameElement element2;
            PsiElement e2 = result.getElement();
            if (this.myElement.getManager().areElementsEquivalent(e1, e2)) {
                return true;
            }
            if (refType != SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE || !(e2 instanceof SqlDefinition) || (element2 = ((SqlDefinition)e2).getNameElement()) == null || !SqlReferenceImpl.isEmptyReferenceTo((PsiElement)element2, e1)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEmptyReferenceTo(PsiElement element2, PsiElement e1) {
        PsiElement lastChild;
        PsiElement psiElement = lastChild = element2 instanceof SqlReferenceExpression ? element2.getLastChild() : null;
        if (element2.getFirstChild() == lastChild && lastChild instanceof SqlReferenceExpression) {
            SqlReferenceExpression refExpression = (SqlReferenceExpression)lastChild;
            return refExpression.getReference().isReferenceTo(e1);
        }
        return false;
    }

    @NotNull
    public SqlReferenceElementType getReferenceElementType() {
        ASTNode astNode = this.myElement.getNode();
        IElementType elementType = astNode != null ? astNode.getElementType() : null;
        SqlReferenceElementType sqlReferenceElementType = elementType instanceof SqlReferenceElementType ? (SqlReferenceElementType)elementType : SqlCompositeElementTypes.SQL_REFERENCE;
        if (sqlReferenceElementType == null) {
            SqlReferenceImpl.$$$reportNull$$$0(10);
        }
        return sqlReferenceElementType;
    }

    @NotNull
    public SqlScopeProcessor createResolveProcessor(final @NotNull PairConsumer<PsiElement, ResolveState> consumer2) {
        if (consumer2 == null) {
            SqlReferenceImpl.$$$reportNull$$$0(11);
        }
        String referenceName = this.getReferenceName();
        SqlLanguageDialectEx dialect = this.getSqlDialect();
        List<DbDataSource> dataSources2 = SqlImplUtil.getDataSources((PsiElement)SqlImplUtil.getTopLevelSqlFile(this.myElement.getContainingFile()));
        boolean dontCheckName = StringUtil.isEmpty((String)referenceName) && this.getQualifierExpression() != null;
        boolean quoted = DbSqlUtil.isQuoted((SqlNameElement)ObjectUtils.tryCast((Object)this.getElement(), SqlNameElement.class));
        final NameChecker nameChecker = dontCheckName ? null : new NameChecker(referenceName, quoted, SqlImplUtil.getCasingProvider(dialect, dataSources2), dialect);
        return new SqlScopeProcessor(referenceName, dialect, dataSources2, (PsiElement)this.myElement){
            boolean isEmpty;
            {
                super(referenceName, dialect, dataSources2, place);
                this.isEmpty = true;
            }

            @Override
            public boolean isResultEmpty() {
                return this.isEmpty;
            }

            @Override
            public boolean executeTarget(@Nullable DasObject target, @NotNull PsiElement t, @Nullable SqlType sqlType, Boolean forcedCaseSens, @NotNull ResolveState state) {
                DasObject named;
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                Object object = target != null ? target : (named = t instanceof SqlReferenceExpression ? t : SqlImplUtil.getPomTarget(t));
                if (nameChecker != null && !(SqlReferenceImpl.this.myElement instanceof SqlPositionalReference) && !nameChecker.checkName(named, forcedCaseSens)) {
                    return true;
                }
                if (!this.checkType(ObjectUtils.notNull((Object)target, (Object)t), sqlType)) {
                    return true;
                }
                PsiElement delegate = target instanceof DbElement ? (PsiElement)ObjectUtils.tryCast((Object)((DbElement)target).getDelegate(), PsiElement.class) : null;
                PsiElement targetPsi = (PsiElement)ObjectUtils.chooseNotNull(delegate, (Object)t);
                this.isEmpty = false;
                consumer2.consume((Object)targetPsi, (Object)state);
                return sqlType == null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "t";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/psi/impl/SqlReferenceImpl$1";
                objectArray[2] = "executeTarget";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private static SqlResolveResult findConflictingResult(@NotNull OrderedSet<SqlResolveResult> result, @NotNull PsiElement newTarget) {
        if (result == null) {
            SqlReferenceImpl.$$$reportNull$$$0(12);
        }
        if (newTarget == null) {
            SqlReferenceImpl.$$$reportNull$$$0(13);
        }
        if (newTarget instanceof SqlParameterDefinition) {
            return (SqlResolveResult)ContainerUtil.find(result, r -> r.getElement() instanceof DasColumn);
        }
        return null;
    }

    @NotNull
    private ResolveConflictPolicy getPreference(@NotNull SqlResolveResult currentResult, @NotNull SqlResolveResult newResult) {
        if (currentResult == null) {
            SqlReferenceImpl.$$$reportNull$$$0(14);
        }
        if (newResult == null) {
            SqlReferenceImpl.$$$reportNull$$$0(15);
        }
        Dbms dbms = this.getSqlDialect().getDbms();
        PsiElement newPsi = newResult.getElement();
        PsiElement currentPsi = currentResult.getElement();
        if (currentPsi instanceof DasColumn && newPsi instanceof SqlParameterDefinition) {
            if (dbms.isOracle() || dbms.isHsqldb() || dbms.isDb2()) {
                ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.HIDE_NEW;
                if (resolveConflictPolicy == null) {
                    SqlReferenceImpl.$$$reportNull$$$0(16);
                }
                return resolveConflictPolicy;
            }
            if (dbms.isMysql() || dbms.isSnowflake() || dbms.isGreenplum()) {
                ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.DROP_EXISTING;
                if (resolveConflictPolicy == null) {
                    SqlReferenceImpl.$$$reportNull$$$0(17);
                }
                return resolveConflictPolicy;
            }
            if (dbms == Dbms.POSTGRES) {
                SqlRoutineDefinition routine = (SqlRoutineDefinition)PsiTreeUtil.getParentOfType((PsiElement)newPsi, SqlRoutineDefinition.class);
                if (routine == null) {
                    ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.KEEP_BOTH;
                    if (resolveConflictPolicy == null) {
                        SqlReferenceImpl.$$$reportNull$$$0(18);
                    }
                    return resolveConflictPolicy;
                }
                SqlElement statement = (SqlElement)routine.getBody().first();
                if (statement == null) {
                    ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.KEEP_BOTH;
                    if (resolveConflictPolicy == null) {
                        SqlReferenceImpl.$$$reportNull$$$0(19);
                    }
                    return resolveConflictPolicy;
                }
                for (PsiElement sibling : SqlImplUtil.revSiblings((PsiElement)statement)) {
                    String valueText;
                    PsiElement kind;
                    PsiElement mark2;
                    if (!(sibling instanceof SqlClause) || PsiUtilCore.getElementType((PsiElement)(mark2 = sibling.getFirstChild())) != SqlCommonTokens.SQL_HASHMARK || (kind = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)mark2)) == null || !"variable_conflict".equalsIgnoreCase(kind.getText())) continue;
                    PsiElement value2 = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)kind);
                    String string = valueText = value2 != null ? value2.getText() : null;
                    if ("use_column".equalsIgnoreCase(valueText)) {
                        ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.DROP_NEW;
                        if (resolveConflictPolicy == null) {
                            SqlReferenceImpl.$$$reportNull$$$0(20);
                        }
                        return resolveConflictPolicy;
                    }
                    if (!"use_variable".equalsIgnoreCase(valueText)) continue;
                    ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.DROP_EXISTING;
                    if (resolveConflictPolicy == null) {
                        SqlReferenceImpl.$$$reportNull$$$0(21);
                    }
                    return resolveConflictPolicy;
                }
            }
        }
        ResolveConflictPolicy resolveConflictPolicy = ResolveConflictPolicy.KEEP_BOTH;
        if (resolveConflictPolicy == null) {
            SqlReferenceImpl.$$$reportNull$$$0(22);
        }
        return resolveConflictPolicy;
    }

    private ResolveResult[] resolveInner() {
        OrderedSet result = new OrderedSet();
        SqlScopeProcessor processor = this.createResolveProcessor((PairConsumer<PsiElement, ResolveState>)((PairConsumer)(psi, state) -> {
            SqlResolveResultImpl newResult = new SqlResolveResultImpl(SqlImplUtil.getQualifier(state), SqlImplUtil.getImmediateTarget(state), SqlImplUtil.getImmediateQualifier(state), (PsiElement)psi);
            SqlResolveResult currentResult = SqlReferenceImpl.findConflictingResult((OrderedSet<SqlResolveResult>)result, psi);
            ResolveConflictPolicy preference = currentResult != null ? this.getPreference(currentResult, newResult) : ResolveConflictPolicy.KEEP_BOTH;
            switch (preference) {
                case DROP_EXISTING: {
                    result.remove((Object)currentResult);
                    result.add((Object)newResult);
                    break;
                }
                case DROP_NEW: {
                    break;
                }
                case HIDE_NEW: {
                    result.add((Object)newResult.hide());
                    break;
                }
                case KEEP_BOTH: {
                    result.add((Object)newResult);
                }
            }
        }));
        if (this.initExpectedTargetTypes(processor)) {
            this.processResolveVariants(processor);
        } else {
            result.add((Object)new SqlResolveResultImpl(null, (PsiElement)this.myElement, null, (PsiElement)this.myElement));
        }
        if (this.myElement instanceof SqlPositionalReference) {
            return SqlResolveResultImpl.createSqlResults((Collection<SqlResolveResult>)result);
        }
        if (processor.isResultEmpty()) {
            processor.dialect.processReservedEntitiesWithType(processor.referenceName, (PsiElement)this.myElement, true, processor);
        }
        if (processor.isResultEmpty()) {
            SqlElement setLValue;
            PsiElement parent2 = this.myElement.getParent();
            SqlElement sqlElement = setLValue = parent2 instanceof SqlSetAssignment ? ((SqlSetAssignment)parent2).getLValue() : null;
            if (setLValue instanceof SqlReferenceExpression && ((SqlReferenceExpression)setLValue).getReferenceElementType() == SqlCompositeElementTypes.SQL_SYSTEM_REFERENCE) {
                return SqlResolveResultImpl.createSingleSqlResults(null, this.getElement(), this.getElement());
            }
        }
        return SqlResolveResultImpl.createSqlResults((Collection<SqlResolveResult>)result);
    }

    public boolean isSoft() {
        return false;
    }

    public boolean processResolveVariants(@NotNull SqlScopeProcessor processor) {
        if (processor == null) {
            SqlReferenceImpl.$$$reportNull$$$0(23);
        }
        ResolveState state = ResolveState.initial();
        if (this.getReferenceElementType() == SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE) {
            return this.processLabelBackRef(processor, state);
        }
        SqlExpression qualifierExpression = this.getQualifierExpression();
        if (qualifierExpression == null) {
            return this.processUnqualifiedResolveVariants(processor, state);
        }
        if (qualifierExpression instanceof SqlReferenceExpression && !SqlImplUtil.processQualifier((SqlReferenceExpression)qualifierExpression, processor, state, (PsiElement)this.myElement)) {
            return false;
        }
        if (!processor.dialect.processQualifiedResolve(processor, state, (PsiReference)this, qualifierExpression)) {
            return false;
        }
        if (!SqlImplUtil.processDeclarationsInType(qualifierExpression, (PsiScopeProcessor)processor, state, (PsiElement)this.myElement)) {
            return false;
        }
        if (this.myElement.getParent() instanceof SqlFunctionCallExpression && processor.isResultEmpty()) {
            return this.processFunctionVariants(processor);
        }
        return true;
    }

    protected boolean processLabelBackRef(@NotNull SqlScopeProcessor processor, ResolveState state) {
        SqlElement labeled;
        if (processor == null) {
            SqlReferenceImpl.$$$reportNull$$$0(24);
        }
        if ((labeled = (SqlElement)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, (Class[])new Class[]{SqlProcedureDefinitionImpl.class, SqlStatement.class})) == null) {
            return true;
        }
        if (labeled instanceof DasObject) {
            return processor.execute((PsiElement)labeled, state);
        }
        for (SqlLabelDefinitionImpl def : SqlImplUtil.sqlChildren((PsiElement)labeled).takeWhile(c2 -> !(c2 instanceof SqlStatement)).filter(SqlLabelDefinitionImpl.class)) {
            if (processor.execute((PsiElement)def, state)) continue;
            return false;
        }
        PsiObject parentDef = (PsiObject)ObjectUtils.tryCast((Object)labeled.getParent(), PsiObject.class);
        return parentDef == null || processor.execute((PsiElement)parentDef, state);
    }

    public boolean initExpectedTargetTypes(@NotNull SqlScopeProcessor processor) {
        boolean strict;
        int maxLev;
        if (processor == null) {
            SqlReferenceImpl.$$$reportNull$$$0(25);
        }
        PsiFile containingFile = this.myElement.getContainingFile();
        Set<ObjectKind> set = this.getExpectedTargetTypes(processor.referenceName != null, processor.dialect, -1, maxLev = processor.referenceName != null && containingFile == containingFile.getOriginalFile() ? 0 : -1, strict = this.resolveStrict());
        if (this.shouldNotBeChecked(set)) {
            return false;
        }
        processor.handleEvent(SqlScopeProcessor.EXPECTED_TYPE, set);
        processor.handleEvent(SqlScopeProcessor.STRICT_TYPE, strict);
        return true;
    }

    @NotNull
    public Set<ObjectKind> getExpectedTypes(boolean resolve) {
        PsiFile containingFile = this.myElement.getContainingFile();
        int maxLev = resolve && containingFile == containingFile.getOriginalFile() ? 0 : -1;
        return this.getExpectedTargetTypes(resolve, this.getSqlDialect(), -1, maxLev, this.resolveStrict());
    }

    private boolean shouldNotBeChecked(@NotNull Set<ObjectKind> expectedTypes) {
        Dbms dbms;
        if (expectedTypes == null) {
            SqlReferenceImpl.$$$reportNull$$$0(26);
        }
        SqlLanguageDialectEx dialect = this.getSqlDialect();
        PsiElement parent2 = this.myElement.getParent();
        if (expectedTypes.contains(ObjectKind.ROUTINE) && parent2 != null && parent2.getParent() instanceof JdbcProcedureCall) {
            return true;
        }
        if (expectedTypes.contains(ObjectKind.OBJECT_TYPE) && parent2 instanceof SqlTypeElement && this.getQualifierExpression() == null && PsiTreeUtil.getDeepestFirst((PsiElement)this.myElement).getNode().getElementType() == SqlTokens.SQL_IDENT_DELIMITED && ((dbms = dialect.getDbms()).isTransactSql() || dbms.isPostgres())) {
            String name = this.getReferenceName();
            return !dialect.shouldQuotedTypeReferenceBeChecked(name);
        }
        return false;
    }

    private boolean processFunctionVariants(@NotNull SqlScopeProcessor processor) {
        if (processor == null) {
            SqlReferenceImpl.$$$reportNull$$$0(27);
        }
        SqlLanguageDialectEx dialect = processor.dialect;
        if (processor.referenceName == null || !this.shouldProcessFunctionVariants()) {
            return true;
        }
        PsiElement parent2 = this.myElement.getParent();
        PsiElement target = parent2 instanceof SqlFunctionCallExpression ? parent2 : this.myElement;
        SqlFunctionDefinition builtin = dialect.getSupportedFunctions().get(this.getReferenceName());
        if (builtin != null && dialect.getExpectedFunctionLocations((SqlExpression)ObjectUtils.tryCast((Object)this.myElement, SqlExpression.class)).contains((Object)builtin.getLocation())) {
            String postfixType;
            SqlExpression qualifier = this.getQualifier();
            if (qualifier != null && (postfixType = builtin.getPostfixType()) == null && (!dialect.getDbms().isPostgres() || target instanceof SqlFunctionCallExpression)) {
                return true;
            }
            PsiElement wrapper = PomService.convertToPsi((Project)this.myElement.getProject(), (PomTarget)builtin);
            if (!processor.executeTarget((DasObject)builtin, wrapper, null, dialect.getDbms().isMysql() ? Boolean.valueOf(false) : null, ResolveState.initial())) {
                return false;
            }
        }
        return true;
    }

    private SqlLanguageDialectEx getSqlDialect() {
        return SqlImplUtil.getSqlDialectSafe((PsiElement)this.myElement);
    }

    protected boolean shouldProcessFunctionVariants() {
        return false;
    }

    public boolean processUnqualifiedResolveVariants(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state) {
        boolean includeAllTopLevelNamespaces;
        if (processor == null) {
            SqlReferenceImpl.$$$reportNull$$$0(28);
        }
        if (state == null) {
            SqlReferenceImpl.$$$reportNull$$$0(29);
        }
        if (!this.myElement.isValid()) {
            return true;
        }
        PsiFile containingFile = this.myElement.getContainingFile();
        PsiFile topContainingFile = SqlImplUtil.getTopLevelSqlFile(containingFile);
        PsiFile topOriginalFile = topContainingFile.getOriginalFile();
        if (!processor.dialect.processUnqualifiedResolve(processor, state, (PsiReference)this)) {
            return false;
        }
        PsiElement maxScope = SqlImplUtil.getResolveScope(topContainingFile);
        boolean callableExpected = processor.isExpected(ObjectKind.ROUTINE);
        if (callableExpected && !this.processFunctionVariants(processor)) {
            return false;
        }
        if (!PsiTreeUtil.treeWalkUp((PsiScopeProcessor)processor, (PsiElement)this.myElement, (PsiElement)maxScope, (ResolveState)state)) {
            return false;
        }
        ObjectKind targetType = this.getReferenceElementType().getTargetKind();
        if (targetType == SqlDbElementType.LABEL && !processor.dialect.getDbms().isMysql() && !this.processLabels(processor)) {
            return false;
        }
        if (targetType == ObjectKind.VARIABLE || targetType == SqlDbElementType.LABEL) {
            return true;
        }
        if (!(callableExpected || processor.referenceName != null && !(this.myElement.getParent() instanceof SqlFunctionCallExpression) || this.processFunctionVariants(processor))) {
            return false;
        }
        if (Boolean.TRUE.equals(IGNORE_DATA_SOURCES.get((UserDataHolder)topOriginalFile))) {
            return true;
        }
        SqlImportState importChecker = topOriginalFile instanceof SqlFile ? SqlDialectImplUtil.getImportCheckerAt((SqlFile)topOriginalFile, (PsiElement)this.myElement) : null;
        boolean bl = includeAllTopLevelNamespaces = processor instanceof SqlCompletionScopeProcessor && ((SqlCompletionScopeProcessor)processor).getCompletionParameters().getInvocationCount() > 2;
        if (processor.dataSources.isEmpty()) {
            Condition<DasObject> expandCondition = importChecker != null ? SqlFileImpl.importedCondition(importChecker, null, includeAllTopLevelNamespaces) : Conditions.alwaysTrue();
            Project project = topContainingFile.getProject();
            Function mapper = o -> SqlImplUtil.wrapInPom(o, project);
            Dbms dbms = processor.dialect.getDbms();
            if (processor.referenceName != null) {
                ModelNameIndex miniCatIndex = DataSourceSnapshotManager.INSTANCE.getSnapshotModelIndex(dbms, Version.INFINITY);
                if (miniCatIndex == null) {
                    return true;
                }
                return SqlFileImpl.processNameIndex(processor, state, miniCatIndex, expandCondition, (Function<? super DasObject, ? extends PsiElement>)mapper);
            }
            BasicModel miniCatModel = DataSourceSnapshotManager.INSTANCE.getSnapshotModel(dbms, Version.INFINITY);
            if (miniCatModel == null) {
                return true;
            }
            JBIterable candidates = ((JBTreeTraverser)miniCatModel.traverser().expand(expandCondition)).bfsTraversal();
            return SqlFileImpl.processCandidateObjects(processor, state, processor.dialect, (JBIterable<DasObject>)candidates, (Function<? super DasObject, ? extends PsiElement>)mapper);
        }
        HashSet<String> visited = new HashSet<String>();
        LinkedList<DbDataSource> queue = new LinkedList<DbDataSource>(processor.dataSources);
        while (!queue.isEmpty()) {
            DbDataSource dataSource2 = (DbDataSource)queue.remove(0);
            if (!visited.add(dataSource2.getUniqueId()) || importChecker != null && !importChecker.isImported((DasDataSource)dataSource2.getDelegate(), null)) continue;
            DatabaseSystem d2 = dataSource2.getDelegate();
            if (d2 instanceof SqlDataSource) {
                SqlDataSource sqlDataSource = (SqlDataSource)d2;
                for (SqlFile file : sqlDataSource.getSqlFiles()) {
                    if (file.processDeclarations((PsiScopeProcessor)processor, state, (PsiElement)topContainingFile, (PsiElement)this.myElement)) continue;
                    return false;
                }
                ContainerUtil.addIfNotNull(queue, (Object)sqlDataSource.getParentDataSource());
                continue;
            }
            Condition<DasObject> condition = importChecker != null ? SqlFileImpl.importedCondition(importChecker, (DasDataSource)d2, includeAllTopLevelNamespaces) : Conditions.alwaysTrue();
            if (SqlFileImpl.processDeclarationsImpl(processor, state, (PsiObject)dataSource2, condition, true)) continue;
            return false;
        }
        return true;
    }

    private boolean processLabels(@NotNull SqlScopeProcessor processor) {
        SqlLabelHolder block;
        if (processor == null) {
            SqlReferenceImpl.$$$reportNull$$$0(30);
        }
        if ((block = (SqlLabelHolder)PsiTreeUtil.getTopmostParentOfType((PsiElement)this.myElement, SqlLabelHolder.class)) != null) {
            for (SqlDefinition label : block.getLabels()) {
                if (processor.execute((PsiElement)label, ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private Set<ObjectKind> getExpectedTargetTypes(boolean resolve, SqlLanguageDialectEx dialect, int minLev, int maxLev, boolean strict) {
        THashSet expectedStrict = this.getExpectedTargetTypesStrict(dialect);
        boolean addCallable = false;
        PsiElement parent2 = this.myElement.getParent();
        Dbms dbms = dialect.getDbms();
        if (!strict && dbms.isPostgres() && parent2 instanceof SqlExpressionList && parent2.getParent() instanceof SqlFunctionCallExpression && expectedStrict.contains(ObjectKind.COLUMN)) {
            expectedStrict = SqlReferenceImpl.makeMutable(expectedStrict);
            expectedStrict.add(ObjectKind.TABLE);
        }
        if (!resolve && !strict && (expectedStrict.contains(ObjectKind.COLUMN) || expectedStrict.contains(ObjectKind.TABLE))) {
            PsiElement info = this.myElement.getNextSibling();
            while (info instanceof PsiWhiteSpace || info instanceof PsiComment) {
                info = info.getNextSibling();
            }
            boolean bl = addCallable = SqlInfoElementType.getValue(info, SqlFunctionDefinition.ReferenceParameter.class) == null;
        }
        if (maxLev == 0) {
            if (addCallable) {
                expectedStrict = SqlReferenceImpl.makeMutable(expectedStrict);
                expectedStrict.add((ObjectKind)ObjectKind.ROUTINE);
            }
        } else {
            THashSet parents2 = new THashSet();
            if (addCallable) {
                parents2.add((Object)ObjectKind.ROUTINE);
            }
            for (ObjectKind type : expectedStrict) {
                this.getParentTypes(dialect, type, minLev, maxLev, (Set<ObjectKind>)parents2);
            }
            expectedStrict = parents2;
        }
        THashSet tHashSet = expectedStrict;
        if (tHashSet == null) {
            SqlReferenceImpl.$$$reportNull$$$0(31);
        }
        return tHashSet;
    }

    @NotNull
    private static Set<ObjectKind> makeMutable(Set<ObjectKind> expectedStrict) {
        if (!(expectedStrict instanceof THashSet)) {
            THashSet result = new THashSet();
            result.addAll(expectedStrict);
            expectedStrict = result;
        }
        THashSet tHashSet = expectedStrict;
        if (tHashSet == null) {
            SqlReferenceImpl.$$$reportNull$$$0(32);
        }
        return tHashSet;
    }

    private int getParentTypes(@NotNull SqlLanguageDialectEx dialect, ObjectKind type, int minLevel, int maxLevel, Set<ObjectKind> result) {
        if (dialect == null) {
            SqlReferenceImpl.$$$reportNull$$$0(33);
        }
        Set<ObjectKind> ignored = dialect.getIgnoredParentKinds((PsiElement)this.myElement, this.getReferenceElementType().getTargetKind());
        return SqlImplUtil.getParentTypes(dialect, type, minLevel, maxLevel, ignored, result);
    }

    @NotNull
    public Set<ObjectKind> getExpectedTargetTypesStrict(@NotNull SqlLanguageDialectEx dialect) {
        ObjectKind realLastRefType;
        ObjectKind thisTargetType;
        if (dialect == null) {
            SqlReferenceImpl.$$$reportNull$$$0(34);
        }
        if ((thisTargetType = this.getReferenceElementType().getTargetKind()) != SqlDbElementType.ANY) {
            Set set = JBIterable.of((Object)thisTargetType).append(dialect.getExtraKindsStrict(this)).toSet();
            if (set == null) {
                SqlReferenceImpl.$$$reportNull$$$0(35);
            }
            return set;
        }
        SqlElement lastRefElement = this.myElement;
        SqlReferenceImpl lastRef = this;
        int inParentLevel = 0;
        int starCount = 0;
        boolean linkReached = false;
        PsiElement parent2 = this.myElement.getParent();
        while (parent2 instanceof SqlElement && parent2.getReference() instanceof SqlReferenceImpl) {
            lastRefElement = (SqlElement)parent2;
            lastRef = (SqlReferenceImpl)parent2.getReference();
            if (!linkReached) {
                ++inParentLevel;
                if (Comparing.equal((String)"*", (String)lastRef.getReferenceName())) {
                    ++starCount;
                }
            }
            linkReached |= TreeUtil.findSibling((ASTNode)lastRefElement.getNode(), (IElementType)SqlCompositeElementTypes.SQL_GENERIC_AT_REFERENCE) != null;
            parent2 = parent2.getParent();
        }
        ObjectKind lastRefType = lastRef != this ? lastRef.getReferenceElementType().getTargetKind() : SqlDbElementType.ANY;
        ObjectKind objectKind = realLastRefType = lastRefType != SqlDbElementType.ANY || !(parent2 instanceof SqlCompositeElementImpl) ? lastRefType : ((SqlCompositeElementImpl)parent2).getExpectedReferenceTargetType(lastRefElement);
        if (lastRefType != SqlDbElementType.ANY) {
            THashSet curType = new THashSet();
            this.getParentTypes(dialect, realLastRefType, inParentLevel - starCount, inParentLevel, (Set<ObjectKind>)curType);
            for (ObjectKind extraKind : dialect.getExtraKindsStrict(lastRef)) {
                this.getParentTypes(dialect, extraKind, inParentLevel - starCount, inParentLevel, (Set<ObjectKind>)curType);
            }
            THashSet tHashSet = curType;
            if (tHashSet == null) {
                SqlReferenceImpl.$$$reportNull$$$0(36);
            }
            return tHashSet;
        }
        Set<ObjectKind> set = Collections.singleton(SqlDbElementType.ANY);
        if (set == null) {
            SqlReferenceImpl.$$$reportNull$$$0(37);
        }
        return set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlReferenceImpl that = (SqlReferenceImpl)o;
        return this.myElement.equals(that.myElement);
    }

    public int hashCode() {
        return this.myElement.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlReferenceImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTarget";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentResult";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newResult";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlReferenceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlTypeInner";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceElementType";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreference";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTargetTypes";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "makeMutable";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTargetTypesStrict";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createResolveProcessor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findConflictingResult";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPreference";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processResolveVariants";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processLabelBackRef";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "initExpectedTargetTypes";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "shouldNotBeChecked";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processFunctionVariants";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolveVariants";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processLabels";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getParentTypes";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTargetTypesStrict";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum ResolveConflictPolicy {
        DROP_EXISTING,
        DROP_NEW,
        HIDE_NEW,
        KEEP_BOTH;

    }
}

