/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.beans.parse;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfiguration;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeEnvironment;
import com.intellij.docker.compose.configuration.beans.parse.DockerComposeConfigurationParserUtil;
import com.intellij.docker.compose.configuration.beans.parse.DockerComposeConfigurationStreamParser;
import com.intellij.docker.compose.configuration.beans.v1.DockerComposeConfigurationV1;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeConfigurationV2;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class PureDockerComposeConfigurationParser
implements DockerComposeConfigurationStreamParser {
    private static final AtomicReference<PureDockerComposeConfigurationParser> ourSingleton = new AtomicReference<Object>(null);
    private static final String VERSION_1_VALUE = "1";
    @NotNull
    private final ObjectMapper myMapper;

    private PureDockerComposeConfigurationParser() {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        SimpleModule module = new SimpleModule();
        module.addDeserializer(DockerComposeConfiguration.class, (JsonDeserializer)new DockerComposeConfigurationDeserializer());
        module.addDeserializer(DockerComposeEnvironment.class, (JsonDeserializer)new DockerComposeEnvironmentDeserializer());
        mapper.registerModule((Module)module);
        this.myMapper = mapper;
    }

    public static PureDockerComposeConfigurationParser getInstance() {
        PureDockerComposeConfigurationParser result = ourSingleton.get();
        if (result == null && !ourSingleton.compareAndSet(null, result = new PureDockerComposeConfigurationParser())) {
            result = Objects.requireNonNull(ourSingleton.get());
        }
        return result;
    }

    @Override
    @NotNull
    public DockerComposeConfiguration parseBean(@NotNull Reader reader) throws IOException {
        if (reader == null) {
            PureDockerComposeConfigurationParser.$$$reportNull$$$0(0);
        }
        DockerComposeConfiguration dockerComposeConfiguration = (DockerComposeConfiguration)this.myMapper.readValue(reader, DockerComposeConfiguration.class);
        if (dockerComposeConfiguration == null) {
            PureDockerComposeConfigurationParser.$$$reportNull$$$0(1);
        }
        return dockerComposeConfiguration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public String parseVersion(@NotNull Reader reader) throws IOException {
        String string;
        Throwable throwable;
        JsonParser parser;
        block19: {
            if (reader == null) {
                PureDockerComposeConfigurationParser.$$$reportNull$$$0(2);
            }
            parser = this.myMapper.getFactory().createParser(reader);
            throwable = null;
            try {
                JsonToken token;
                if (parser.nextToken() != JsonToken.START_OBJECT) return VERSION_1_VALUE;
                while ((token = parser.nextToken()) != null && token != JsonToken.END_OBJECT) {
                    String property = parser.getCurrentName();
                    if (token == JsonToken.FIELD_NAME && "version".equals(property)) {
                        parser.nextToken();
                        String string2 = parser.getText();
                        string = string2;
                        break block19;
                    }
                    parser.skipChildren();
                }
                return VERSION_1_VALUE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        if (string != null) return string;
        PureDockerComposeConfigurationParser.$$$reportNull$$$0(3);
        return string;
        finally {
            if (parser != null) {
                if (throwable != null) {
                    try {
                        parser.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    parser.close();
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/compose/configuration/beans/parse/PureDockerComposeConfigurationParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/compose/configuration/beans/parse/PureDockerComposeConfigurationParser";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseBean";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseBean";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DockerComposeEnvironmentDeserializer
    extends JsonDeserializer<DockerComposeEnvironment> {
        private DockerComposeEnvironmentDeserializer() {
        }

        public DockerComposeEnvironment deserialize(JsonParser jp, DeserializationContext context) throws IOException {
            TreeNode node = jp.readValueAsTree();
            if (node.isArray()) {
                List list = (List)PureDockerComposeConfigurationParser.this.myMapper.convertValue((Object)node, (JavaType)context.getTypeFactory().constructCollectionType(List.class, String.class));
                return DockerComposeEnvironment.fromList(list);
            }
            if (node.isObject()) {
                Map map = (Map)PureDockerComposeConfigurationParser.this.myMapper.convertValue((Object)node, (JavaType)context.getTypeFactory().constructMapType(Map.class, String.class, Object.class));
                return DockerComposeEnvironment.fromMap(map);
            }
            throw context.mappingException("Environment is expected to be either dictionary or list");
        }
    }

    private class DockerComposeConfigurationDeserializer
    extends JsonDeserializer<DockerComposeConfiguration> {
        private DockerComposeConfigurationDeserializer() {
        }

        public DockerComposeConfiguration deserialize(JsonParser jp, DeserializationContext context) throws IOException {
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            JsonNode versionField = node.get("version");
            if (versionField != null && versionField.isTextual()) {
                String version = versionField.textValue();
                String majorVersion = DockerComposeConfigurationParserUtil.getMajorVersion(version);
                if ("2".equals(majorVersion) || "3".equals(majorVersion)) {
                    return (DockerComposeConfiguration)PureDockerComposeConfigurationParser.this.myMapper.treeToValue((TreeNode)node, DockerComposeConfigurationV2.class);
                }
                throw context.mappingException("Unsupported docker compose configuration version: %s", new Object[]{version});
            }
            return (DockerComposeConfiguration)PureDockerComposeConfigurationParser.this.myMapper.treeToValue((TreeNode)node, DockerComposeConfigurationV1.class);
        }
    }
}

