/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view.details;

import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.view.details.DockerLogsPanel;
import com.intellij.docker.view.details.ITabManager;
import com.intellij.docker.view.details.LoggingHandlerTab;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerBase;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.ui.content.Content;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\fH\u0014R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/docker/view/details/ContainerLogTab;", "Lcom/intellij/docker/view/details/LoggingHandlerTab;", "tabManager", "Lcom/intellij/docker/view/details/ITabManager;", "title", "", "(Lcom/intellij/docker/view/details/ITabManager;Ljava/lang/String;)V", "myLogsPanel", "Lcom/intellij/docker/view/details/DockerLogsPanel;", "doCreateContent", "Lcom/intellij/ui/content/Content;", "handler", "Lcom/intellij/remoteServer/impl/runtime/log/LoggingHandlerBase;", "ensureHasLogsIfDeployed", "", "refreshTab", "selected", "", "replaceLoggingHandler", "newHandler", "intellij.clouds.docker"})
public final class ContainerLogTab
extends LoggingHandlerTab {
    private DockerLogsPanel myLogsPanel;

    @Override
    @NotNull
    protected Content doCreateContent() {
        Content content;
        block0: {
            DockerLogsPanel dockerLogsPanel = new DockerLogsPanel();
            boolean bl = false;
            boolean bl2 = false;
            DockerLogsPanel it = dockerLogsPanel;
            boolean bl3 = false;
            this.myLogsPanel = it;
            DockerLogsPanel logsPanel = dockerLogsPanel;
            Content content2 = this.getContentManager().getFactory().createContent((JComponent)logsPanel.getMainPanel(), this.getTitle(), true);
            Intrinsics.checkExpressionValueIsNotNull((Object)content2, (String)"contentManager.factory.c\u2026l.mainPanel, title, true)");
            content = content2;
            this.getTabManager().insertTabContent(this, content);
            content.setCloseable(false);
            DockerApplicationRuntime dockerApplicationRuntime = this.getRuntimeImpl();
            if (dockerApplicationRuntime == null) break block0;
            dockerApplicationRuntime.showLog(this.getProject(), EmptyRunnable.getInstance());
        }
        return content;
    }

    @Override
    @NotNull
    protected Content doCreateContent(@NotNull LoggingHandlerBase handler2) {
        Intrinsics.checkParameterIsNotNull((Object)handler2, (String)"handler");
        throw (Throwable)new UnsupportedOperationException("Should be created with placeholder in advance");
    }

    @Override
    public void refreshTab(boolean selected) {
        super.refreshTab(selected);
        if (selected) {
            this.ensureHasLogsIfDeployed();
        }
    }

    private final void ensureHasLogsIfDeployed() {
        boolean bl;
        DeploymentStatus deploymentStatus;
        DockerApplicationRuntime runtime;
        block7: {
            DockerApplicationRuntime dockerApplicationRuntime = runtime = this.getRuntimeImpl();
            if ((dockerApplicationRuntime != null ? dockerApplicationRuntime.getContainerId() : null) == null) {
                return;
            }
            DeploymentStatus deploymentStatus2 = this.getDeployment().getStatus();
            Intrinsics.checkExpressionValueIsNotNull((Object)deploymentStatus2, (String)"deployment.status");
            deploymentStatus = deploymentStatus2;
            if (Intrinsics.areEqual((Object)deploymentStatus, (Object)DeploymentStatus.DEPLOYED) ^ true) {
                return;
            }
            List<LoggingHandlerBase> logs = this.findSuitableLogHandlers();
            Iterable $this$all$iv = logs;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    LoggingHandlerBase it = (LoggingHandlerBase)element$iv;
                    boolean bl2 = false;
                    if (it.isClosed()) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        if (bl) {
            if (LoggingHandlerTab.Companion.getLOG().isTraceEnabled()) {
                DeploymentStatus deploymentStatus3 = runtime.getStatus();
                String runtimeStatusText = deploymentStatus3 != null ? deploymentStatus3.getPresentableText() : null;
                LoggingHandlerTab.Companion.getLOG().trace(this + ": Requesting new pipe, container is deployed but no open logs: " + "Deployment status: " + deploymentStatus.getPresentableText() + ", runtime status: " + runtimeStatusText);
            }
            runtime.showLog(this.getProject(), EmptyRunnable.getInstance());
        }
    }

    @Override
    protected void replaceLoggingHandler(@NotNull LoggingHandlerBase newHandler) {
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)newHandler, (String)"newHandler");
            boolean bl = !Disposer.isDisposed((Disposable)((Disposable)newHandler));
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            DockerLogsPanel logsPanel = this.myLogsPanel;
            if (logsPanel == null) {
                return;
            }
            boolean handlerChanged = logsPanel.setLoggingHandler(newHandler);
            if (!handlerChanged) break block3;
            Content content = this.getContent();
            if (content != null) {
                Content content2 = content;
                boolean bl5 = false;
                boolean bl6 = false;
                Content it = content2;
                boolean bl7 = false;
                LoggingHandlerTab.Companion.attachLoggingHandler$intellij_clouds_docker(it, newHandler);
                it.setActions(logsPanel.getToolbarActions(), "DockerLogsPanel#Toolbar", newHandler.getComponent());
            }
        }
    }

    public ContainerLogTab(@NotNull ITabManager tabManager, @NotNull String title) {
        Intrinsics.checkParameterIsNotNull((Object)tabManager, (String)"tabManager");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        super(tabManager, "Log", title);
    }

    public /* synthetic */ ContainerLogTab(ITabManager iTabManager, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            String string2 = DockerBundle.message("ContainerLogTab.title", new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"DockerBundle.message(\"ContainerLogTab.title\")");
            string = string2;
        }
        this(iTabManager, string);
    }
}

