/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.icons.AllIcons;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.xml.XmlBundle;
import java.util.List;
import java.util.UUID;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ConfigurableWebBrowser
extends WebBrowser {
    private final UUID id;
    @NotNull
    private BrowserFamily family;
    @NotNull
    private String name;
    private boolean active;
    private String path;
    private BrowserSpecificSettings specificSettings;

    ConfigurableWebBrowser() {
        this(UUID.randomUUID(), BrowserFamily.CHROME);
    }

    ConfigurableWebBrowser(@NotNull UUID id, @NotNull BrowserFamily family) {
        if (id == null) {
            ConfigurableWebBrowser.$$$reportNull$$$0(0);
        }
        if (family == null) {
            ConfigurableWebBrowser.$$$reportNull$$$0(1);
        }
        this(id, family, family.getName(), family.getExecutionPath(), true, family.createBrowserSpecificSettings());
    }

    ConfigurableWebBrowser(@NotNull UUID id, @NotNull BrowserFamily family, @NotNull String name, @Nullable String path, boolean active, @Nullable BrowserSpecificSettings specificSettings) {
        if (id == null) {
            ConfigurableWebBrowser.$$$reportNull$$$0(2);
        }
        if (family == null) {
            ConfigurableWebBrowser.$$$reportNull$$$0(3);
        }
        if (name == null) {
            ConfigurableWebBrowser.$$$reportNull$$$0(4);
        }
        this.id = id;
        this.family = family;
        this.name = name;
        this.path = StringUtil.nullize((String)path);
        this.active = active;
        this.specificSettings = specificSettings;
    }

    public void setName(@NotNull String value) {
        if (value == null) {
            ConfigurableWebBrowser.$$$reportNull$$$0(5);
        }
        this.name = value;
    }

    public void setFamily(@NotNull BrowserFamily value) {
        if (value == null) {
            ConfigurableWebBrowser.$$$reportNull$$$0(6);
        }
        this.family = value;
    }

    @NotNull
    public Icon getIcon() {
        if (this.family == BrowserFamily.CHROME) {
            if (WebBrowserManager.isYandexBrowser(this)) {
                Icon icon = AllIcons.Xml.Browsers.Yandex16;
                if (icon == null) {
                    ConfigurableWebBrowser.$$$reportNull$$$0(7);
                }
                return icon;
            }
            if (this.checkNameAndPath("Dartium") || this.checkNameAndPath("Chromium")) {
                Icon icon = AllIcons.Xml.Browsers.Chromium16;
                if (icon == null) {
                    ConfigurableWebBrowser.$$$reportNull$$$0(8);
                }
                return icon;
            }
            if (this.checkNameAndPath("Canary")) {
                Icon icon = AllIcons.Xml.Browsers.Canary16;
                if (icon == null) {
                    ConfigurableWebBrowser.$$$reportNull$$$0(9);
                }
                return icon;
            }
            if (this.checkNameAndPath("Opera")) {
                Icon icon = AllIcons.Xml.Browsers.Opera16;
                if (icon == null) {
                    ConfigurableWebBrowser.$$$reportNull$$$0(10);
                }
                return icon;
            }
            if (this.checkNameAndPath("node-webkit") || this.checkNameAndPath("nw") || this.checkNameAndPath("nwjs")) {
                Icon icon = AllIcons.Xml.Browsers.Nwjs16;
                if (icon == null) {
                    ConfigurableWebBrowser.$$$reportNull$$$0(11);
                }
                return icon;
            }
        } else if (this.family == BrowserFamily.EXPLORER && WebBrowserManager.isEdge(this)) {
            Icon icon = AllIcons.Xml.Browsers.Edge16;
            if (icon == null) {
                ConfigurableWebBrowser.$$$reportNull$$$0(12);
            }
            return icon;
        }
        Icon icon = this.family.getIcon();
        if (icon == null) {
            ConfigurableWebBrowser.$$$reportNull$$$0(13);
        }
        return icon;
    }

    private boolean checkNameAndPath(@NotNull String what) {
        if (what == null) {
            ConfigurableWebBrowser.$$$reportNull$$$0(14);
        }
        return WebBrowserManager.checkNameAndPath(what, this);
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    public void setPath(@Nullable String value) {
        this.path = PathUtil.toSystemIndependentName((String)StringUtil.nullize((String)value));
    }

    @Nullable
    public BrowserSpecificSettings getSpecificSettings() {
        return this.specificSettings;
    }

    public void setSpecificSettings(@Nullable BrowserSpecificSettings value) {
        this.specificSettings = value;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean value) {
        this.active = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigurableWebBrowser)) {
            return false;
        }
        ConfigurableWebBrowser browser2 = (ConfigurableWebBrowser)((Object)o);
        return this.getId().equals(browser2.getId()) && this.family.equals((Object)browser2.family) && this.active == browser2.active && Comparing.strEqual((String)this.name, (String)browser2.name) && Comparing.equal((String)this.path, (String)browser2.path) && Comparing.equal((Object)this.specificSettings, (Object)browser2.specificSettings);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            ConfigurableWebBrowser.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public final UUID getId() {
        UUID uUID = this.id;
        if (uUID == null) {
            ConfigurableWebBrowser.$$$reportNull$$$0(16);
        }
        return uUID;
    }

    @NotNull
    public BrowserFamily getFamily() {
        BrowserFamily browserFamily = this.family;
        if (browserFamily == null) {
            ConfigurableWebBrowser.$$$reportNull$$$0(17);
        }
        return browserFamily;
    }

    @NotNull
    public String getBrowserNotFoundMessage() {
        String string = XmlBundle.message((String)"error.0.browser.path.not.specified", (Object[])new Object[]{this.getName()});
        if (string == null) {
            ConfigurableWebBrowser.$$$reportNull$$$0(18);
        }
        return string;
    }

    public void addOpenUrlParameter(@NotNull List<? super String> command, @NotNull String url) {
        if (command == null) {
            ConfigurableWebBrowser.$$$reportNull$$$0(19);
        }
        if (url == null) {
            ConfigurableWebBrowser.$$$reportNull$$$0(20);
        }
        if (WebBrowserManager.isEdge(this) && !command.isEmpty()) {
            command.set(command.size() - 1, command.get(command.size() - 1) + ":" + url);
        } else {
            super.addOpenUrlParameter(command, url);
        }
    }

    public String toString() {
        return this.getName() + " (" + this.getPath() + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/browsers/ConfigurableWebBrowser";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/browsers/ConfigurableWebBrowser";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamily";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowserNotFoundMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setFamily";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkNameAndPath";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addOpenUrlParameter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

