/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.agent.util.CloudGitApplication;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfigurationBase;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.ModuleDeploymentSource;
import com.intellij.remoteServer.util.CloudConnectionTask;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudGitDeploymentDetector;
import com.intellij.remoteServer.util.CloudGitDeploymentRuntime;
import com.intellij.remoteServer.util.CloudMultiSourceServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import git4idea.GitUtil;
import git4idea.repo.GitRepository;
import java.io.File;
import java.util.List;

public class CloudGitDeploymentChecker<T extends CloudDeploymentNameConfiguration, SC extends ServerConfigurationBase, SR extends CloudMultiSourceServerRuntimeInstance<T, ?, ?, ?>> {
    private final CloudGitDeploymentDetector myDetector;

    public CloudGitDeploymentChecker(CloudGitDeploymentDetector detector) {
        this.myDetector = detector;
    }

    public void checkGitUrl(RemoteServer<SC> server, final DeploymentSource deploymentSource, T settings) throws RuntimeConfigurationException {
        if (!(deploymentSource instanceof ModuleDeploymentSource)) {
            return;
        }
        ModuleDeploymentSource moduleSource = (ModuleDeploymentSource)deploymentSource;
        Module module = moduleSource.getModule();
        if (module == null) {
            return;
        }
        File contentRootFile = deploymentSource.getFile();
        if (contentRootFile == null) {
            return;
        }
        Project project = module.getProject();
        VirtualFile contentRoot = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(contentRootFile);
        if (contentRoot == null) {
            return;
        }
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager((Project)project).getRepositoryForRoot(contentRoot);
        if (repository == null) {
            return;
        }
        String expectedName = settings.getDeploymentSourceName(deploymentSource);
        List<String> appNames = this.myDetector.collectApplicationNames(repository);
        if (appNames.isEmpty() || appNames.contains(expectedName)) {
            return;
        }
        RuntimeConfigurationWarning warning = new RuntimeConfigurationWarning("Cloud Git URL found in repository, but it doesn't match the run configuration");
        warning.setQuickFix(() -> {
            CloudGitApplication application = (CloudGitApplication)new CloudConnectionTask<CloudGitApplication, SC, T, SR>(project, "Searching for application", (RemoteServer)server, (CloudDeploymentNameConfiguration)settings, project){
                final /* synthetic */ CloudDeploymentNameConfiguration val$settings;
                final /* synthetic */ Project val$project;
                {
                    this.val$settings = cloudDeploymentNameConfiguration;
                    this.val$project = project;
                    super(arg0, arg1, arg2);
                }

                protected CloudGitApplication run(SR serverRuntime) throws ServerRuntimeException {
                    CloudGitDeploymentRuntime deploymentRuntime = (CloudGitDeploymentRuntime)serverRuntime.createDeploymentRuntime(deploymentSource, this.val$settings, this.val$project);
                    return deploymentRuntime.findApplication4Repository();
                }
            }.performSync();
            if (application == null) {
                Messages.showErrorDialog((Project)project, (String)CloudBundle.message((String)"dialog.message.no.application.matching.repository.url.s.found.in.account", (Object[])new Object[0]), (String)server.getName());
            } else {
                settings.setDefaultDeploymentName(false);
                settings.setDeploymentName(application.getName());
            }
        });
        throw warning;
    }
}

