/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.CompletionVariant;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupValueWithUIHint;
import com.intellij.codeInsight.lookup.PresentableLookupValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.paths.PsiDynaReference;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.CharPattern;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.TrueFilter;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class CompletionData {
    private static final Logger LOG = Logger.getInstance(CompletionData.class);
    public static final ObjectPattern.Capture<Character> NOT_JAVA_ID = StandardPatterns.not((ElementPattern)CharPattern.javaIdentifierPartCharacter());
    private final List<CompletionVariant> myCompletionVariants = new ArrayList<CompletionVariant>();
    protected final CompletionVariant myGenericVariant = new CompletionVariant(){

        @Override
        void addReferenceCompletions(PsiReference reference2, PsiElement position, Set<? super LookupElement> set, PsiFile file2, CompletionData completionData) {
            CompletionData.this.completeReference(reference2, position, set, TailType.NONE, TrueFilter.INSTANCE, this);
        }
    };

    protected CompletionData() {
    }

    private boolean isScopeAcceptable(PsiElement scope) {
        for (CompletionVariant variant : this.myCompletionVariants) {
            if (!variant.isScopeAcceptable(scope)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    protected void registerVariant(CompletionVariant variant) {
        this.myCompletionVariants.add(variant);
    }

    public void completeReference(PsiReference reference2, Set<? super LookupElement> set, @NotNull PsiElement position, PsiFile file2) {
        if (position == null) {
            CompletionData.$$$reportNull$$$0(0);
        }
        CompletionVariant[] variants = this.findVariants(position, file2);
        boolean hasApplicableVariants = false;
        for (CompletionVariant variant : variants) {
            if (!variant.hasReferenceFilter()) continue;
            variant.addReferenceCompletions(reference2, position, set, file2, this);
            hasApplicableVariants = true;
        }
        if (!hasApplicableVariants) {
            this.myGenericVariant.addReferenceCompletions(reference2, position, set, file2, this);
        }
    }

    public void addKeywordVariants(Set<? super CompletionVariant> set, PsiElement position, PsiFile file2) {
        ContainerUtil.addAll(set, (Object[])this.findVariants(position, file2));
    }

    void completeKeywordsBySet(Set<LookupElement> set, Set<? extends CompletionVariant> variants) {
        for (CompletionVariant completionVariant : variants) {
            completionVariant.addKeywords(set, this);
        }
    }

    public String findPrefix(PsiElement insertedElement, int offsetInFile) {
        return CompletionData.findPrefixStatic(insertedElement, offsetInFile);
    }

    public CompletionVariant[] findVariants(PsiElement position, PsiFile file2) {
        ArrayList<CompletionVariant> variants = new ArrayList<CompletionVariant>();
        PsiElement scope = position;
        if (scope == null) {
            scope = file2;
        }
        while (scope != null) {
            boolean breakFlag = false;
            if (this.isScopeAcceptable(scope)) {
                for (CompletionVariant variant : this.myCompletionVariants) {
                    if (!variant.isVariantApplicable(position, scope) || variants.contains(variant)) continue;
                    variants.add(variant);
                    if (!variant.isScopeFinal(scope)) continue;
                    breakFlag = true;
                }
            }
            if (!breakFlag && !((scope = scope.getContext()) instanceof PsiDirectory)) continue;
            break;
        }
        return variants.toArray(new CompletionVariant[0]);
    }

    @Nullable
    public static String getReferencePrefix(@NotNull PsiElement insertedElement, int offsetInFile) {
        if (insertedElement == null) {
            CompletionData.$$$reportNull$$$0(1);
        }
        try {
            PsiUtilCore.ensureValid((PsiElement)insertedElement);
            PsiReference ref = insertedElement.getContainingFile().findReferenceAt(offsetInFile);
            if (ref != null) {
                PsiElement element2 = ref.getElement();
                int offsetInElement = offsetInFile - element2.getTextRange().getStartOffset();
                for (TextRange refRange : ReferenceRange.getRanges((PsiReference)ref)) {
                    if (!refRange.contains(offsetInElement)) continue;
                    int beginIndex = refRange.getStartOffset();
                    String text2 = element2.getText();
                    if (beginIndex < 0 || beginIndex > offsetInElement || offsetInElement > text2.length()) {
                        throw new AssertionError((Object)("Inconsistent reference range: ref=" + ref.getClass() + " element=" + element2.getClass() + " ref.start=" + refRange.getStartOffset() + " offset=" + offsetInElement + " psi.length=" + text2.length()));
                    }
                    return text2.substring(beginIndex, offsetInElement);
                }
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        return null;
    }

    public static String findPrefixStatic(PsiElement insertedElement, int offsetInFile, ElementPattern<Character> prefixStartTrim) {
        if (insertedElement == null) {
            return "";
        }
        Document document = insertedElement.getContainingFile().getViewProvider().getDocument();
        assert (document != null);
        LOG.assertTrue(!PsiDocumentManager.getInstance((Project)insertedElement.getProject()).isUncommited(document), (Object)"Uncommitted");
        String prefix = CompletionData.getReferencePrefix(insertedElement, offsetInFile);
        if (prefix != null) {
            return prefix;
        }
        if (insertedElement.getTextRange().equals((Object)insertedElement.getContainingFile().getTextRange()) || insertedElement instanceof PsiComment) {
            return CompletionUtil.findJavaIdentifierPrefix(insertedElement, offsetInFile);
        }
        return CompletionData.findPrefixDefault(insertedElement, offsetInFile, prefixStartTrim);
    }

    public static String findPrefixStatic(PsiElement insertedElement, int offsetInFile) {
        return CompletionData.findPrefixStatic(insertedElement, offsetInFile, NOT_JAVA_ID);
    }

    public static String findPrefixDefault(PsiElement insertedElement, int offset, @NotNull ElementPattern trimStart) {
        int i;
        String substr;
        if (trimStart == null) {
            CompletionData.$$$reportNull$$$0(2);
        }
        if ((substr = insertedElement.getText().substring(0, offset - insertedElement.getTextRange().getStartOffset())).length() == 0 || Character.isWhitespace(substr.charAt(substr.length() - 1))) {
            return "";
        }
        substr = substr.trim();
        for (i = 0; substr.length() > i && trimStart.accepts((Object)Character.valueOf(substr.charAt(i))); ++i) {
        }
        return substr.substring(i).trim();
    }

    @NotNull
    public static LookupElement objectToLookupItem(@NotNull Object object) {
        if (object == null) {
            CompletionData.$$$reportNull$$$0(3);
        }
        if (object instanceof LookupElement) {
            LookupElement lookupElement = (LookupElement)object;
            if (lookupElement == null) {
                CompletionData.$$$reportNull$$$0(4);
            }
            return lookupElement;
        }
        String s = null;
        TailType tailType = TailType.NONE;
        if (object instanceof PsiElement) {
            s = PsiUtilCore.getName((PsiElement)((PsiElement)object));
        } else if (object instanceof PsiMetaData) {
            s = ((PsiMetaData)object).getName();
        } else if (object instanceof String) {
            s = (String)object;
        } else if (object instanceof PresentableLookupValue) {
            s = ((PresentableLookupValue)object).getPresentation();
        }
        if (s == null) {
            throw new AssertionError((Object)("Null string for object: " + object + " of class " + object.getClass()));
        }
        LookupItem<Object> item = new LookupItem<Object>(object, s);
        if (object instanceof LookupValueWithUIHint && ((LookupValueWithUIHint)object).isBold()) {
            item.setBold();
        }
        item.setAttribute(LookupItem.TAIL_TYPE_ATTR, (Object)tailType);
        LookupItem<Object> lookupItem = item;
        if (lookupItem == null) {
            CompletionData.$$$reportNull$$$0(5);
        }
        return lookupItem;
    }

    protected void addLookupItem(Set<? super LookupElement> set, TailType tailType, @NotNull Object completion, CompletionVariant variant) {
        LookupElement ret;
        if (completion == null) {
            CompletionData.$$$reportNull$$$0(6);
        }
        if (!((ret = CompletionData.objectToLookupItem(completion)) instanceof LookupItem)) {
            set.add((LookupElement)ret);
            return;
        }
        LookupItem item = (LookupItem)ret;
        InsertHandler insertHandler = variant.getInsertHandler();
        if (insertHandler != null && item.getInsertHandler() == null) {
            item.setInsertHandler(insertHandler);
            item.setTailType(TailType.UNKNOWN);
        } else if (tailType != TailType.NONE) {
            item.setTailType(tailType);
        }
        Map<Object, Object> itemProperties = variant.getItemProperties();
        for (Object key : itemProperties.keySet()) {
            item.setAttribute(key, itemProperties.get(key));
        }
        set.add((LookupElement)ret);
    }

    protected void completeReference(PsiReference reference2, PsiElement position, Set<? super LookupElement> set, TailType tailType, ElementFilter filter2, CompletionVariant variant) {
        if (reference2 instanceof PsiMultiReference) {
            for (PsiReference ref : CompletionData.getReferences((PsiMultiReference)reference2)) {
                this.completeReference(ref, position, set, tailType, filter2, variant);
            }
        } else if (reference2 instanceof PsiDynaReference) {
            for (PsiReference ref : ((PsiDynaReference)reference2).getReferences()) {
                this.completeReference(ref, position, set, tailType, filter2, variant);
            }
        } else {
            Object[] completions;
            for (Object completion : completions = reference2.getVariants()) {
                Object o;
                if (completion == null) {
                    LOG.error("Position=" + position + "\n;Reference=" + reference2 + "\n;variants=" + Arrays.toString(completions));
                    continue;
                }
                if (completion instanceof PsiElement) {
                    PsiElement psiElement = (PsiElement)completion;
                    if (!filter2.isClassAcceptable(psiElement.getClass()) || !filter2.isAcceptable((Object)psiElement, position)) continue;
                    this.addLookupItem(set, tailType, completion, variant);
                    continue;
                }
                if (completion instanceof LookupItem && (o = ((LookupItem)completion).getObject()) instanceof PsiElement && (!filter2.isClassAcceptable(o.getClass()) || !filter2.isAcceptable(o, position))) continue;
                try {
                    this.addLookupItem(set, tailType, completion, variant);
                }
                catch (AssertionError e) {
                    LOG.error("Caused by variant from reference: " + reference2.getClass(), (Throwable)((Object)e));
                }
            }
        }
    }

    protected static PsiReference[] getReferences(PsiMultiReference multiReference) {
        Object[] references = multiReference.getReferences();
        List hard = ContainerUtil.findAll((Object[])references, object -> !object.isSoft());
        if (!hard.isEmpty()) {
            return hard.toArray(PsiReference.EMPTY_ARRAY);
        }
        return references;
    }

    void addKeywords(Set<LookupElement> set, CompletionVariant variant, Object comp, TailType tailType) {
        if (!(comp instanceof String)) {
            return;
        }
        for (LookupElement item : set) {
            if (!item.getObject().toString().equals(comp)) continue;
            return;
        }
        this.addLookupItem(set, tailType, comp, variant);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertedElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trimStart";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/CompletionData";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/CompletionData";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "objectToLookupItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "completeReference";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getReferencePrefix";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findPrefixDefault";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "objectToLookupItem";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addLookupItem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

